import React from "react";
import { OSDivider } from "../divider";
import { TabView, TabPanel } from "primereact/tabview";
import OSNote from "./OSNote";
import { OSLabel } from "../label";

interface Props {
  user: string;
  property?: string;
  site: string;
}

const OSHistory: React.FC<Props> = ({ ...props }) => {
  const noteHeader = () => {
    return (
      <OSLabel
        leadingIcon="notes"
        label="Notes"
      />
    );
  };

  return (
    <>
      <OSDivider open={false} label={{ label: "History", leadingIcon: "rectangle-history", tag: "h3" }}>
        <div className="w-full">
          <TabView className="w-full" activeIndex={0}>
            <TabPanel header={noteHeader()} className="">
              <div className="flex w-full">
                <OSNote user={props.user} site={props.site} />
              </div>
            </TabPanel>
          </TabView>
        </div>
      </OSDivider>
    </>
  );
};

export default OSHistory;