import React from "react";
import { OSIcon } from "./icon";

import { type FontAwesome6Props } from "../types/fa-icons";

/** 
 * @deprecated 2025-07-01 - use {@link OSIcon} instead.
 */
const FAIcon: React.FC<
  FontAwesome6Props & React.HTMLAttributes<HTMLElement>
> = ({
  identifier,

  // Family
  duotone = false,
  sharp = false,
  sharpDuotone = false,
  brand = false,

  // Weight
  regular = false,
  light = false,
  thin = false,

  // Others
  size = null,
  flip = null,
  rotate = null,
  animate = null,
  ...props
}) => {
  const classItems: string[] = [];

  if (duotone) {
    classItems.push(`fa-duotone`);
  } else if (sharp) {
    classItems.push(`fa-sharp`);
  } else if (sharpDuotone) {
    classItems.push(`fa-sharp-duotone`);
  } else if (brand) {
    classItems.push(`fa-brand`);
  }

  if (regular) {
    classItems.push(`fa-regular`);
  } else if (light) {
    classItems.push(`fa-light`);
  } else if (thin) {
    classItems.push(`fa-thin`);
  } else {
    classItems.push(`fa-solid`);
  }
  
  classItems.push(`fa-${identifier}`);

  if (size !== null) {
    classItems.push(`fa-${size}`);
  }

  if (flip !== null) {
    classItems.push(`fa-flip-${flip}`);
  }

  if (rotate !== null) {
    classItems.push(`fa-rotate-${rotate}`);
  }

  if (animate !== null) {
    if (animate === "spin-reverse") {
      classItems.push(`fa-spin fa-spin-reverse`);
    } else {
      classItems.push(`fa-${animate}`);
    }
  }

  if (props.className !== undefined) {
    const { className, ...rest } = props;
    classItems.push(className);
    props = rest;
  }

  return <i className={classItems.join(" ")} {...props} />;
};

export default FAIcon;
