import { md5 } from "../crypto";
import { expect, test } from "vitest";

function getFormattedTimestamp(): string {
  const now = new Date();

  const year = now.getFullYear();
  const month = String(now.getMonth() + 1).padStart(2, "0");
  const day = String(now.getDate()).padStart(2, "0");
  const hours = String(now.getHours()).padStart(2, "0");
  const minutes = String(now.getMinutes()).padStart(2, "0");
  const seconds = String(now.getSeconds()).padStart(2, "0");

  return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
}

test("Exect MD5 to work as expected", () => {
  const string = getFormattedTimestamp();
  expect(md5(string)).toBe(md5(string));
  const string2 = 'The rain in Spain'
  const md52 = '5fb9c9e36726918bf3615b4d0544352d'
  expect(md5(string2)).toBe(md52)
});
