import React from "react";

export const SetTitle = (pageTitle: string) => {
  React.useEffect(() => {
    document.title = pageTitle;
  }, [pageTitle]);
};

export const ClearData = () => {
  React.useEffect(() => {
    const pageElement: HTMLDivElement | null =
      document.querySelector("#app[data-page]");
    if (pageElement) {
      pageElement.dataset.page = "";
    }
  }, []);
};
