class MD5Hash {
  public text: string;

  constructor(text: string) {
    this.text = text;
  }

  public hash() {
    const r = this.M(this.V(this.Y(this.X(this.text), 8 * this.text.length)));
    return r.toLowerCase();
  }

  private M(d: string): string {
    const hexDigits = "0123456789ABCDEF";
    let result = "";

    for (let i = 0; i < d.length; i++) {
      const charCode = d.charCodeAt(i);
      result += hexDigits[(charCode >>> 4) & 0x0f] + hexDigits[charCode & 0x0f];
    }

    return result;
  }

  private X(d: string): number[] {
    const result: number[] = new Array(d.length >> 2).fill(0);

    for (let i = 0; i < 8 * d.length; i += 8) {
      result[i >> 5] |= (d.charCodeAt(i / 8) & 255) << i % 32;
    }

    return result;
  }

  private V(d: number[]): string {
    let result = "";

    for (let i = 0; i < 32 * d.length; i += 8) {
      const charCode = (d[i >> 5] >>> i % 32) & 255;
      result += String.fromCharCode(charCode);
    }

    return result;
  }

  private Y(d: number[], bitLength: number): number[] {
    d[bitLength >> 5] |= 0x80 << bitLength % 32;
    d[14 + (((bitLength + 64) >>> 9) << 4)] = bitLength;

    let m = 1732584193;
    let f = -271733879;
    let r = -1732584194;
    let i = 271733878;

    for (let n = 0; n < d.length; n += 16) {
      const h = m;
      const t = f;
      const g = r;
      const e = i;

      m = this.md5_ff(m, f, r, i, d[n + 0], 7, -680876936);
      i = this.md5_ff(i, m, f, r, d[n + 1], 12, -389564586);
      r = this.md5_ff(r, i, m, f, d[n + 2], 17, 606105819);
      f = this.md5_ff(f, r, i, m, d[n + 3], 22, -1044525330);

      m = this.md5_ff(m, f, r, i, d[n + 4], 7, -176418897);
      i = this.md5_ff(i, m, f, r, d[n + 5], 12, 1200080426);
      r = this.md5_ff(r, i, m, f, d[n + 6], 17, -1473231341);
      f = this.md5_ff(f, r, i, m, d[n + 7], 22, -45705983);

      m = this.md5_ff(m, f, r, i, d[n + 8], 7, 1770035416);
      i = this.md5_ff(i, m, f, r, d[n + 9], 12, -1958414417);
      r = this.md5_ff(r, i, m, f, d[n + 10], 17, -42063);
      f = this.md5_ff(f, r, i, m, d[n + 11], 22, -1990404162);

      m = this.md5_ff(m, f, r, i, d[n + 12], 7, 1804603682);
      i = this.md5_ff(i, m, f, r, d[n + 13], 12, -40341101);
      r = this.md5_ff(r, i, m, f, d[n + 14], 17, -1502002290);
      f = this.md5_ff(f, r, i, m, d[n + 15], 22, 1236535329);

      m = this.md5_gg(m, f, r, i, d[n + 1], 5, -165796510);
      i = this.md5_gg(i, m, f, r, d[n + 6], 9, -1069501632);
      r = this.md5_gg(r, i, m, f, d[n + 11], 14, 643717713);
      f = this.md5_gg(f, r, i, m, d[n + 0], 20, -373897302);

      m = this.md5_gg(m, f, r, i, d[n + 5], 5, -701558691);
      i = this.md5_gg(i, m, f, r, d[n + 10], 9, 38016083);
      r = this.md5_gg(r, i, m, f, d[n + 15], 14, -660478335);
      f = this.md5_gg(f, r, i, m, d[n + 4], 20, -405537848);

      m = this.md5_gg(m, f, r, i, d[n + 9], 5, 568446438);
      i = this.md5_gg(i, m, f, r, d[n + 14], 9, -1019803690);
      r = this.md5_gg(r, i, m, f, d[n + 3], 14, -187363961);
      f = this.md5_gg(f, r, i, m, d[n + 8], 20, 1163531501);

      m = this.md5_gg(m, f, r, i, d[n + 13], 5, -1444681467);
      i = this.md5_gg(i, m, f, r, d[n + 2], 9, -51403784);
      r = this.md5_gg(r, i, m, f, d[n + 7], 14, 1735328473);
      f = this.md5_gg(f, r, i, m, d[n + 12], 20, -1926607734);

      m = this.md5_hh(m, f, r, i, d[n + 5], 4, -378558);
      i = this.md5_hh(i, m, f, r, d[n + 8], 11, -2022574463);
      r = this.md5_hh(r, i, m, f, d[n + 11], 16, 1839030562);
      f = this.md5_hh(f, r, i, m, d[n + 14], 23, -35309556);

      m = this.md5_hh(m, f, r, i, d[n + 1], 4, -1530992060);
      i = this.md5_hh(i, m, f, r, d[n + 4], 11, 1272893353);
      r = this.md5_hh(r, i, m, f, d[n + 7], 16, -155497632);
      f = this.md5_hh(f, r, i, m, d[n + 10], 23, -1094730640);

      m = this.md5_hh(m, f, r, i, d[n + 13], 4, 681279174);
      i = this.md5_hh(i, m, f, r, d[n + 0], 11, -358537222);
      r = this.md5_hh(r, i, m, f, d[n + 3], 16, -722521979);
      f = this.md5_hh(f, r, i, m, d[n + 6], 23, 76029189);

      m = this.md5_hh(m, f, r, i, d[n + 9], 4, -640364487);
      i = this.md5_hh(i, m, f, r, d[n + 12], 11, -421815835);
      r = this.md5_hh(r, i, m, f, d[n + 15], 16, 530742520);
      f = this.md5_hh(f, r, i, m, d[n + 2], 23, -995338651);

      m = this.md5_ii(m, f, r, i, d[n + 0], 6, -198630844);
      i = this.md5_ii(i, m, f, r, d[n + 7], 10, 1126891415);
      r = this.md5_ii(r, i, m, f, d[n + 14], 15, -1416354905);
      f = this.md5_ii(f, r, i, m, d[n + 5], 21, -57434055);

      m = this.md5_ii(m, f, r, i, d[n + 12], 6, 1700485571);
      i = this.md5_ii(i, m, f, r, d[n + 3], 10, -1894986606);
      r = this.md5_ii(r, i, m, f, d[n + 10], 15, -1051523);
      f = this.md5_ii(f, r, i, m, d[n + 1], 21, -2054922799);

      m = this.md5_ii(m, f, r, i, d[n + 8], 6, 1873313359);
      i = this.md5_ii(i, m, f, r, d[n + 15], 10, -30611744);
      r = this.md5_ii(r, i, m, f, d[n + 6], 15, -1560198380);
      f = this.md5_ii(f, r, i, m, d[n + 13], 21, 1309151649);

      m = this.md5_ii(m, f, r, i, d[n + 4], 6, -145523070);
      i = this.md5_ii(i, m, f, r, d[n + 11], 10, -1120210379);
      r = this.md5_ii(r, i, m, f, d[n + 2], 15, 718787259);
      f = this.md5_ii(f, r, i, m, d[n + 9], 21, -343485551);

      m = this.safe_add(m, h);
      f = this.safe_add(f, t);
      r = this.safe_add(r, g);
      i = this.safe_add(i, e);
    }

    return [m, f, r, i];
  }

  private md5_cmn(
    d: number,
    _: number,
    m: number,
    f: number,
    r: number,
    i: number
  ): number {
    return this.safe_add(
      this.bit_rol(this.safe_add(this.safe_add(_, d), this.safe_add(f, i)), r),
      m
    );
  }

  private md5_ff(
    d: number,
    _: number,
    m: number,
    f: number,
    r: number,
    i: number,
    n: number
  ): number {
    return this.md5_cmn((_ & m) | (~_ & f), d, _, r, i, n);
  }

  private md5_gg(
    d: number,
    _: number,
    m: number,
    f: number,
    r: number,
    i: number,
    n: number
  ): number {
    return this.md5_cmn((_ & f) | (m & ~f), d, _, r, i, n);
  }

  private md5_hh(
    d: number,
    _: number,
    m: number,
    f: number,
    r: number,
    i: number,
    n: number
  ): number {
    return this.md5_cmn(_ ^ m ^ f, d, _, r, i, n);
  }

  private md5_ii(
    d: number,
    _: number,
    m: number,
    f: number,
    r: number,
    i: number,
    n: number
  ): number {
    return this.md5_cmn(m ^ (_ | ~f), d, _, r, i, n);
  }

  private safe_add(d: number, _: number): number {
    const m = (65535 & d) + (65535 & _);
    return (((d >>> 16) + (_ >>> 16) + (m >>> 16)) << 16) | (65535 & m);
  }

  private bit_rol(d: number, _: number): number {
    return (d << _) | (d >>> (32 - _));
  }
}

/**
 * Calculates the MD5 hash of string using the » RSA Data Security, Inc. MD5 Message-Digest Algorithm, and returns that hash.
 * @param input The string.
 * @returns Returns the hash as a 32-character hexadecimal number.
 */
export const md5 = (input: string): string => new MD5Hash(input).hash();

export const randomString = (length: number = 8): string => {
  const chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
  const allChars =
    "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
  const allCharsLength = allChars.length;

  if (length < 1) {
    throw new Error("Length must be at least 1");
  }

  // Create an array to hold the characters
  const result = new Array(length);

  // Generate secure random values
  const randomBytes = new Uint8Array(length);
  crypto.getRandomValues(randomBytes); // Fills the array with random values

  // First character must be from chars (no numbers)
  result[0] = chars[randomBytes[0] % chars.length];

  // Fill the rest of the array with random characters from allChars
  for (let i = 1; i < length; i++) {
    result[i] = allChars[randomBytes[i] % allCharsLength];
  }

  // Join the array into a string and return
  return result.join("");
};
