import { ReactNode } from "react";
import { BootstrapStyles, PrimeStyles } from "./enums";

export interface Labels {
  [key: string]: string;
}

export interface Hints {
  [key: string]: string;
}

export interface Errors {
  [key: string]: string[];
}

export interface Fields {
  [key: string]: ReactNode;
}

export interface modelProps {
  fields: Fields;
  rules: unknown[];
  labels: Labels;
  hints: Hints;
  errors: Errors;
  name: string;
  isNew: boolean;
  extra: Fields;
}

export type TableCellValueType =
  | string
  | number
  | boolean
  | null
  | undefined
  | ReactNode
  | CallableFunction;

export interface CustomColumnFieldProps {
  value: TableCellValueType;
  label?: string;
}

export interface ColumnProps {
  [key: string]: CustomColumnFieldProps;
}

export interface TableComponentProps {
  columns?: ColumnProps;
}

export interface messagesProp {
  type: PrimeStyles | BootstrapStyles;
  header: string | null;
  time: number;
  value: unknown;
  autoClose: boolean;
  closeDelay: number;
  removeAfterAccess: boolean;
}

export interface userIdentityProps {
  id: number;
  username: string;
  email: string | null;
  created_at: number;
  updated_at: number;
  flags: number;
  auth_tf_enabled: number | null;
  auth_tf_key: string | null;
  auth_tf_mobile_phone: string | null;
  auth_tf_type: string | null;
  blocked_at: number | null;
  confirmed_at: number | null;
  dynamics_guid: string | null;
  gdpr_consent: number;
  gdpr_consent_date: string | null;
  gdpr_deleted: number;
  last_login_at: number | null;
  last_login_ip: string | null;
  number: string | null;
  password_changed_at: number;
  registration_ip: string | null;
  unconfirmed_email: string | null;
}

export interface userProfileProps {
  bio: string | null;
  face_url: string | null;
  first_name: string | null;
  gravatar_email: string | null;
  gravatar_id: string | null;
  location: string | null;
  name: string | null;
  phone_number: string | null;
  public_email: string | null;
  surname: string | null;
  timezone: string | null;
  user_id: number;
  website: string | null;
}

export interface userProps {
  identity: userIdentityProps;
  profile: userProfileProps;
  roles: string[]
}
