export interface FontAwesome6Props {
  identifier: FAIdentifier;

  // Family
  duotone?: boolean;
  sharp?: boolean;
  sharpDuotone?: boolean;
  brand?: boolean;

  // Weight
  solid?: boolean;
  regular?: boolean;
  light?: boolean;
  thin?: boolean;

  size?: FontSize;
  flip?: FontFlip;
  rotate?: FontRotate;
  animate?: FAAnimate;
}

type FontSize = "2xs" | "xs" | "sm" | "lg" | "xl" | "2xl" | null;

type FontFlip = "horizontal" | "vertical" | "both" | null;

type FontRotate = 90 | 180 | 270 | null;

export type FAAnimate =
  | "beat"
  | "beat-fade"
  | "bounce"
  | "fade"
  | "flip"
  | "spin"
  | "spin-reverse"
  | "spin-pulse"
  | null;

export type FAIdentifier =
  | "monero"
  | "hooli"
  | "yelp"
  | "cc-visa"
  | "lastfm"
  | "shopware"
  | "creative-commons-nc"
  | "aws"
  | "redhat"
  | "yoast"
  | "cloudflare"
  | "ups"
  | "pixiv"
  | "wpexplorer"
  | "dyalog"
  | "bity"
  | "stackpath"
  | "buysellads"
  | "first-order"
  | "modx"
  | "guilded"
  | "vnv"
  | "square-js"
  | "microsoft"
  | "qq"
  | "orcid"
  | "java"
  | "invision"
  | "creative-commons-pd-alt"
  | "centercode"
  | "glide-g"
  | "drupal"
  | "jxl"
  | "dart-lang"
  | "hire-a-helper"
  | "creative-commons-by"
  | "unity"
  | "whmcs"
  | "rocketchat"
  | "vk"
  | "untappd"
  | "mailchimp"
  | "css3-alt"
  | "square-reddit"
  | "vimeo-v"
  | "contao"
  | "square-font-awesome"
  | "deskpro"
  | "brave"
  | "sistrix"
  | "square-instagram"
  | "battle-net"
  | "the-red-yeti"
  | "square-hacker-news"
  | "edge"
  | "threads"
  | "napster"
  | "square-snapchat"
  | "google-plus-g"
  | "artstation"
  | "markdown"
  | "sourcetree"
  | "google-plus"
  | "diaspora"
  | "foursquare"
  | "stack-overflow"
  | "github-alt"
  | "phoenix-squadron"
  | "pagelines"
  | "algolia"
  | "red-river"
  | "creative-commons-sa"
  | "safari"
  | "google"
  | "square-font-awesome-stroke"
  | "atlassian"
  | "linkedin-in"
  | "digital-ocean"
  | "nimblr"
  | "chromecast"
  | "evernote"
  | "hacker-news"
  | "creative-commons-sampling"
  | "adversal"
  | "creative-commons"
  | "watchman-monitoring"
  | "fonticons"
  | "weixin"
  | "shirtsinbulk"
  | "codepen"
  | "git-alt"
  | "lyft"
  | "rev"
  | "windows"
  | "wizards-of-the-coast"
  | "square-viadeo"
  | "meetup"
  | "centos"
  | "adn"
  | "cloudsmith"
  | "opensuse"
  | "pied-piper-alt"
  | "square-dribbble"
  | "codiepie"
  | "node"
  | "mix"
  | "steam"
  | "cc-apple-pay"
  | "scribd"
  | "debian"
  | "openid"
  | "instalod"
  | "expeditedssl"
  | "sellcast"
  | "square-twitter"
  | "r-project"
  | "delicious"
  | "freebsd"
  | "vuejs"
  | "accusoft"
  | "ioxhost"
  | "fonticons-fi"
  | "app-store"
  | "cc-mastercard"
  | "itunes-note"
  | "golang"
  | "kickstarter"
  | "grav"
  | "weibo"
  | "uncharted"
  | "firstdraft"
  | "square-youtube"
  | "wikipedia-w"
  | "wpressr"
  | "angellist"
  | "galactic-republic"
  | "nfc-directional"
  | "skype"
  | "joget"
  | "fedora"
  | "stripe-s"
  | "meta"
  | "laravel"
  | "hotjar"
  | "bluetooth-b"
  | "square-letterboxd"
  | "sticker-mule"
  | "creative-commons-zero"
  | "hips"
  | "behance"
  | "reddit"
  | "discord"
  | "chrome"
  | "app-store-ios"
  | "cc-discover"
  | "wpbeginner"
  | "confluence"
  | "shoelace"
  | "mdb"
  | "dochub"
  | "accessible-icon"
  | "ebay"
  | "amazon"
  | "unsplash"
  | "yarn"
  | "square-steam"
  | "500px"
  | "square-vimeo"
  | "asymmetrik"
  | "font-awesome"
  | "gratipay"
  | "apple"
  | "hive"
  | "gitkraken"
  | "keybase"
  | "apple-pay"
  | "padlet"
  | "amazon-pay"
  | "square-github"
  | "stumbleupon"
  | "fedex"
  | "phoenix-framework"
  | "shopify"
  | "neos"
  | "square-threads"
  | "hackerrank"
  | "researchgate"
  | "swift"
  | "angular"
  | "speakap"
  | "angrycreative"
  | "y-combinator"
  | "empire"
  | "envira"
  | "google-scholar"
  | "square-gitlab"
  | "studiovinari"
  | "pied-piper"
  | "wordpress"
  | "product-hunt"
  | "firefox"
  | "linode"
  | "goodreads"
  | "square-odnoklassniki"
  | "jsfiddle"
  | "sith"
  | "themeisle"
  | "page4"
  | "hashnode"
  | "react"
  | "cc-paypal"
  | "squarespace"
  | "cc-stripe"
  | "creative-commons-share"
  | "bitcoin"
  | "keycdn"
  | "opera"
  | "itch-io"
  | "umbraco"
  | "galactic-senate"
  | "ubuntu"
  | "draft2digital"
  | "stripe"
  | "houzz"
  | "gg"
  | "dhl"
  | "square-pinterest"
  | "xing"
  | "blackberry"
  | "creative-commons-pd"
  | "playstation"
  | "quinscape"
  | "less"
  | "blogger-b"
  | "opencart"
  | "vine"
  | "signal-messenger"
  | "paypal"
  | "gitlab"
  | "typo3"
  | "reddit-alien"
  | "yahoo"
  | "dailymotion"
  | "affiliatetheme"
  | "pied-piper-pp"
  | "bootstrap"
  | "odnoklassniki"
  | "nfc-symbol"
  | "mintbit"
  | "ethereum"
  | "speaker-deck"
  | "creative-commons-nc-eu"
  | "patreon"
  | "avianex"
  | "ello"
  | "gofore"
  | "bimobject"
  | "brave-reverse"
  | "facebook-f"
  | "square-google-plus"
  | "web-awesome"
  | "mandalorian"
  | "first-order-alt"
  | "osi"
  | "google-wallet"
  | "d-and-d-beyond"
  | "periscope"
  | "fulcrum"
  | "cloudscale"
  | "forumbee"
  | "mizuni"
  | "schlix"
  | "square-xing"
  | "bandcamp"
  | "wpforms"
  | "cloudversify"
  | "usps"
  | "megaport"
  | "magento"
  | "spotify"
  | "optin-monster"
  | "fly"
  | "aviato"
  | "itunes"
  | "cuttlefish"
  | "blogger"
  | "flickr"
  | "viber"
  | "soundcloud"
  | "digg"
  | "tencent-weibo"
  | "letterboxd"
  | "symfony"
  | "maxcdn"
  | "etsy"
  | "facebook-messenger"
  | "audible"
  | "think-peaks"
  | "bilibili"
  | "erlang"
  | "x-twitter"
  | "cotton-bureau"
  | "dashcube"
  | "42-group"
  | "stack-exchange"
  | "elementor"
  | "square-pied-piper"
  | "creative-commons-nd"
  | "palfed"
  | "superpowers"
  | "resolving"
  | "xbox"
  | "square-web-awesome-stroke"
  | "searchengin"
  | "tiktok"
  | "square-facebook"
  | "renren"
  | "linux"
  | "glide"
  | "linkedin"
  | "hubspot"
  | "deploydog"
  | "twitch"
  | "flutter"
  | "ravelry"
  | "mixer"
  | "square-lastfm"
  | "vimeo"
  | "mendeley"
  | "uniregistry"
  | "figma"
  | "creative-commons-remix"
  | "cc-amazon-pay"
  | "dropbox"
  | "instagram"
  | "cmplid"
  | "upwork"
  | "facebook"
  | "gripfire"
  | "jedi-order"
  | "uikit"
  | "fort-awesome-alt"
  | "phabricator"
  | "ussunnah"
  | "earlybirds"
  | "trade-federation"
  | "autoprefixer"
  | "whatsapp"
  | "square-upwork"
  | "slideshare"
  | "google-play"
  | "viadeo"
  | "line"
  | "google-drive"
  | "servicestack"
  | "simplybuilt"
  | "bitbucket"
  | "imdb"
  | "deezer"
  | "raspberry-pi"
  | "jira"
  | "docker"
  | "screenpal"
  | "bluetooth"
  | "gitter"
  | "d-and-d"
  | "microblog"
  | "cc-diners-club"
  | "gg-circle"
  | "pied-piper-hat"
  | "kickstarter-k"
  | "yandex"
  | "readme"
  | "html5"
  | "sellsy"
  | "square-web-awesome"
  | "sass"
  | "wirsindhandwerk"
  | "buromobelexperte"
  | "salesforce"
  | "octopus-deploy"
  | "medapps"
  | "ns8"
  | "pinterest-p"
  | "apper"
  | "fort-awesome"
  | "waze"
  | "bluesky"
  | "cc-jcb"
  | "snapchat"
  | "fantasy-flight-games"
  | "rust"
  | "wix"
  | "square-behance"
  | "supple"
  | "webflow"
  | "rebel"
  | "css3"
  | "staylinked"
  | "kaggle"
  | "space-awesome"
  | "deviantart"
  | "cpanel"
  | "goodreads-g"
  | "square-git"
  | "square-tumblr"
  | "trello"
  | "creative-commons-nc-jp"
  | "get-pocket"
  | "perbyte"
  | "grunt"
  | "weebly"
  | "connectdevelop"
  | "leanpub"
  | "black-tie"
  | "themeco"
  | "python"
  | "android"
  | "bots"
  | "free-code-camp"
  | "hornbill"
  | "js"
  | "ideal"
  | "git"
  | "dev"
  | "sketch"
  | "yandex-international"
  | "cc-amex"
  | "uber"
  | "github"
  | "php"
  | "alipay"
  | "youtube"
  | "skyatlas"
  | "firefox-browser"
  | "replyd"
  | "suse"
  | "jenkins"
  | "twitter"
  | "rockrms"
  | "pinterest"
  | "buffer"
  | "npm"
  | "yammer"
  | "btc"
  | "dribbble"
  | "stumbleupon-circle"
  | "internet-explorer"
  | "stubber"
  | "telegram"
  | "old-republic"
  | "odysee"
  | "square-whatsapp"
  | "node-js"
  | "edge-legacy"
  | "slack"
  | "medrt"
  | "usb"
  | "tumblr"
  | "vaadin"
  | "quora"
  | "square-x-twitter"
  | "reacteurope"
  | "medium"
  | "amilia"
  | "mixcloud"
  | "flipboard"
  | "viacoin"
  | "critical-role"
  | "sitrox"
  | "discourse"
  | "joomla"
  | "mastodon"
  | "airbnb"
  | "wolf-pack-battalion"
  | "buy-n-large"
  | "gulp"
  | "creative-commons-sampling-plus"
  | "strava"
  | "ember"
  | "canadian-maple-leaf"
  | "teamspeak"
  | "pushed"
  | "wordpress-simple"
  | "nutritionix"
  | "wodu"
  | "google-pay"
  | "intercom"
  | "zhihu"
  | "korvue"
  | "pix"
  | "steam-symbol"
  | "0"
  | "1"
  | "2"
  | "3"
  | "4"
  | "5"
  | "6"
  | "7"
  | "8"
  | "9"
  | "fill-drip"
  | "arrows-to-circle"
  | "circle-chevron-right"
  | "wagon-covered"
  | "line-height"
  | "bagel"
  | "transporter-7"
  | "at"
  | "rectangles-mixed"
  | "phone-arrow-up-right"
  | "trash-can"
  | "circle-l"
  | "head-side-goggles"
  | "text-height"
  | "user-xmark"
  | "face-hand-yawn"
  | "gauge-simple-min"
  | "stethoscope"
  | "coffin"
  | "message"
  | "salad"
  | "info"
  | "robot-astromech"
  | "ring-diamond"
  | "fondue-pot"
  | "theta"
  | "face-hand-peeking"
  | "square-user"
  | "down-left-and-up-right-to-center"
  | "explosion"
  | "file-lines"
  | "wave-square"
  | "ring"
  | "building-un"
  | "dice-three"
  | "tire-pressure-warning"
  | "wifi-fair"
  | "calendar-days"
  | "mp3-player"
  | "anchor-circle-check"
  | "tally-4"
  | "rectangle-history"
  | "building-circle-arrow-right"
  | "volleyball"
  | "sun-haze"
  | "text-size"
  | "ufo"
  | "fork"
  | "arrows-up-to-line"
  | "mobile-signal"
  | "barcode-scan"
  | "sort-down"
  | "folder-arrow-down"
  | "circle-minus"
  | "face-icicles"
  | "shovel"
  | "door-open"
  | "films"
  | "right-from-bracket"
  | "face-glasses"
  | "nfc"
  | "atom"
  | "soap"
  | "icons"
  | "microphone-lines-slash"
  | "closed-captioning-slash"
  | "calculator-simple"
  | "bridge-circle-check"
  | "sliders-up"
  | "location-minus"
  | "pump-medical"
  | "fingerprint"
  | "ski-boot"
  | "standard-definition"
  | "h1"
  | "hand-point-right"
  | "magnifying-glass-location"
  | "message-bot"
  | "forward-step"
  | "face-smile-beam"
  | "light-ceiling"
  | "message-exclamation"
  | "bowl-scoop"
  | "square-x"
  | "building-memo"
  | "utility-pole-double"
  | "flag-checkered"
  | "chevrons-up"
  | "football"
  | "user-vneck"
  | "school-circle-exclamation"
  | "crop"
  | "angles-down"
  | "users-rectangle"
  | "people-roof"
  | "square-arrow-right"
  | "location-plus"
  | "lightbulb-exclamation-on"
  | "people-line"
  | "beer-mug-empty"
  | "crate-empty"
  | "diagram-predecessor"
  | "transporter"
  | "calendar-circle-user"
  | "arrow-up-long"
  | "person-carry-box"
  | "fire-flame-simple"
  | "person"
  | "laptop"
  | "file-csv"
  | "menorah"
  | "union"
  | "chevrons-left"
  | "circle-heart"
  | "truck-plane"
  | "record-vinyl"
  | "bring-forward"
  | "square-p"
  | "face-grin-stars"
  | "sigma"
  | "camera-movie"
  | "bong"
  | "clarinet"
  | "truck-flatbed"
  | "spaghetti-monster-flying"
  | "arrow-down-up-across-line"
  | "arrows-rotate-reverse"
  | "leaf-heart"
  | "house-building"
  | "cheese-swiss"
  | "spoon"
  | "jar-wheat"
  | "envelopes-bulk"
  | "file-circle-exclamation"
  | "bow-arrow"
  | "cart-xmark"
  | "hexagon-xmark"
  | "circle-h"
  | "merge"
  | "pager"
  | "cart-minus"
  | "address-book"
  | "pan-frying"
  | "grid"
  | "football-helmet"
  | "hand-love"
  | "trees"
  | "strikethrough"
  | "page"
  | "k"
  | "diagram-previous"
  | "gauge-min"
  | "folder-grid"
  | "eggplant"
  | "excavator"
  | "ram"
  | "landmark-flag"
  | "lips"
  | "pencil"
  | "backward"
  | "caret-right"
  | "comments"
  | "paste"
  | "desktop-arrow-down"
  | "code-pull-request"
  | "pumpkin"
  | "clipboard-list"
  | "pen-field"
  | "blueberries"
  | "truck-ramp-box"
  | "note"
  | "arrow-down-to-square"
  | "user-check"
  | "cloud-xmark"
  | "vial-virus"
  | "book-blank"
  | "golf-flag-hole"
  | "message-arrow-down"
  | "face-unamused"
  | "sheet-plastic"
  | "circle-9"
  | "blog"
  | "user-ninja"
  | "pencil-slash"
  | "bowling-pins"
  | "person-arrow-up-from-line"
  | "down-right"
  | "scroll-torah"
  | "webhook"
  | "blinds-open"
  | "fence"
  | "up"
  | "broom-ball"
  | "drumstick"
  | "square-v"
  | "face-awesome"
  | "dial-off"
  | "toggle-off"
  | "face-smile-horns"
  | "box-archive"
  | "grapes"
  | "person-drowning"
  | "dial-max"
  | "circle-m"
  | "calendar-image"
  | "circle-caret-down"
  | "arrow-down-9-1"
  | "face-grin-tongue-squint"
  | "shish-kebab"
  | "spray-can"
  | "alarm-snooze"
  | "scarecrow"
  | "truck-monster"
  | "gift-card"
  | "w"
  | "code-pull-request-draft"
  | "square-b"
  | "elephant"
  | "earth-africa"
  | "rainbow"
  | "circle-notch"
  | "tablet-screen-button"
  | "paw"
  | "message-question"
  | "cloud"
  | "trowel-bricks"
  | "square-3"
  | "face-flushed"
  | "hospital-user"
  | "microwave"
  | "chf-sign"
  | "tent-arrow-left-right"
  | "cart-circle-arrow-up"
  | "trash-clock"
  | "reflect-both"
  | "gavel"
  | "sprinkler-ceiling"
  | "browsers"
  | "trillium"
  | "table-cells-unlock"
  | "music-slash"
  | "truck-ramp"
  | "binoculars"
  | "microphone-slash"
  | "box-tissue"
  | "circle-c"
  | "star-christmas"
  | "chart-bullet"
  | "motorcycle"
  | "tree-christmas"
  | "tire-flat"
  | "sunglasses"
  | "badge"
  | "message-pen"
  | "bell-concierge"
  | "pen-ruler"
  | "file-mp3"
  | "arrow-progress"
  | "chess-rook-piece"
  | "square-root"
  | "album-collection-circle-plus"
  | "people-arrows"
  | "sign-post"
  | "face-angry-horns"
  | "mars-and-venus-burst"
  | "tombstone"
  | "square-caret-right"
  | "scissors"
  | "list-music"
  | "sun-plant-wilt"
  | "toilets-portable"
  | "hockey-puck"
  | "mustache"
  | "hyphen"
  | "table"
  | "user-chef"
  | "message-image"
  | "users-medical"
  | "sensor-triangle-exclamation"
  | "magnifying-glass-arrow-right"
  | "tachograph-digital"
  | "face-mask"
  | "pickleball"
  | "star-sharp-half"
  | "users-slash"
  | "clover"
  | "meat"
  | "reply"
  | "star-and-crescent"
  | "empty-set"
  | "house-fire"
  | "square-minus"
  | "helicopter"
  | "bird"
  | "compass"
  | "square-caret-down"
  | "heart-half-stroke"
  | "file-circle-question"
  | "truck-utensils"
  | "laptop-code"
  | "joystick"
  | "grill-fire"
  | "rectangle-vertical-history"
  | "swatchbook"
  | "prescription-bottle"
  | "bars"
  | "keyboard-left"
  | "people-group"
  | "hourglass-end"
  | "heart-crack"
  | "face-beam-hand-over-mouth"
  | "droplet-percent"
  | "square-up-right"
  | "face-kiss-beam"
  | "corn"
  | "roller-coaster"
  | "photo-film-music"
  | "radar"
  | "sickle"
  | "film"
  | "coconut"
  | "ruler-horizontal"
  | "shield-cross"
  | "cassette-tape"
  | "square-terminal"
  | "people-robbery"
  | "lightbulb"
  | "caret-left"
  | "comment-middle"
  | "trash-can-list"
  | "block"
  | "circle-exclamation"
  | "school-circle-xmark"
  | "arrow-right-from-bracket"
  | "face-frown-slight"
  | "circle-chevron-down"
  | "sidebar-flip"
  | "unlock-keyhole"
  | "temperature-list"
  | "cloud-showers-heavy"
  | "headphones-simple"
  | "sitemap"
  | "pipe-section"
  | "space-station-moon-construction"
  | "circle-dollar-to-slot"
  | "memory"
  | "face-sleeping"
  | "road-spikes"
  | "fire-burner"
  | "squirrel"
  | "arrow-up-to-line"
  | "flag"
  | "face-cowboy-hat"
  | "hanukiah"
  | "chart-scatter-3d"
  | "display-chart-up"
  | "square-code"
  | "feather"
  | "volume-low"
  | "xmark-to-slot"
  | "box-taped"
  | "comment-slash"
  | "swords"
  | "cloud-sun-rain"
  | "album"
  | "circle-n"
  | "compress"
  | "wheat-awn"
  | "ankh"
  | "hands-holding-child"
  | "asterisk"
  | "key-skeleton-left-right"
  | "comment-lines"
  | "luchador-mask"
  | "square-check"
  | "shredder"
  | "book-open-cover"
  | "sandwich"
  | "peseta-sign"
  | "square-parking-slash"
  | "train-tunnel"
  | "heading"
  | "ghost"
  | "face-anguished"
  | "hockey-sticks"
  | "abacus"
  | "film-simple"
  | "list"
  | "tree-palm"
  | "square-phone-flip"
  | "user-beard-bolt"
  | "cart-plus"
  | "gamepad"
  | "border-center-v"
  | "circle-dot"
  | "clipboard-medical"
  | "face-dizzy"
  | "egg"
  | "up-to-line"
  | "house-medical-circle-xmark"
  | "watch-fitness"
  | "clock-nine-thirty"
  | "campground"
  | "folder-plus"
  | "jug"
  | "futbol"
  | "snow-blowing"
  | "paintbrush"
  | "lock"
  | "arrow-down-from-line"
  | "gas-pump"
  | "signal-bars-slash"
  | "monkey"
  | "rectangle-pro"
  | "house-night"
  | "hot-tub-person"
  | "globe-pointer"
  | "blanket"
  | "map-location"
  | "house-flood-water"
  | "comments-question-check"
  | "tree"
  | "arrows-cross"
  | "backpack"
  | "square-small"
  | "folder-arrow-up"
  | "bridge-lock"
  | "crosshairs-simple"
  | "sack-dollar"
  | "pen-to-square"
  | "square-sliders"
  | "car-side"
  | "message-middle-top"
  | "lightbulb-on"
  | "knife"
  | "share-nodes"
  | "display-chart-up-circle-dollar"
  | "wave-sine"
  | "heart-circle-minus"
  | "circle-w"
  | "circle-calendar"
  | "hourglass-half"
  | "microscope"
  | "sunset"
  | "sink"
  | "calendar-exclamation"
  | "truck-container-empty"
  | "hand-heart"
  | "bag-shopping"
  | "arrow-down-z-a"
  | "mitten"
  | "reply-clock"
  | "person-rays"
  | "right"
  | "circle-f"
  | "users"
  | "face-pleading"
  | "eye-slash"
  | "flask-vial"
  | "police-box"
  | "cucumber"
  | "head-side-brain"
  | "hand"
  | "person-biking-mountain"
  | "utensils-slash"
  | "print-magnifying-glass"
  | "turn-right"
  | "folder-bookmark"
  | "arrow-turn-left-down"
  | "om"
  | "pi"
  | "flask-round-potion"
  | "face-shush"
  | "worm"
  | "house-circle-xmark"
  | "plug"
  | "calendar-circle-exclamation"
  | "square-i"
  | "chevron-up"
  | "face-saluting"
  | "gauge-simple-low"
  | "face-persevering"
  | "circle-camera"
  | "hand-spock"
  | "spider-web"
  | "circle-microphone"
  | "book-arrow-up"
  | "popsicle"
  | "command"
  | "blinds"
  | "stopwatch"
  | "saxophone"
  | "square-2"
  | "field-hockey-stick-ball"
  | "arrow-up-square-triangle"
  | "face-scream"
  | "square-m"
  | "camera-web"
  | "comment-arrow-down"
  | "lightbulb-cfl"
  | "window-frame-open"
  | "face-kiss"
  | "bridge-circle-xmark"
  | "period"
  | "face-grin-tongue"
  | "up-to-dotted-line"
  | "thought-bubble"
  | "skeleton-ribs"
  | "raygun"
  | "flute"
  | "acorn"
  | "video-arrow-up-right"
  | "grate-droplet"
  | "seal-exclamation"
  | "chess-bishop"
  | "message-sms"
  | "coffee-beans"
  | "hat-witch"
  | "face-grin-wink"
  | "clock-three-thirty"
  | "ear-deaf"
  | "alarm-clock"
  | "eclipse"
  | "face-relieved"
  | "road-circle-check"
  | "dice-five"
  | "octagon-minus"
  | "square-rss"
  | "face-zany"
  | "tricycle"
  | "land-mine-on"
  | "square-arrow-up-left"
  | "i-cursor"
  | "chart-mixed-up-circle-dollar"
  | "salt-shaker"
  | "stamp"
  | "file-plus"
  | "draw-square"
  | "toilet-paper-under-slash"
  | "stairs"
  | "drone-front"
  | "glass-empty"
  | "dial-high"
  | "user-helmet-safety"
  | "i"
  | "hryvnia-sign"
  | "arrow-down-left-and-arrow-up-right-to-center"
  | "pills"
  | "face-grin-wide"
  | "tooth"
  | "basketball-hoop"
  | "objects-align-bottom"
  | "v"
  | "sparkles"
  | "squid"
  | "leafy-green"
  | "circle-arrow-up-right"
  | "calendars"
  | "bangladeshi-taka-sign"
  | "bicycle"
  | "hammer-war"
  | "circle-d"
  | "spider-black-widow"
  | "staff-snake"
  | "pear"
  | "head-side-cough-slash"
  | "file-mov"
  | "triangle"
  | "apartment"
  | "truck-medical"
  | "pepper"
  | "piano"
  | "gun-squirt"
  | "wheat-awn-circle-exclamation"
  | "snowman"
  | "user-alien"
  | "shield-check"
  | "mortar-pestle"
  | "road-barrier"
  | "chart-candlestick"
  | "briefcase-blank"
  | "school"
  | "igloo"
  | "bracket-round"
  | "joint"
  | "horse-saddle"
  | "mug-marshmallows"
  | "filters"
  | "bell-on"
  | "angle-right"
  | "dial-med"
  | "horse"
  | "q"
  | "monitor-waveform"
  | "link-simple"
  | "whistle"
  | "g"
  | "wine-glass-crack"
  | "slot-machine"
  | "notes-medical"
  | "car-wash"
  | "escalator"
  | "comment-image"
  | "temperature-half"
  | "dong-sign"
  | "donut"
  | "capsules"
  | "poo-storm"
  | "tally-1"
  | "file-vector"
  | "face-frown-open"
  | "square-dashed"
  | "bag-shopping-plus"
  | "square-j"
  | "hand-point-up"
  | "money-bill"
  | "arrow-up-big-small"
  | "barcode-read"
  | "baguette"
  | "bowl-soft-serve"
  | "face-holding-back-tears"
  | "square-up"
  | "train-subway-tunnel"
  | "square-exclamation"
  | "semicolon"
  | "bookmark"
  | "fan-table"
  | "align-justify"
  | "battery-low"
  | "credit-card-front"
  | "brain-arrow-curved-right"
  | "umbrella-beach"
  | "helmet-un"
  | "location-smile"
  | "arrow-left-to-line"
  | "bullseye"
  | "sushi"
  | "message-captions"
  | "trash-list"
  | "bacon"
  | "option"
  | "raccoon"
  | "hand-point-down"
  | "arrow-up-from-bracket"
  | "head-side-gear"
  | "trash-plus"
  | "file-cad"
  | "objects-align-top"
  | "folder"
  | "face-anxious-sweat"
  | "credit-card-blank"
  | "file-waveform"
  | "microchip-ai"
  | "mug"
  | "plane-up-slash"
  | "radiation"
  | "pen-circle"
  | "bag-seedling"
  | "chart-simple"
  | "crutches"
  | "circle-parking"
  | "mars-stroke"
  | "leaf-oak"
  | "square-bolt"
  | "vial"
  | "gauge"
  | "wand-magic-sparkles"
  | "lambda"
  | "e"
  | "pizza"
  | "bowl-chopsticks-noodles"
  | "h3"
  | "pen-clip"
  | "bridge-circle-exclamation"
  | "badge-percent"
  | "rotate-reverse"
  | "user"
  | "sensor"
  | "comma"
  | "school-circle-check"
  | "toilet-paper-under"
  | "light-emergency"
  | "arrow-down-to-arc"
  | "dumpster"
  | "van-shuttle"
  | "building-user"
  | "light-switch"
  | "square-caret-left"
  | "highlighter"
  | "wave-pulse"
  | "key"
  | "arrow-left-to-bracket"
  | "hat-santa"
  | "tamale"
  | "box-check"
  | "bullhorn"
  | "steak"
  | "location-crosshairs-slash"
  | "person-dolly"
  | "globe"
  | "synagogue"
  | "file-chart-column"
  | "person-half-dress"
  | "folder-image"
  | "calendar-pen"
  | "road-bridge"
  | "face-smile-tear"
  | "message-plus"
  | "location-arrow"
  | "c"
  | "tablet-button"
  | "person-dress-fairy"
  | "rectangle-history-circle-user"
  | "building-lock"
  | "chart-line-up"
  | "mailbox"
  | "sign-posts"
  | "truck-bolt"
  | "pizza-slice"
  | "money-bill-wave"
  | "chart-area"
  | "house-flag"
  | "circle-three-quarters-stroke"
  | "person-circle-minus"
  | "scalpel"
  | "ban"
  | "bell-exclamation"
  | "circle-bookmark"
  | "egg-fried"
  | "face-weary"
  | "uniform-martial-arts"
  | "camera-rotate"
  | "sun-dust"
  | "comment-text"
  | "spray-can-sparkles"
  | "signal-bars"
  | "diamond-exclamation"
  | "star"
  | "dial-min"
  | "repeat"
  | "cross"
  | "page-caret-down"
  | "box"
  | "venus-mars"
  | "clock-seven-thirty"
  | "arrow-pointer"
  | "clock-four-thirty"
  | "signal-bars-good"
  | "cactus"
  | "lightbulb-gear"
  | "maximize"
  | "charging-station"
  | "shapes"
  | "plane-tail"
  | "gauge-simple-max"
  | "circle-u"
  | "shield-slash"
  | "square-phone-hangup"
  | "arrow-up-left"
  | "transporter-1"
  | "peanuts"
  | "shuffle"
  | "person-running"
  | "mobile-retro"
  | "grip-lines-vertical"
  | "bin-bottles-recycle"
  | "arrow-up-from-square"
  | "file-dashed-line"
  | "bracket-curly-right"
  | "spider"
  | "clock-three"
  | "hands-bound"
  | "scalpel-line-dashed"
  | "file-invoice-dollar"
  | "pipe-smoking"
  | "face-astonished"
  | "window"
  | "plane-circle-exclamation"
  | "ear"
  | "file-lock"
  | "diagram-venn"
  | "arrow-down-from-bracket"
  | "x-ray"
  | "goal-net"
  | "coffin-cross"
  | "octopus"
  | "spell-check"
  | "location-xmark"
  | "circle-quarter-stroke"
  | "lasso"
  | "slash"
  | "person-to-portal"
  | "calendar-star"
  | "computer-mouse"
  | "arrow-right-to-bracket"
  | "pegasus"
  | "files-medical"
  | "cannon"
  | "nfc-lock"
  | "person-ski-lift"
  | "square-6"
  | "shop-slash"
  | "wind-turbine"
  | "sliders-simple"
  | "grid-round"
  | "badge-sheriff"
  | "server"
  | "virus-covid-slash"
  | "intersection"
  | "shop-lock"
  | "family"
  | "hourglass-start"
  | "user-hair-buns"
  | "blender-phone"
  | "hourglass-clock"
  | "person-seat-reclined"
  | "paper-plane-top"
  | "message-arrow-up"
  | "lightbulb-exclamation"
  | "layer-minus"
  | "chart-pie-simple-circle-currency"
  | "circle-e"
  | "building-wheat"
  | "gauge-max"
  | "person-breastfeeding"
  | "apostrophe"
  | "file-png"
  | "fire-hydrant"
  | "right-to-bracket"
  | "video-plus"
  | "square-right"
  | "comment-smile"
  | "venus"
  | "passport"
  | "thumbtack-slash"
  | "inbox-in"
  | "heart-pulse"
  | "circle-8"
  | "clouds-moon"
  | "clock-ten-thirty"
  | "people-carry-box"
  | "folder-user"
  | "trash-can-xmark"
  | "temperature-high"
  | "microchip"
  | "left-long-to-line"
  | "crown"
  | "weight-hanging"
  | "xmarks-lines"
  | "file-prescription"
  | "table-cells-lock"
  | "calendar-range"
  | "flower-daffodil"
  | "hand-back-point-up"
  | "weight-scale"
  | "arrow-up-to-arc"
  | "star-exclamation"
  | "books"
  | "user-group"
  | "arrow-up-a-z"
  | "layer-plus"
  | "play-pause"
  | "block-question"
  | "snooze"
  | "scanner-image"
  | "tv-retro"
  | "square-t"
  | "farm"
  | "chess-knight"
  | "bars-sort"
  | "pallet-boxes"
  | "face-laugh-squint"
  | "code-simple"
  | "bolt-slash"
  | "panel-fire"
  | "binary-circle-check"
  | "comment-minus"
  | "burrito"
  | "violin"
  | "objects-column"
  | "square-chevron-down"
  | "comment-plus"
  | "triangle-instrument"
  | "wheelchair"
  | "user-pilot-tie"
  | "piano-keyboard"
  | "bed-empty"
  | "circle-arrow-up"
  | "toggle-on"
  | "rectangle-vertical"
  | "person-walking"
  | "l"
  | "signal-stream"
  | "down-to-bracket"
  | "circle-z"
  | "stars"
  | "fire"
  | "bed-pulse"
  | "house-day"
  | "shuttle-space"
  | "shirt-long-sleeve"
  | "chart-pie-simple"
  | "face-laugh"
  | "folder-open"
  | "album-collection-circle-user"
  | "candy"
  | "bowl-hot"
  | "flatbread"
  | "heart-circle-plus"
  | "code-fork"
  | "city"
  | "signal-bars-weak"
  | "microphone-lines"
  | "clock-twelve"
  | "pepper-hot"
  | "citrus-slice"
  | "sheep"
  | "unlock"
  | "colon-sign"
  | "headset"
  | "badger-honey"
  | "h4"
  | "store-slash"
  | "road-circle-xmark"
  | "signal-slash"
  | "user-minus"
  | "mars-stroke-up"
  | "champagne-glasses"
  | "taco"
  | "hexagon-plus"
  | "clipboard"
  | "house-circle-exclamation"
  | "file-arrow-up"
  | "wifi"
  | "messages"
  | "bath"
  | "umbrella-simple"
  | "rectangle-history-circle-plus"
  | "underline"
  | "prescription-bottle-pill"
  | "user-pen"
  | "binary-slash"
  | "square-o"
  | "caduceus"
  | "signature"
  | "stroopwafel"
  | "bold"
  | "anchor-lock"
  | "building-ngo"
  | "transporter-3"
  | "engine-warning"
  | "circle-down-right"
  | "square-k"
  | "manat-sign"
  | "money-check-pen"
  | "not-equal"
  | "border-top-left"
  | "map-location-dot"
  | "tilde"
  | "jedi"
  | "square-poll-vertical"
  | "arrow-down-square-triangle"
  | "mug-hot"
  | "dog-leashed"
  | "car-battery"
  | "face-downcast-sweat"
  | "mailbox-flag-up"
  | "memo-circle-info"
  | "gift"
  | "dice-two"
  | "volume"
  | "transporter-5"
  | "gauge-circle-bolt"
  | "coin-front"
  | "file-slash"
  | "message-arrow-up-right"
  | "treasure-chest"
  | "chess-queen"
  | "paintbrush-fine"
  | "glasses"
  | "hood-cloak"
  | "square-quote"
  | "up-left"
  | "bring-front"
  | "chess-board"
  | "burger-cheese"
  | "building-circle-check"
  | "repeat-1"
  | "arrow-down-to-line"
  | "grid-5"
  | "swap-arrows"
  | "right-long-to-line"
  | "person-chalkboard"
  | "mars-stroke-right"
  | "hand-back-fist"
  | "grid-round-5"
  | "tally"
  | "square-caret-up"
  | "cloud-showers-water"
  | "chart-bar"
  | "hands-bubbles"
  | "less-than-equal"
  | "train"
  | "up-from-dotted-line"
  | "eye-low-vision"
  | "traffic-light-go"
  | "face-exhaling"
  | "sensor-fire"
  | "user-unlock"
  | "hexagon-divide"
  | "crow"
  | "cassette-betamax"
  | "sailboat"
  | "window-restore"
  | "nfc-magnifying-glass"
  | "file-binary"
  | "circle-v"
  | "square-plus"
  | "bowl-scoops"
  | "mistletoe"
  | "custard"
  | "lacrosse-stick"
  | "hockey-mask"
  | "sunrise"
  | "subtitles"
  | "panel-ews"
  | "torii-gate"
  | "cloud-exclamation"
  | "message-lines"
  | "frog"
  | "bucket"
  | "floppy-disk-pen"
  | "image"
  | "window-frame"
  | "microphone"
  | "cow"
  | "file-zip"
  | "square-ring"
  | "down-from-line"
  | "caret-up"
  | "shield-xmark"
  | "screwdriver"
  | "circle-sort-down"
  | "folder-closed"
  | "house-tsunami"
  | "square-nfi"
  | "forklift"
  | "arrow-up-from-ground-water"
  | "bracket-square-right"
  | "martini-glass"
  | "rotate-left"
  | "table-columns"
  | "square-a"
  | "tick"
  | "lemon"
  | "head-side-mask"
  | "handshake"
  | "gem"
  | "dolly"
  | "smoking"
  | "minimize"
  | "refrigerator"
  | "monument"
  | "octagon-xmark"
  | "align-slash"
  | "snowplow"
  | "angles-right"
  | "truck-ramp-couch"
  | "cannabis"
  | "circle-play"
  | "arrow-up-right-and-arrow-down-left-from-center"
  | "location-arrow-up"
  | "tablets"
  | "360-degrees"
  | "ethernet"
  | "euro-sign"
  | "chair"
  | "circle-check"
  | "square-dashed-circle-plus"
  | "hand-holding-circle-dollar"
  | "money-simple-from-bracket"
  | "bat"
  | "circle-stop"
  | "head-side-headphones"
  | "phone-rotary"
  | "arrow-up-to-bracket"
  | "compass-drafting"
  | "plate-wheat"
  | "calendar-circle-minus"
  | "chopsticks"
  | "car-wrench"
  | "icicles"
  | "person-shelter"
  | "neuter"
  | "id-badge"
  | "kazoo"
  | "marker"
  | "bin-bottles"
  | "face-laugh-beam"
  | "square-arrow-down-left"
  | "battery-bolt"
  | "tree-large"
  | "helicopter-symbol"
  | "aperture"
  | "universal-access"
  | "gear-complex"
  | "file-magnifying-glass"
  | "up-right"
  | "circle-chevron-up"
  | "user-police"
  | "lari-sign"
  | "volcano"
  | "teddy-bear"
  | "stocking"
  | "person-walking-dashed-line-arrow-right"
  | "image-slash"
  | "mask-snorkel"
  | "smoke"
  | "sterling-sign"
  | "battery-exclamation"
  | "viruses"
  | "square-person-confined"
  | "user-tie"
  | "up-to-bracket"
  | "arrow-down-long"
  | "tent-arrow-down-to-line"
  | "certificate"
  | "crystal-ball"
  | "reply-all"
  | "suitcase"
  | "person-skating"
  | "star-shooting"
  | "binary-lock"
  | "filter-circle-dollar"
  | "camera-retro"
  | "circle-arrow-down"
  | "comment-pen"
  | "file-import"
  | "banjo"
  | "square-arrow-up-right"
  | "light-emergency-on"
  | "kerning"
  | "box-open"
  | "square-f"
  | "scroll"
  | "spa"
  | "arrow-left-from-line"
  | "strawberry"
  | "location-pin-lock"
  | "pause"
  | "clock-eight-thirty"
  | "plane-engines"
  | "hill-avalanche"
  | "temperature-empty"
  | "bomb"
  | "gauge-low"
  | "registered"
  | "trash-can-plus"
  | "address-card"
  | "scale-unbalanced-flip"
  | "globe-snow"
  | "subscript"
  | "diamond-turn-right"
  | "integral"
  | "burst"
  | "house-laptop"
  | "face-tired"
  | "money-bills"
  | "blinds-raised"
  | "smog"
  | "ufo-beam"
  | "hydra"
  | "circle-caret-up"
  | "user-vneck-hair-long"
  | "square-a-lock"
  | "crutch"
  | "gas-pump-slash"
  | "cloud-arrow-up"
  | "palette"
  | "transporter-4"
  | "chart-mixed-up-circle-currency"
  | "objects-align-right"
  | "arrows-turn-right"
  | "vest"
  | "pig"
  | "inbox-full"
  | "circle-envelope"
  | "triangle-person-digging"
  | "ferry"
  | "bullseye-arrow"
  | "arrows-down-to-people"
  | "seedling"
  | "clock-seven"
  | "left-right"
  | "boxes-packing"
  | "circle-arrow-left"
  | "flashlight"
  | "file-jpg"
  | "group-arrows-rotate"
  | "bowl-food"
  | "square-9"
  | "candy-cane"
  | "arrow-down-wide-short"
  | "square-dollar"
  | "phone-arrow-right"
  | "hand-holding-seedling"
  | "message-check"
  | "cloud-bolt"
  | "chart-line-up-down"
  | "text-slash"
  | "watch"
  | "circle-down-left"
  | "text"
  | "projector"
  | "face-smile-wink"
  | "tombstone-blank"
  | "chess-king-piece"
  | "circle-6"
  | "waves-sine"
  | "left"
  | "file-word"
  | "file-powerpoint"
  | "square-down"
  | "objects-align-center-vertical"
  | "arrows-left-right"
  | "house-lock"
  | "cloud-arrow-down"
  | "wreath"
  | "children"
  | "meter-droplet"
  | "chalkboard"
  | "user-large-slash"
  | "signal-strong"
  | "lollipop"
  | "list-tree"
  | "envelope-open"
  | "draw-circle"
  | "cat-space"
  | "handshake-simple-slash"
  | "rabbit-running"
  | "memo-pad"
  | "mattress-pillow"
  | "alarm-plus"
  | "alicorn"
  | "comment-question"
  | "gingerbread-man"
  | "guarani-sign"
  | "burger-fries"
  | "mug-tea"
  | "border-top"
  | "arrows-rotate"
  | "circle-book-open"
  | "arrows-to-dotted-line"
  | "fire-extinguisher"
  | "magnifying-glass-arrows-rotate"
  | "garage-open"
  | "shelves-empty"
  | "cruzeiro-sign"
  | "watch-apple"
  | "watch-calculator"
  | "list-dropdown"
  | "cabinet-filing"
  | "burger-soda"
  | "square-arrow-up"
  | "greater-than-equal"
  | "pallet-box"
  | "face-confounded"
  | "shield-halved"
  | "truck-plow"
  | "book-atlas"
  | "virus"
  | "grid-round-2"
  | "comment-middle-top"
  | "wave"
  | "envelope-circle-check"
  | "layer-group"
  | "restroom-simple"
  | "arrows-to-dot"
  | "border-outer"
  | "hashtag-lock"
  | "clock-two-thirty"
  | "archway"
  | "heart-circle-check"
  | "house-chimney-crack"
  | "file-zipper"
  | "ticket-perforated"
  | "heart-half"
  | "comment-check"
  | "square"
  | "memo"
  | "martini-glass-empty"
  | "couch"
  | "cedi-sign"
  | "italic"
  | "glass-citrus"
  | "calendar-lines-pen"
  | "table-cells-column-lock"
  | "church"
  | "person-snowmobiling"
  | "face-hushed"
  | "comments-dollar"
  | "tickets-simple"
  | "pickaxe"
  | "link-simple-slash"
  | "democrat"
  | "face-confused"
  | "pinball"
  | "z"
  | "person-skiing"
  | "deer"
  | "input-pipe"
  | "road-lock"
  | "a"
  | "bookmark-slash"
  | "temperature-arrow-down"
  | "mace"
  | "feather-pointed"
  | "sausage"
  | "trash-can-clock"
  | "p"
  | "broom-wide"
  | "snowflake"
  | "stomach"
  | "newspaper"
  | "rectangle-ad"
  | "guitar-electric"
  | "arrow-turn-down-right"
  | "moon-cloud"
  | "bread-slice-butter"
  | "circle-arrow-right"
  | "user-group-crown"
  | "circle-i"
  | "toilet-paper-check"
  | "filter-circle-xmark"
  | "locust"
  | "sort"
  | "list-ol"
  | "chart-waterfall"
  | "sparkle"
  | "face-party"
  | "kidneys"
  | "wifi-exclamation"
  | "chart-network"
  | "person-dress-burst"
  | "dice-d4"
  | "money-check-dollar"
  | "vector-square"
  | "bread-slice"
  | "language"
  | "wheat-awn-slash"
  | "face-kiss-wink-heart"
  | "dagger"
  | "podium"
  | "diamonds-4"
  | "memo-circle-check"
  | "route-highway"
  | "down-to-line"
  | "filter"
  | "square-g"
  | "circle-phone"
  | "clipboard-prescription"
  | "user-nurse-hair"
  | "question"
  | "file-signature"
  | "toggle-large-on"
  | "up-down-left-right"
  | "dryer-heat"
  | "house-chimney-user"
  | "hand-holding-heart"
  | "arrow-up-small-big"
  | "train-track"
  | "puzzle-piece"
  | "money-check"
  | "star-half-stroke"
  | "file-exclamation"
  | "code"
  | "whiskey-glass"
  | "moon-stars"
  | "building-circle-exclamation"
  | "clothes-hanger"
  | "mobile-notch"
  | "magnifying-glass-chart"
  | "arrow-up-right-from-square"
  | "cubes-stacked"
  | "images-user"
  | "won-sign"
  | "image-polaroid-user"
  | "virus-covid"
  | "square-ellipsis"
  | "pie"
  | "chess-knight-piece"
  | "austral-sign"
  | "cloud-plus"
  | "f"
  | "leaf"
  | "bed-bunk"
  | "road"
  | "taxi"
  | "person-circle-plus"
  | "chart-pie"
  | "bolt-lightning"
  | "clock-eight"
  | "sack-xmark"
  | "file-xls"
  | "file-excel"
  | "file-contract"
  | "fish-fins"
  | "circle-q"
  | "building-flag"
  | "face-grin-beam"
  | "object-ungroup"
  | "face-disguise"
  | "circle-arrow-down-right"
  | "alien-8bit"
  | "hand-point-ribbon"
  | "poop"
  | "object-exclude"
  | "telescope"
  | "location-pin"
  | "square-list"
  | "kaaba"
  | "toilet-paper"
  | "helmet-safety"
  | "comment-code"
  | "sim-cards"
  | "starship"
  | "eject"
  | "circle-right"
  | "plane-circle-check"
  | "seal"
  | "user-cowboy"
  | "hexagon-vertical-nft"
  | "face-rolling-eyes"
  | "bread-loaf"
  | "rings-wedding"
  | "object-group"
  | "french-fries"
  | "chart-line"
  | "calendar-arrow-down"
  | "send-back"
  | "mask-ventilator"
  | "tickets"
  | "signature-lock"
  | "arrow-right"
  | "signs-post"
  | "octagon-plus"
  | "cash-register"
  | "person-circle-question"
  | "melon-slice"
  | "space-station-moon"
  | "message-smile"
  | "cup-straw"
  | "left-from-line"
  | "h"
  | "basket-shopping-simple"
  | "hands-holding-heart"
  | "clock-nine"
  | "hammer-brush"
  | "tarp"
  | "face-sleepy"
  | "hand-horns"
  | "screwdriver-wrench"
  | "arrows-to-eye"
  | "circle-three-quarters"
  | "trophy-star"
  | "plug-circle-bolt"
  | "face-thermometer"
  | "grid-round-4"
  | "sign-posts-wrench"
  | "shirt-running"
  | "book-circle-arrow-up"
  | "face-nauseated"
  | "heart"
  | "file-chart-pie"
  | "mars-and-venus"
  | "house-user"
  | "circle-arrow-down-left"
  | "dumpster-fire"
  | "hexagon-minus"
  | "left-to-line"
  | "house-crack"
  | "paw-simple"
  | "arrow-left-long-to-line"
  | "brackets-round"
  | "martini-glass-citrus"
  | "user-shakespeare"
  | "arrow-right-to-arc"
  | "face-surprise"
  | "bottle-water"
  | "circle-pause"
  | "gauge-circle-plus"
  | "folders"
  | "angel"
  | "value-absolute"
  | "rabbit"
  | "toilet-paper-slash"
  | "circle-euro"
  | "apple-whole"
  | "kitchen-set"
  | "diamond-half"
  | "lock-keyhole"
  | "r"
  | "temperature-quarter"
  | "square-info"
  | "wifi-slash"
  | "toilet-paper-xmark"
  | "hands-holding-dollar"
  | "cube"
  | "arrow-down-triangle-square"
  | "bitcoin-sign"
  | "shutters"
  | "shield-dog"
  | "solar-panel"
  | "lock-open"
  | "table-tree"
  | "house-chimney-heart"
  | "tally-3"
  | "elevator"
  | "money-bill-transfer"
  | "money-bill-trend-up"
  | "house-flood-water-circle-arrow-right"
  | "square-poll-horizontal"
  | "circle"
  | "left-to-bracket"
  | "cart-circle-exclamation"
  | "sword"
  | "backward-fast"
  | "recycle"
  | "user-astronaut"
  | "interrobang"
  | "plane-slash"
  | "circle-dashed"
  | "trademark"
  | "basketball"
  | "fork-knife"
  | "satellite-dish"
  | "badge-check"
  | "circle-up"
  | "slider"
  | "mobile-screen-button"
  | "clock-one-thirty"
  | "inbox-out"
  | "cloud-slash"
  | "volume-high"
  | "users-rays"
  | "wallet"
  | "octagon-check"
  | "flatbread-stuffed"
  | "clipboard-check"
  | "cart-circle-plus"
  | "truck-clock"
  | "pool-8-ball"
  | "file-audio"
  | "turn-down-left"
  | "lock-hashtag"
  | "chart-radar"
  | "staff"
  | "burger"
  | "utility-pole"
  | "transporter-6"
  | "arrow-turn-left"
  | "wrench"
  | "bugs"
  | "vector-polygon"
  | "diagram-nested"
  | "rupee-sign"
  | "file-image"
  | "circle-question"
  | "tickets-perforated"
  | "image-user"
  | "buoy"
  | "plane-departure"
  | "handshake-slash"
  | "book-bookmark"
  | "border-center-h"
  | "can-food"
  | "typewriter"
  | "arrow-right-from-arc"
  | "circle-k"
  | "face-hand-over-mouth"
  | "popcorn"
  | "house-water"
  | "object-subtract"
  | "code-branch"
  | "warehouse-full"
  | "hat-cowboy"
  | "bridge"
  | "phone-flip"
  | "arrow-down-from-dotted-line"
  | "file-doc"
  | "square-quarters"
  | "truck-front"
  | "cat"
  | "trash-xmark"
  | "circle-caret-left"
  | "files"
  | "anchor-circle-exclamation"
  | "face-clouds"
  | "user-crown"
  | "basket-shopping-plus"
  | "truck-field"
  | "route"
  | "cart-circle-check"
  | "clipboard-question"
  | "panorama"
  | "comment-medical"
  | "teeth-open"
  | "user-tie-hair-long"
  | "file-circle-minus"
  | "head-side-medical"
  | "arrow-turn-right"
  | "tags"
  | "wine-glass"
  | "forward-fast"
  | "face-meh-blank"
  | "user-robot"
  | "square-parking"
  | "card-diamond"
  | "face-zipper"
  | "face-raised-eyebrow"
  | "house-signal"
  | "square-chevron-up"
  | "bars-progress"
  | "faucet-drip"
  | "arrows-to-line"
  | "dolphin"
  | "arrow-up-right"
  | "circle-r"
  | "cart-flatbed"
  | "ban-smoking"
  | "circle-sort-up"
  | "terminal"
  | "mobile-button"
  | "house-medical-flag"
  | "basket-shopping"
  | "tape"
  | "chestnut"
  | "bus-simple"
  | "eye"
  | "face-sad-cry"
  | "heat"
  | "ticket-airline"
  | "boot-heeled"
  | "arrows-minimize"
  | "audio-description"
  | "person-military-to-person"
  | "file-shield"
  | "hexagon"
  | "manhole"
  | "user-slash"
  | "pen"
  | "tower-observation"
  | "floppy-disks"
  | "toilet-paper-blank-under"
  | "file-code"
  | "signal"
  | "pump"
  | "bus"
  | "heart-circle-xmark"
  | "arrow-up-left-from-circle"
  | "house-chimney"
  | "window-maximize"
  | "dryer"
  | "face-frown"
  | "chess-bishop-piece"
  | "shirt-tank-top"
  | "diploma"
  | "screencast"
  | "walker"
  | "prescription"
  | "shop"
  | "floppy-disk"
  | "vihara"
  | "face-kiss-closed-eyes"
  | "scale-unbalanced"
  | "file-user"
  | "user-police-tie"
  | "face-tongue-money"
  | "tennis-ball"
  | "square-l"
  | "sort-up"
  | "calendar-arrow-up"
  | "comment-dots"
  | "plant-wilt"
  | "scarf"
  | "album-circle-plus"
  | "user-nurse-hair-long"
  | "diamond"
  | "square-left"
  | "face-grin-squint"
  | "circle-ellipsis-vertical"
  | "hand-holding-dollar"
  | "grid-dividers"
  | "bacterium"
  | "hand-pointer"
  | "drum-steelpan"
  | "hand-scissors"
  | "hands-praying"
  | "face-pensive"
  | "user-music"
  | "arrow-rotate-right"
  | "messages-dollar"
  | "sensor-on"
  | "balloon"
  | "biohazard"
  | "chess-queen-piece"
  | "location-crosshairs"
  | "mars-double"
  | "left-from-bracket"
  | "house-person-leave"
  | "ruler-triangle"
  | "card-club"
  | "child-dress"
  | "users-between-lines"
  | "lungs-virus"
  | "spinner-third"
  | "face-grin-tears"
  | "phone"
  | "computer-mouse-scrollwheel"
  | "calendar-xmark"
  | "child-reaching"
  | "table-layout"
  | "narwhal"
  | "ramp-loading"
  | "calendar-circle-plus"
  | "toothbrush"
  | "border-inner"
  | "paw-claws"
  | "kiwi-fruit"
  | "traffic-light-slow"
  | "rectangle-code"
  | "head-side-virus"
  | "keyboard-brightness"
  | "books-medical"
  | "lightbulb-slash"
  | "house-blank"
  | "square-5"
  | "square-heart"
  | "puzzle"
  | "user-gear"
  | "pipe-circle-check"
  | "arrow-up-1-9"
  | "octagon-exclamation"
  | "dial-low"
  | "door-closed"
  | "laptop-mobile"
  | "conveyor-belt-boxes"
  | "shield-virus"
  | "starfighter-twin-ion-engine-advanced"
  | "dice-six"
  | "starfighter-twin-ion-engine"
  | "rocket-launch"
  | "mosquito-net"
  | "vent-damper"
  | "bridge-water"
  | "ban-bug"
  | "person-booth"
  | "text-width"
  | "garage-car"
  | "square-kanban"
  | "hat-wizard"
  | "chart-kanban"
  | "pen-fancy"
  | "coffee-pot"
  | "mouse-field"
  | "person-digging"
  | "shower-down"
  | "box-circle-check"
  | "brightness"
  | "car-side-bolt"
  | "file-xml"
  | "ornament"
  | "phone-arrow-down-left"
  | "cloud-word"
  | "hand-fingers-crossed"
  | "trash"
  | "gauge-simple"
  | "arrow-down-small-big"
  | "book-medical"
  | "face-melting"
  | "poo"
  | "pen-clip-slash"
  | "quote-right"
  | "scroll-old"
  | "guitars"
  | "phone-xmark"
  | "hose"
  | "clock-six"
  | "shirt"
  | "billboard"
  | "square-r"
  | "cubes"
  | "envelope-open-dollar"
  | "divide"
  | "sun-cloud"
  | "lamp-floor"
  | "square-7"
  | "tenge-sign"
  | "headphones"
  | "hands-holding"
  | "campfire"
  | "circle-ampersand"
  | "snowflakes"
  | "hands-clapping"
  | "republican"
  | "leaf-maple"
  | "arrow-left"
  | "person-circle-xmark"
  | "ruler"
  | "arrow-left-from-bracket"
  | "cup-straw-swoosh"
  | "temperature-sun"
  | "align-left"
  | "dice-d6"
  | "restroom"
  | "high-definition"
  | "j"
  | "galaxy"
  | "users-viewfinder"
  | "file-video"
  | "cherries"
  | "up-right-from-square"
  | "circle-sort"
  | "table-cells"
  | "bag-shopping-minus"
  | "file-pdf"
  | "siren"
  | "arrow-up-to-dotted-line"
  | "image-landscape"
  | "tank-water"
  | "curling-stone"
  | "gamepad-modern"
  | "messages-question"
  | "book-bible"
  | "o"
  | "suitcase-medical"
  | "briefcase-arrow-right"
  | "expand-wide"
  | "clock-eleven-thirty"
  | "rv"
  | "user-secret"
  | "otter"
  | "dreidel"
  | "person-dress"
  | "comment-dollar"
  | "business-time"
  | "flower-tulip"
  | "people-pants-simple"
  | "cloud-drizzle"
  | "table-cells-large"
  | "book-tanakh"
  | "solar-system"
  | "seal-question"
  | "phone-volume"
  | "disc-drive"
  | "hat-cowboy-side"
  | "table-rows"
  | "location-exclamation"
  | "face-fearful"
  | "clipboard-user"
  | "bus-school"
  | "film-slash"
  | "square-arrow-down-right"
  | "book-sparkles"
  | "washing-machine"
  | "child"
  | "lira-sign"
  | "user-visor"
  | "file-plus-minus"
  | "chess-clock-flip"
  | "satellite"
  | "truck-fire"
  | "plane-lock"
  | "steering-wheel"
  | "tag"
  | "stretcher"
  | "book-section"
  | "inboxes"
  | "coffee-bean"
  | "circle-yen"
  | "brackets-curly"
  | "ellipsis-stroke-vertical"
  | "comment"
  | "square-1"
  | "cake-candles"
  | "head-side"
  | "truck-ladder"
  | "envelope"
  | "dolly-empty"
  | "face-tissue"
  | "angles-up"
  | "bin-recycle"
  | "paperclip"
  | "chart-line-down"
  | "arrow-right-to-city"
  | "lock-a"
  | "ribbon"
  | "lungs"
  | "person-pinball"
  | "arrow-up-9-1"
  | "apple-core"
  | "circle-y"
  | "h6"
  | "litecoin-sign"
  | "bottle-baby"
  | "circle-small"
  | "border-none"
  | "arrow-turn-down-left"
  | "circle-wifi-circle-wifi"
  | "circle-nodes"
  | "parachute-box"
  | "reflect-horizontal"
  | "message-medical"
  | "rugby-ball"
  | "comment-music"
  | "indent"
  | "tree-deciduous"
  | "puzzle-piece-simple"
  | "truck-field-un"
  | "nfc-trash"
  | "hourglass"
  | "mountain"
  | "file-xmark"
  | "house-heart"
  | "house-chimney-blank"
  | "meter-bolt"
  | "user-doctor"
  | "slash-back"
  | "circle-info"
  | "fishing-rod"
  | "hammer-crash"
  | "message-heart"
  | "cloud-meatball"
  | "camera-polaroid"
  | "camera"
  | "square-virus"
  | "cart-arrow-up"
  | "meteor"
  | "car-on"
  | "sleigh"
  | "arrow-down-1-9"
  | "buoy-mooring"
  | "square-4"
  | "hand-holding-droplet"
  | "file-eps"
  | "tricycle-adult"
  | "waveform"
  | "water"
  | "star-sharp-half-stroke"
  | "nfc-signal"
  | "plane-prop"
  | "calendar-check"
  | "clock-desk"
  | "calendar-clock"
  | "braille"
  | "prescription-bottle-medical"
  | "plate-utensils"
  | "family-pants"
  | "hose-reel"
  | "house-window"
  | "landmark"
  | "truck"
  | "music-magnifying-glass"
  | "crosshairs"
  | "cloud-rainbow"
  | "person-cane"
  | "alien"
  | "tent"
  | "laptop-binary"
  | "vest-patches"
  | "people-dress-simple"
  | "check-double"
  | "arrow-down-a-z"
  | "bowling-ball-pin"
  | "bell-school-slash"
  | "plus-large"
  | "money-bill-wheat"
  | "camera-viewfinder"
  | "message-music"
  | "car-building"
  | "border-bottom-right"
  | "octagon"
  | "comment-arrow-up-right"
  | "octagon-divide"
  | "cookie"
  | "arrow-rotate-left"
  | "tv-music"
  | "hard-drive"
  | "reel"
  | "face-grin-squint-tears"
  | "dumbbell"
  | "rectangle-list"
  | "tarp-droplet"
  | "alarm-exclamation"
  | "house-medical-circle-check"
  | "traffic-cone"
  | "grate"
  | "arrow-down-right"
  | "person-skiing-nordic"
  | "calendar-plus"
  | "person-from-portal"
  | "plane-arrival"
  | "cowbell-circle-plus"
  | "circle-left"
  | "distribute-spacing-vertical"
  | "signal-bars-fair"
  | "sportsball"
  | "game-console-handheld-crank"
  | "train-subway"
  | "chart-gantt"
  | "face-smile-upside-down"
  | "ball-pile"
  | "badge-dollar"
  | "money-bills-simple"
  | "list-timeline"
  | "indian-rupee-sign"
  | "crop-simple"
  | "money-bill-1"
  | "left-long"
  | "keyboard-down"
  | "circle-up-right"
  | "cloud-bolt-moon"
  | "turn-left-up"
  | "dna"
  | "virus-slash"
  | "bracket-round-right"
  | "circle-sterling"
  | "circle-5"
  | "minus"
  | "fire-flame"
  | "right-to-line"
  | "gif"
  | "chess"
  | "trash-slash"
  | "arrow-left-long"
  | "plug-circle-check"
  | "font-case"
  | "street-view"
  | "arrow-down-left"
  | "franc-sign"
  | "flask-round-poison"
  | "volume-off"
  | "book-circle-arrow-right"
  | "chart-user"
  | "hands-asl-interpreting"
  | "presentation-screen"
  | "circle-bolt"
  | "face-smile-halo"
  | "cart-circle-arrow-down"
  | "house-person-return"
  | "message-xmark"
  | "file-certificate"
  | "user-doctor-hair-long"
  | "camera-security"
  | "gear"
  | "droplet-slash"
  | "book-heart"
  | "mosque"
  | "duck"
  | "mosquito"
  | "star-of-david"
  | "flag-swallowtail"
  | "person-military-rifle"
  | "car-garage"
  | "cart-shopping"
  | "book-font"
  | "shield-plus"
  | "vials"
  | "eye-dropper-full"
  | "distribute-spacing-horizontal"
  | "tablet-rugged"
  | "temperature-snow"
  | "moped"
  | "face-smile-plus"
  | "radio-tuner"
  | "face-swear"
  | "water-arrow-down"
  | "scanner-touchscreen"
  | "circle-7"
  | "plug-circle-plus"
  | "person-ski-jumping"
  | "place-of-worship"
  | "water-arrow-up"
  | "waveform-lines"
  | "split"
  | "film-canister"
  | "folder-xmark"
  | "toilet-paper-blank"
  | "tablet-screen"
  | "hexagon-vertical-nft-slanted"
  | "folder-music"
  | "display-medical"
  | "share-all"
  | "peapod"
  | "chess-clock"
  | "axe"
  | "square-d"
  | "grip-vertical"
  | "mobile-signal-out"
  | "arrow-turn-up"
  | "u"
  | "arrow-up-from-dotted-line"
  | "square-root-variable"
  | "light-switch-on"
  | "arrow-down-arrow-up"
  | "raindrops"
  | "dash"
  | "clock"
  | "input-numeric"
  | "truck-tow"
  | "backward-step"
  | "pallet"
  | "car-bolt"
  | "arrows-maximize"
  | "faucet"
  | "cloud-sleet"
  | "lamp-street"
  | "list-radio"
  | "pen-nib-slash"
  | "baseball-bat-ball"
  | "square-up-left"
  | "overline"
  | "s"
  | "timeline"
  | "keyboard"
  | "arrows-from-dotted-line"
  | "usb-drive"
  | "ballot"
  | "caret-down"
  | "location-dot-slash"
  | "cards"
  | "house-chimney-medical"
  | "boxing-glove"
  | "temperature-three-quarters"
  | "bell-school"
  | "mobile-screen"
  | "plane-up"
  | "folder-heart"
  | "circle-location-arrow"
  | "face-head-bandage"
  | "sushi-roll"
  | "car-bump"
  | "piggy-bank"
  | "racquet"
  | "car-mirrors"
  | "industry-windows"
  | "bolt-auto"
  | "battery-half"
  | "flux-capacitor"
  | "mountain-city"
  | "coins"
  | "honey-pot"
  | "olive"
  | "khanda"
  | "filter-list"
  | "outlet"
  | "sliders"
  | "cauldron"
  | "people"
  | "folder-tree"
  | "network-wired"
  | "croissant"
  | "map-pin"
  | "hamsa"
  | "cent-sign"
  | "swords-laser"
  | "flask"
  | "person-pregnant"
  | "square-u"
  | "wand-sparkles"
  | "router"
  | "ellipsis-vertical"
  | "sword-laser-alt"
  | "ticket"
  | "power-off"
  | "coin"
  | "laptop-slash"
  | "right-long"
  | "circle-b"
  | "person-dress-simple"
  | "pipe-collar"
  | "lights-holiday"
  | "citrus"
  | "flag-usa"
  | "laptop-file"
  | "tty"
  | "chart-tree-map"
  | "diagram-next"
  | "person-rifle"
  | "clock-five-thirty"
  | "pipe-valve"
  | "lightbulb-message"
  | "arrow-up-from-arc"
  | "face-spiral-eyes"
  | "compress-wide"
  | "circle-phone-hangup"
  | "gear-complex-code"
  | "house-medical-circle-exclamation"
  | "badminton"
  | "closed-captioning"
  | "person-hiking"
  | "right-from-line"
  | "venus-double"
  | "images"
  | "calculator"
  | "shuttlecock"
  | "user-hair"
  | "eye-evil"
  | "people-pulling"
  | "n"
  | "swap"
  | "garage"
  | "cable-car"
  | "shovel-snow"
  | "cloud-rain"
  | "face-lying"
  | "sprinkler"
  | "building-circle-xmark"
  | "person-sledding"
  | "game-console-handheld"
  | "ship"
  | "clock-six-thirty"
  | "battery-slash"
  | "tugrik-sign"
  | "arrows-down-to-line"
  | "download"
  | "angles-up-down"
  | "shelves"
  | "cloud-snow"
  | "face-grin"
  | "delete-left"
  | "oven"
  | "cloud-binary"
  | "eye-dropper"
  | "comment-captions"
  | "comments-question"
  | "scribble"
  | "rotate-exclamation"
  | "file-circle-check"
  | "glass"
  | "loader"
  | "forward"
  | "user-pilot"
  | "mobile"
  | "code-pull-request-closed"
  | "face-meh"
  | "align-center"
  | "book-skull"
  | "id-card"
  | "face-dotted"
  | "face-worried"
  | "outdent"
  | "court-sport"
  | "heart-circle-exclamation"
  | "house"
  | "vector-circle"
  | "car-circle-bolt"
  | "calendar-week"
  | "flying-disc"
  | "laptop-medical"
  | "square-down-right"
  | "b"
  | "seat-airline"
  | "moon-over-sun"
  | "pipe"
  | "file-medical"
  | "potato"
  | "dice-one"
  | "circle-a"
  | "helmet-battle"
  | "butter"
  | "blanket-fire"
  | "kiwi-bird"
  | "castle"
  | "golf-club"
  | "arrow-right-arrow-left"
  | "rotate-right"
  | "utensils"
  | "arrow-up-wide-short"
  | "chart-pie-simple-circle-dollar"
  | "balloons"
  | "mill-sign"
  | "bowl-rice"
  | "timeline-arrow"
  | "skull"
  | "game-board-simple"
  | "circle-video"
  | "chart-scatter-bubble"
  | "house-turret"
  | "banana"
  | "hand-holding-skull"
  | "people-dress"
  | "loveseat"
  | "tower-broadcast"
  | "truck-pickup"
  | "block-quote"
  | "up-long"
  | "stop"
  | "code-merge"
  | "money-check-dollar-pen"
  | "up-from-line"
  | "upload"
  | "hurricane"
  | "grid-round-2-plus"
  | "people-pants"
  | "mound"
  | "windsock"
  | "circle-half"
  | "brake-warning"
  | "toilet-portable"
  | "compact-disc"
  | "file-arrow-down"
  | "saxophone-fire"
  | "camera-web-slash"
  | "folder-medical"
  | "folder-gear"
  | "hand-wave"
  | "arrow-up-arrow-down"
  | "caravan"
  | "shield-cat"
  | "message-slash"
  | "bolt"
  | "trash-can-check"
  | "glass-water"
  | "oil-well"
  | "table-cells-column-unlock"
  | "person-simple"
  | "arrow-turn-left-up"
  | "vault"
  | "mars"
  | "toilet"
  | "plane-circle-xmark"
  | "yen-sign"
  | "gear-code"
  | "notes"
  | "ruble-sign"
  | "trash-undo"
  | "champagne-glass"
  | "objects-align-center-horizontal"
  | "sun"
  | "trash-can-slash"
  | "screen-users"
  | "guitar"
  | "square-arrow-left"
  | "square-8"
  | "face-smile-hearts"
  | "brackets-square"
  | "laptop-arrow-down"
  | "hockey-stick-puck"
  | "house-tree"
  | "signal-fair"
  | "face-laugh-wink"
  | "circle-dollar"
  | "horse-head"
  | "arrows-repeat"
  | "bore-hole"
  | "industry"
  | "image-polaroid"
  | "wave-triangle"
  | "turn-left-down"
  | "person-running-fast"
  | "circle-down"
  | "grill"
  | "arrows-turn-to-dots"
  | "chart-mixed"
  | "florin-sign"
  | "arrow-down-short-wide"
  | "less-than"
  | "display-code"
  | "face-drooling"
  | "oil-temperature"
  | "square-question"
  | "air-conditioner"
  | "angle-down"
  | "mountains"
  | "omega"
  | "car-tunnel"
  | "person-dolly-empty"
  | "pan-food"
  | "head-side-cough"
  | "grip-lines"
  | "thumbs-down"
  | "user-lock"
  | "arrow-right-long"
  | "tickets-airline"
  | "tent-double-peak"
  | "anchor-circle-xmark"
  | "ellipsis"
  | "nfc-slash"
  | "chess-pawn"
  | "kit-medical"
  | "grid-2-plus"
  | "bells"
  | "person-through-window"
  | "toolbox"
  | "globe-wifi"
  | "envelope-dot"
  | "magnifying-glass-waveform"
  | "hands-holding-circle"
  | "bug"
  | "bowl-chopsticks"
  | "credit-card"
  | "circle-s"
  | "box-ballot"
  | "car"
  | "hand-holding-hand"
  | "user-tie-hair"
  | "podium-star"
  | "user-hair-mullet"
  | "microphone-stand"
  | "book-open-reader"
  | "family-dress"
  | "circle-x"
  | "cabin"
  | "mountain-sun"
  | "chart-simple-horizontal"
  | "arrows-left-right-to-line"
  | "hand-back-point-left"
  | "message-dots"
  | "file-heart"
  | "beer-mug"
  | "dice-d20"
  | "drone"
  | "truck-droplet"
  | "file-circle-xmark"
  | "temperature-arrow-up"
  | "medal"
  | "person-fairy"
  | "bed"
  | "book-copy"
  | "square-h"
  | "square-c"
  | "clock-two"
  | "square-ellipsis-vertical"
  | "calendar-users"
  | "podcast"
  | "bee"
  | "temperature-full"
  | "bell"
  | "candy-bar"
  | "xmark-large"
  | "pinata"
  | "file-ppt"
  | "arrows-from-line"
  | "superscript"
  | "bowl-spoon"
  | "hexagon-check"
  | "plug-circle-xmark"
  | "star-of-life"
  | "phone-slash"
  | "traffic-light-stop"
  | "paint-roller"
  | "accent-grave"
  | "handshake-angle"
  | "circle-0"
  | "dial-med-low"
  | "location-dot"
  | "crab"
  | "box-open-full"
  | "file"
  | "greater-than"
  | "quotes"
  | "pretzel"
  | "t-rex"
  | "person-swimming"
  | "arrow-down"
  | "user-robot-xmarks"
  | "message-quote"
  | "candy-corn"
  | "folder-magnifying-glass"
  | "notebook"
  | "circle-wifi"
  | "droplet"
  | "bullseye-pointer"
  | "eraser"
  | "hexagon-image"
  | "earth-americas"
  | "file-svg"
  | "crate-apple"
  | "person-burst"
  | "game-board"
  | "hat-chef"
  | "hand-back-point-right"
  | "dove"
  | "snowflake-droplets"
  | "battery-empty"
  | "grid-4"
  | "socks"
  | "face-sunglasses"
  | "inbox"
  | "square-0"
  | "section"
  | "square-this-way-up"
  | "gauge-high"
  | "square-ampersand"
  | "envelope-open-text"
  | "lamp-desk"
  | "hospital"
  | "poll-people"
  | "whiskey-glass-ice"
  | "wine-bottle"
  | "chess-rook"
  | "user-bounty-hunter"
  | "bars-staggered"
  | "diagram-sankey"
  | "cloud-hail-mixed"
  | "circle-up-left"
  | "dharmachakra"
  | "objects-align-left"
  | "oil-can-drip"
  | "face-smiling-hands"
  | "broccoli"
  | "route-interstate"
  | "ear-muffs"
  | "hotdog"
  | "transporter-empty"
  | "person-walking-with-cane"
  | "angle-90"
  | "rectangle-terminal"
  | "kite"
  | "drum"
  | "scrubber"
  | "ice-cream"
  | "heart-circle-bolt"
  | "fish-bones"
  | "deer-rudolph"
  | "fax"
  | "paragraph"
  | "head-side-heart"
  | "square-e"
  | "meter-fire"
  | "cloud-hail"
  | "check-to-slot"
  | "money-from-bracket"
  | "star-half"
  | "car-bus"
  | "speaker"
  | "timer"
  | "boxes-stacked"
  | "landmark-magnifying-glass"
  | "grill-hot"
  | "ballot-check"
  | "link"
  | "ear-listen"
  | "file-minus"
  | "tree-city"
  | "play"
  | "font"
  | "cup-togo"
  | "square-down-left"
  | "burger-lettuce"
  | "table-cells-row-lock"
  | "rupiah-sign"
  | "magnifying-glass"
  | "table-tennis-paddle-ball"
  | "person-dots-from-line"
  | "chevrons-down"
  | "trash-can-arrow-up"
  | "signal-good"
  | "location-question"
  | "floppy-disk-circle-xmark"
  | "naira-sign"
  | "peach"
  | "taxi-bus"
  | "bracket-curly"
  | "lobster"
  | "cart-flatbed-empty"
  | "colon"
  | "cart-arrow-down"
  | "wand"
  | "walkie-talkie"
  | "file-pen"
  | "receipt"
  | "table-picnic"
  | "square-pen"
  | "circle-microphone-lines"
  | "display-slash"
  | "suitcase-rolling"
  | "person-circle-exclamation"
  | "transporter-2"
  | "user-hoodie"
  | "hands-holding-diamond"
  | "money-bill-simple-wave"
  | "chevron-down"
  | "battery-full"
  | "bell-plus"
  | "book-arrow-right"
  | "hospitals"
  | "club"
  | "skull-crossbones"
  | "droplet-degree"
  | "code-compare"
  | "list-ul"
  | "hand-holding-magic"
  | "watermelon-slice"
  | "circle-ellipsis"
  | "school-lock"
  | "tower-cell"
  | "sd-cards"
  | "jug-bottle"
  | "down-long"
  | "envelopes"
  | "phone-office"
  | "ranking-star"
  | "chess-king"
  | "nfc-pen"
  | "person-harassing"
  | "magnifying-glass-play"
  | "hat-winter"
  | "brazilian-real-sign"
  | "landmark-dome"
  | "bone-break"
  | "arrow-up"
  | "down-from-dotted-line"
  | "tv"
  | "border-left"
  | "circle-divide"
  | "shrimp"
  | "list-check"
  | "diagram-subtask"
  | "jug-detergent"
  | "circle-user"
  | "square-y"
  | "user-doctor-hair"
  | "planet-ringed"
  | "mushroom"
  | "user-shield"
  | "megaphone"
  | "wreath-laurel"
  | "circle-exclamation-check"
  | "wind"
  | "box-dollar"
  | "car-burst"
  | "y"
  | "user-headset"
  | "arrows-retweet"
  | "person-snowboarding"
  | "square-chevron-right"
  | "lacrosse-stick-ball"
  | "truck-fast"
  | "user-magnifying-glass"
  | "star-sharp"
  | "comment-heart"
  | "circle-1"
  | "circle-star"
  | "fish"
  | "cloud-fog"
  | "waffle"
  | "music-note"
  | "hexagon-exclamation"
  | "cart-shopping-fast"
  | "object-union"
  | "user-graduate"
  | "starfighter"
  | "circle-half-stroke"
  | "arrow-right-long-to-line"
  | "square-arrow-down"
  | "diamond-half-stroke"
  | "clapperboard"
  | "square-chevron-left"
  | "phone-intercom"
  | "link-horizontal"
  | "mango"
  | "music-note-slash"
  | "circle-radiation"
  | "face-tongue-sweat"
  | "globe-stand"
  | "baseball"
  | "circle-p"
  | "award-simple"
  | "jet-fighter-up"
  | "diagram-project"
  | "pedestal"
  | "chart-pyramid"
  | "sidebar"
  | "snowman-head"
  | "copy"
  | "burger-glass"
  | "volume-xmark"
  | "hand-sparkles"
  | "bars-filter"
  | "paintbrush-pencil"
  | "party-bell"
  | "user-vneck-hair"
  | "jack-o-lantern"
  | "grip"
  | "share-from-square"
  | "keynote"
  | "child-combatant"
  | "gun"
  | "square-phone"
  | "hat-beach"
  | "plus"
  | "expand"
  | "computer"
  | "fort"
  | "cloud-check"
  | "xmark"
  | "face-smirking"
  | "arrows-up-down-left-right"
  | "chalkboard-user"
  | "rhombus"
  | "claw-marks"
  | "peso-sign"
  | "face-smile-tongue"
  | "cart-circle-xmark"
  | "building-shield"
  | "circle-phone-flip"
  | "baby"
  | "users-line"
  | "quote-left"
  | "tractor"
  | "down-from-bracket"
  | "key-skeleton"
  | "trash-arrow-up"
  | "arrow-down-up-lock"
  | "arrow-down-to-bracket"
  | "lines-leaning"
  | "square-q"
  | "ruler-combined"
  | "symbols"
  | "copyright"
  | "flask-gear"
  | "highlighter-line"
  | "bracket-square"
  | "island-tropical"
  | "arrow-right-from-line"
  | "h2"
  | "equals"
  | "cake-slice"
  | "building-magnifying-glass"
  | "peanut"
  | "wrench-simple"
  | "blender"
  | "teeth"
  | "tally-2"
  | "shekel-sign"
  | "cars"
  | "axe-battle"
  | "user-hair-long"
  | "map"
  | "arrow-left-from-arc"
  | "file-circle-info"
  | "face-disappointed"
  | "lasso-sparkles"
  | "clock-eleven"
  | "rocket"
  | "siren-on"
  | "clock-ten"
  | "candle-holder"
  | "video-arrow-down-left"
  | "photo-film"
  | "floppy-disk-circle-arrow-right"
  | "folder-minus"
  | "planet-moon"
  | "face-eyes-xmarks"
  | "chart-scatter"
  | "circle-gf"
  | "display-arrow-down"
  | "store"
  | "arrow-trend-up"
  | "plug-circle-minus"
  | "olive-branch"
  | "angle"
  | "vacuum-robot"
  | "sign-hanging"
  | "square-divide"
  | "folder-check"
  | "signal-stream-slash"
  | "bezier-curve"
  | "eye-dropper-half"
  | "store-lock"
  | "bell-slash"
  | "cloud-bolt-sun"
  | "camera-slash"
  | "comment-quote"
  | "tablet"
  | "school-flag"
  | "message-code"
  | "glass-half"
  | "fill"
  | "message-minus"
  | "angle-up"
  | "dinosaur"
  | "drumstick-bite"
  | "link-horizontal-slash"
  | "holly-berry"
  | "nose"
  | "arrow-left-to-arc"
  | "chevron-left"
  | "bacteria"
  | "clouds"
  | "money-bill-simple"
  | "hand-lizard"
  | "table-pivot"
  | "filter-slash"
  | "trash-can-undo"
  | "notdef"
  | "disease"
  | "person-to-door"
  | "turntable"
  | "briefcase-medical"
  | "genderless"
  | "chevron-right"
  | "signal-weak"
  | "clock-five"
  | "retweet"
  | "car-rear"
  | "pump-soap"
  | "computer-classic"
  | "frame"
  | "video-slash"
  | "battery-quarter"
  | "ellipsis-stroke"
  | "radio"
  | "baby-carriage"
  | "face-expressionless"
  | "down-to-dotted-line"
  | "cloud-music"
  | "traffic-light"
  | "cloud-minus"
  | "thermometer"
  | "shield-minus"
  | "vr-cardboard"
  | "car-tilt"
  | "gauge-circle-minus"
  | "brightness-low"
  | "hand-middle-finger"
  | "percent"
  | "truck-moving"
  | "glass-water-droplet"
  | "conveyor-belt"
  | "location-check"
  | "coin-vertical"
  | "display"
  | "person-sign"
  | "face-smile"
  | "phone-hangup"
  | "signature-slash"
  | "thumbtack"
  | "wheat-slash"
  | "trophy"
  | "clouds-sun"
  | "person-praying"
  | "hammer"
  | "face-vomit"
  | "speakers"
  | "tty-answer"
  | "mug-tea-saucer"
  | "diagram-lean-canvas"
  | "alt"
  | "dial"
  | "hand-peace"
  | "circle-trash"
  | "rotate"
  | "circle-quarters"
  | "spinner"
  | "tower-control"
  | "arrow-up-triangle-square"
  | "whale"
  | "robot"
  | "peace"
  | "party-horn"
  | "gears"
  | "sun-bright"
  | "warehouse"
  | "conveyor-belt-arm"
  | "lock-keyhole-open"
  | "square-fragile"
  | "arrow-up-right-dots"
  | "square-n"
  | "splotch"
  | "face-grin-hearts"
  | "meter"
  | "mandolin"
  | "dice-four"
  | "sim-card"
  | "transgender"
  | "mercury"
  | "up-from-bracket"
  | "knife-kitchen"
  | "border-right"
  | "arrow-turn-down"
  | "spade"
  | "card-spade"
  | "line-columns"
  | "ant"
  | "arrow-right-to-line"
  | "person-falling-burst"
  | "flag-pennant"
  | "conveyor-belt-empty"
  | "user-group-simple"
  | "award"
  | "ticket-simple"
  | "building"
  | "angles-left"
  | "camcorder"
  | "pancakes"
  | "album-circle-user"
  | "subtitles-slash"
  | "qrcode"
  | "dice-d10"
  | "fireplace"
  | "browser"
  | "pen-paintbrush"
  | "fish-cooked"
  | "chair-office"
  | "magnifying-glass-music"
  | "nesting-dolls"
  | "clock-rotate-left"
  | "trumpet"
  | "face-grin-beam-sweat"
  | "fire-smoke"
  | "phone-missed"
  | "file-export"
  | "shield"
  | "arrow-up-short-wide"
  | "arrows-repeat-1"
  | "gun-slash"
  | "avocado"
  | "binary"
  | "glasses-round"
  | "phone-plus"
  | "ditto"
  | "person-seat"
  | "house-medical"
  | "golf-ball-tee"
  | "circle-chevron-left"
  | "house-chimney-window"
  | "scythe"
  | "pen-nib"
  | "ban-parking"
  | "tent-arrow-turn-left"
  | "face-diagonal-mouth"
  | "diagram-cells"
  | "cricket-bat-ball"
  | "tents"
  | "wand-magic"
  | "dog"
  | "pen-line"
  | "atom-simple"
  | "ampersand"
  | "carrot"
  | "arrow-up-from-line"
  | "moon"
  | "pen-slash"
  | "wine-glass-empty"
  | "square-star"
  | "cheese"
  | "send-backward"
  | "yin-yang"
  | "music"
  | "compass-slash"
  | "clock-one"
  | "file-music"
  | "code-commit"
  | "temperature-low"
  | "person-biking"
  | "display-chart-up-circle-currency"
  | "skeleton"
  | "circle-g"
  | "circle-arrow-up-left"
  | "coin-blank"
  | "broom"
  | "vacuum"
  | "shield-heart"
  | "card-heart"
  | "lightbulb-cfl-on"
  | "melon"
  | "gopuram"
  | "earth-oceania"
  | "container-storage"
  | "face-pouting"
  | "square-xmark"
  | "face-explode"
  | "hashtag"
  | "up-right-and-down-left-from-center"
  | "oil-can"
  | "t"
  | "transformer-bolt"
  | "hippo"
  | "chart-column"
  | "cassette-vhs"
  | "infinity"
  | "vial-circle-check"
  | "chimney"
  | "object-intersect"
  | "person-arrow-down-to-line"
  | "voicemail"
  | "block-brick"
  | "fan"
  | "bags-shopping"
  | "paragraph-left"
  | "person-walking-luggage"
  | "caravan-simple"
  | "turtle"
  | "pencil-mechanical"
  | "up-down"
  | "cloud-moon-rain"
  | "booth-curtain"
  | "calendar"
  | "box-heart"
  | "trailer"
  | "user-doctor-message"
  | "bahai"
  | "lighthouse"
  | "amp-guitar"
  | "sd-card"
  | "volume-slash"
  | "border-bottom"
  | "wifi-weak"
  | "dragon"
  | "shoe-prints"
  | "circle-plus"
  | "face-grin-tongue-wink"
  | "hand-holding"
  | "plug-circle-exclamation"
  | "link-slash"
  | "clone"
  | "person-walking-arrow-loop-left"
  | "arrow-up-z-a"
  | "fire-flame-curved"
  | "tornado"
  | "file-circle-plus"
  | "delete-right"
  | "book-quran"
  | "circle-quarter"
  | "anchor"
  | "border-all"
  | "function"
  | "face-angry"
  | "people-simple"
  | "cookie-bite"
  | "arrow-trend-down"
  | "rss"
  | "face-monocle"
  | "draw-polygon"
  | "scale-balanced"
  | "calendar-lines"
  | "arrow-down-big-small"
  | "gauge-simple-high"
  | "do-not-enter"
  | "shower"
  | "dice-d8"
  | "desktop"
  | "m"
  | "spinner-scale"
  | "grip-dots-vertical"
  | "face-viewfinder"
  | "soft-serve"
  | "h5"
  | "hand-back-point-down"
  | "table-list"
  | "basket-shopping-minus"
  | "comment-sms"
  | "rectangle"
  | "clipboard-list-check"
  | "turkey"
  | "book"
  | "user-plus"
  | "ice-skate"
  | "check"
  | "battery-three-quarters"
  | "tomato"
  | "sword-laser"
  | "house-circle-check"
  | "buildings"
  | "angle-left"
  | "cart-flatbed-boxes"
  | "diagram-successor"
  | "truck-arrow-right"
  | "square-w"
  | "arrows-split-up-and-left"
  | "lamp"
  | "airplay"
  | "hand-fist"
  | "shield-quartered"
  | "slash-forward"
  | "location-pen"
  | "cloud-moon"
  | "pot-food"
  | "briefcase"
  | "person-falling"
  | "image-portrait"
  | "user-tag"
  | "rug"
  | "print-slash"
  | "earth-europe"
  | "cart-flatbed-suitcase"
  | "hand-back-point-ribbon"
  | "rectangle-xmark"
  | "tire-rugged"
  | "lightbulb-dollar"
  | "cowbell"
  | "baht-sign"
  | "corner"
  | "chevrons-right"
  | "book-open"
  | "book-journal-whills"
  | "inhaler"
  | "handcuffs"
  | "snake"
  | "triangle-exclamation"
  | "note-medical"
  | "database"
  | "down-left"
  | "share"
  | "face-thinking"
  | "turn-down-right"
  | "bottle-droplet"
  | "mask-face"
  | "hill-rockslide"
  | "scanner-keyboard"
  | "circle-o"
  | "grid-horizontal"
  | "message-dollar"
  | "right-left"
  | "columns-3"
  | "paper-plane"
  | "road-circle-exclamation"
  | "dungeon"
  | "hand-holding-box"
  | "input-text"
  | "window-flip"
  | "align-right"
  | "scanner-gun"
  | "tire"
  | "engine"
  | "money-bill-1-wave"
  | "life-ring"
  | "hands"
  | "circle-caret-right"
  | "turn-left"
  | "wheat"
  | "file-spreadsheet"
  | "audio-description-slash"
  | "bell-ring"
  | "calendar-day"
  | "water-ladder"
  | "arrows-up-down"
  | "chess-pawn-piece"
  | "face-grimace"
  | "wheelchair-move"
  | "turn-down"
  | "square-s"
  | "rectangle-barcode"
  | "person-walking-arrow-right"
  | "square-envelope"
  | "dice"
  | "unicorn"
  | "bowling-ball"
  | "pompebled"
  | "brain"
  | "watch-smart"
  | "book-user"
  | "sensor-cloud"
  | "clapperboard-play"
  | "bandage"
  | "calendar-minus"
  | "circle-xmark"
  | "circle-4"
  | "gifts"
  | "album-collection"
  | "hotel"
  | "earth-asia"
  | "id-card-clip"
  | "magnifying-glass-plus"
  | "thumbs-up"
  | "cloud-showers"
  | "user-clock"
  | "onion"
  | "clock-twelve-thirty"
  | "arrow-down-to-dotted-line"
  | "hand-dots"
  | "file-invoice"
  | "window-minimize"
  | "rectangle-wide"
  | "comment-arrow-up"
  | "garlic"
  | "mug-saucer"
  | "brush"
  | "tree-decorated"
  | "mask"
  | "calendar-heart"
  | "magnifying-glass-minus"
  | "flower"
  | "arrow-down-from-arc"
  | "right-left-large"
  | "ruler-vertical"
  | "circles-overlap"
  | "user-large"
  | "starship-freighter"
  | "train-tram"
  | "bridge-suspension"
  | "trash-check"
  | "user-nurse"
  | "boombox"
  | "syringe"
  | "cloud-sun"
  | "shield-exclamation"
  | "stopwatch-20"
  | "square-full"
  | "grip-dots"
  | "comment-exclamation"
  | "pen-swirl"
  | "falafel"
  | "circle-2"
  | "magnet"
  | "jar"
  | "gramophone"
  | "dice-d12"
  | "note-sticky"
  | "down"
  | "hundred-points"
  | "paperclip-vertical"
  | "wind-warning"
  | "location-pin-slash"
  | "face-sad-sweat"
  | "bug-slash"
  | "cupcake"
  | "light-switch-off"
  | "toggle-large-off"
  | "pen-fancy-slash"
  | "truck-container"
  | "boot"
  | "arrow-up-from-water-pump"
  | "file-check"
  | "bone"
  | "cards-blank"
  | "circle-3"
  | "bench-tree"
  | "keyboard-brightness-low"
  | "ski-boot-ski"
  | "brain-circuit"
  | "table-cells-row-unlock"
  | "user-injured"
  | "block-brick-fire"
  | "face-sad-tear"
  | "plane"
  | "tent-arrows-down"
  | "exclamation"
  | "arrows-spin"
  | "face-smile-relaxed"
  | "comment-xmark"
  | "print"
  | "turkish-lira-sign"
  | "face-nose-steam"
  | "circle-waveform-lines"
  | "dollar-sign"
  | "ferris-wheel"
  | "computer-speaker"
  | "skull-cow"
  | "x"
  | "magnifying-glass-dollar"
  | "users-gear"
  | "person-military-pointing"
  | "building-columns"
  | "circle-t"
  | "sack"
  | "grid-2"
  | "camera-cctv"
  | "umbrella"
  | "trowel"
  | "horizontal-rule"
  | "bed-front"
  | "d"
  | "stapler"
  | "masks-theater"
  | "file-gif"
  | "kip-sign"
  | "face-woozy"
  | "cloud-question"
  | "pineapple"
  | "hand-point-left"
  | "gallery-thumbnails"
  | "circle-j"
  | "eyes"
  | "handshake-simple"
  | "page-caret-up"
  | "jet-fighter"
  | "comet"
  | "square-share-nodes"
  | "reflect-vertical"
  | "shield-keyhole"
  | "file-mp4"
  | "barcode"
  | "bulldozer"
  | "plus-minus"
  | "square-sliders-vertical"
  | "video"
  | "message-middle"
  | "graduation-cap"
  | "hand-holding-medical"
  | "person-circle-check"
  | "square-z"
  | "message-text"
  | "turn-up";
