import { FAIdentifier } from "../fa-icons";
/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export interface OSPropertyProps {
    primary?: OSPropertyOccupant,
    property: OSPropertyGroup,
}
/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export enum OSPropertyOwnerType {
    Private = "private",
    Trust = "trust",
    Company = "company",
}
/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export enum OSPropertyGroupType {
    House = "house",
    Unit = "unit",
    Building = "building",
    Erf = "erf",
    Business = "business"
}
/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export enum OSPropertyResidencyRecordType {
    OwnerResident = "ownerResident",
    LongTermTenant = "longTermTenant",
    ShortTermTenant = "shortTermTenant",
    HolidayTenant = "holidayTenant",
}
/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export enum OSPropertyContactRole {
    PrimaryResident = 'primaryResident',
    Spouse = 'spouse',
    Child = 'child',
    Tenant = 'tenant',
    Guest = 'guest',
    Resident = 'resident',
    Friend = 'friend'
}
/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
interface PropertyDictionaryEntry {
    type: OSPropertyGroupType;
    icon: FAIdentifier;
    label: string;
}
/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
interface PropertyRoleDictionaryEntry {
    role: OSPropertyContactRole;
    icon: FAIdentifier;
    label: string;
}
/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
interface PropertyOwnershipDictionaryEntry {
    type: OSPropertyOwnerType;
    label: string;
    icon: FAIdentifier;
}
/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export const PropertyDictionary: PropertyDictionaryEntry[] = [
    { type: OSPropertyGroupType.House, icon: "house", label: "House" },
    { type: OSPropertyGroupType.Unit, icon: "door-closed", label: "Unit" },
    { type: OSPropertyGroupType.Building, icon: "building", label: "Building" },
    { type: OSPropertyGroupType.Erf, icon: "frame", label: "Erf" },
    { type: OSPropertyGroupType.Business, icon: "briefcase", label: "Business" },
];
/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export const PropertyRoleDictionary: PropertyRoleDictionaryEntry[] = [
    { role: OSPropertyContactRole.PrimaryResident, icon: 'house-user', label: 'Primary Resident' },
    { role: OSPropertyContactRole.Spouse, icon: 'rings-wedding', label: 'Spouse' },
    { role: OSPropertyContactRole.Child, icon: 'children', label: 'Child' },
    { role: OSPropertyContactRole.Tenant, icon: 'house-user', label: 'Tenant' },
    { role: OSPropertyContactRole.Guest, icon: 'house-user', label: 'Guest' },
    { role: OSPropertyContactRole.Resident, icon: 'house-user', label: 'Resident' },
    { role: OSPropertyContactRole.Friend, icon: 'user-group', label: 'Friend' },
];
/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export const PropertyOwnershipDictionary: PropertyOwnershipDictionaryEntry[] = [
    {type: OSPropertyOwnerType.Company, label: 'Company',  icon: 'suitcase'},
    {type: OSPropertyOwnerType.Private, label: 'Private', icon: 'suitcase'},
    {type: OSPropertyOwnerType.Company, label: 'Trust', icon: 'suitcase'}
];
/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export interface OSPropertyGroup {
    guid: string;
    accessControlIdentifier?: string;
    type: OSPropertyGroupType;
    name: string;
    street?: string;
    geo_position?: string;
}
/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export interface OSPropertyVisits {
    type: string;
    name: string;
    date: string;
    link: string;
}

/**
 * All can be undefined as there can be no contacts on a Property
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export interface OSPropertyOccupant {
    isPrimary?: boolean;
    faceUrl?: string;
    name: string;
    phone?: string;
    email?: string;
    phoneVerified?: boolean;
    emailVerified?: boolean;
}

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export interface OSPropertyOwner {
    type: OSPropertyOwnerType;
    osid?: string;
    name: string;
    since: string;
    link: string;
}
/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export interface OwnershipRecord {
    id: string;
    groupId: string;
    ownerEntityName: string;
    primaryContact?: OSPropertyContact;
    type: OSPropertyOwnerType;
    state: number;
}
/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export interface OSPropertyContact {
    id: string;
    email?: string;
    firstName?: string;
    lastName?: string;
    name: string;
    osid?: string;
    phoneNumber?: string;
    sex?: string;
    resident?: 1 | 0;
    role: OSPropertyContactRole
}
/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export interface ResidencyRecord {
    id: string;
    groupId: string;
    contacts: OSPropertyContact[];
    state: number;
    type: OSPropertyResidencyRecordType;
    typeLabel: string;
}