import { FAIdentifier } from "../fa-icons";

/**
 * This entire class is scuffed
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */

export interface BeSecureAccessMethodDictionary {
    key: BeSecureAccessMethodType,
    label: string,
    icon: FAIdentifier
}

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export const BeSecureAccessMethodTypes: BeSecureAccessMethodDictionary[] = [
    // { key: 5, label: "Face", icon: "face-viewfinder" },
    { key: 5, label: 'Biometric', icon: "universal-access" },
    { key: 3, label: "Bluetooth", icon: "bluetooth" },
    // { key: 5, label: "Fingerprint", icon: "fingerprint" },
    { key: 2, label: "RFID Card", icon: "credit-card-blank" },
    { key: 4, label: "Remote", icon: "traffic-light" },
    { key: 6, label: "Number Plate", icon: "car-rear" },
] as const;

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export interface BeSecureAccessMethod {
    site: string;
    property: string;
    serial?: string;
    owner: string;
    name: string;
    type: BeSecureAccessMethodType;
    state: BeSecureAccessMethodState;
    startDate: string;
    endDate: string;
    expiryDays: number;
    accessRight?: string;
    accessRightName?: string;
}

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export enum BeSecureAccessMethodType {
    Tag = 2,
    Phone = 3,
    Remote = 4,
    Biometric = 5,
    NumberPlate = 6,
    Face = 7,
    Fingerprint = 8
}

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export enum BeSecureAccessMethodState {
    Disabled = 0,
    Enabled = 1,
}

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export function getMethodDictionaryByLabel(label: string) {
    return BeSecureAccessMethodTypes.find(method => method.label === label);
}

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export function getMethodDictionaryByKey(key: BeSecureAccessMethodType) {
    return BeSecureAccessMethodTypes.find(method => method.key === key)
}

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export const StatusLabels: Record<BeSecureAccessMethodState, string> = {
    [BeSecureAccessMethodState.Disabled]: "Disabled",
    [BeSecureAccessMethodState.Enabled]: "Enabled",
};

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export interface BeSecureAccessMethodBarData {
    methods: BeSecureAccessMethod[],
    hasFace: boolean,
    hasFingerprint: boolean
}

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export interface AccessMethodFormData {
    site: string;
    property: string;
    serial?: string;
    owner: string;
    name: string;
    type?: BeSecureAccessMethodType;
    state: BeSecureAccessMethodState;
    startDate?: string;
    endDate?: string;
    expiryDays: number;
    isDecimal?: boolean;
}

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export interface BeSecureAccessDevice {
    PartitionKey: string;
    RowKey: string;
    StartDate: string;
    EndDate: string;
    Name: string;
    DevType: string;
    StaleDays: string;
    State: number;
}

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export interface BeSecureAccessRight {
    guid: string;
    name: string;
}

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
export interface BeSecureProperty {
    unit: string;
    address: string;
}