import React from "react";
import { ListBox, ListBoxProps } from 'primereact/listbox';
import { EntryField } from "../../utils/FormTool/Form";

interface PrimeListBoxProps extends ListBoxProps {
  id: string;
  model?: EntryField | undefined;
  value?: string | null | undefined;
  label?: string | null | undefined;
  hint?: string | null | undefined;
  error?: string | null | undefined;
  required?: boolean | undefined;
}

const PrimeListBox: React.ForwardRefExoticComponent<
PrimeListBoxProps & React.RefAttributes<ListBox>
> = React.forwardRef(
  (
    { id, model, value, label, hint, error, required = false, ...props },
    ref
  ) => {
    const placedValue = model?.value || value || "";
    const placedLabel = model?.label || label || null;
    const placedHint = model?.hint || hint || null;
    const placedError = model?.error || error || null;
    const placedRequired = model?.required || required || false;
    return (
      <div className="flex flex-col gap-2 mb-3">
        {placedLabel && (
          <label
            htmlFor={id}
            title={placedRequired === true ? "Required field" : undefined}
          >
            {placedLabel}
            {placedRequired === true ? (
              <>
                <span className="text-red-500 ml-2">*</span>
              </>
            ) : null}
          </label>
        )}
        <ListBox
          id={id}
          value={placedValue}
          {...props}
          ref={ref}
          invalid={placedError !== null}
          required={placedRequired}
        />
        {placedHint && <small id={`${id}-help`}>{placedHint}</small>}
        {placedError && (
          <small id={`${id}-error`} className="text-red-500">
            {placedError}
          </small>
        )}
      </div>
    );
  }
);

export default PrimeListBox;
