import React from "react";
import { InputTextareaProps } from "primereact/inputtextarea";
import { EntryField } from "../../utils/FormTool/Form";
import { InputTextarea } from "primereact/inputtextarea";

interface PrimeInputTextareaProps extends InputTextareaProps {
  id: string;
  model?: EntryField | undefined;
  value?: string | undefined;
  label?: string | null | undefined;
  hint?: string | null | undefined;
  error?: string | null | undefined;
  required?: boolean | undefined;
}

const PrimeInputTextarea: React.ForwardRefExoticComponent<
  PrimeInputTextareaProps & React.RefAttributes<HTMLTextAreaElement>
> = React.forwardRef(
  (
    { id, model, value, label, hint, error, required = false, ...props },
    ref
  ) => {
    const placedValue = model?.value || value || "";
    const placedLabel = model?.label || label || null;
    const placedHint = model?.hint || hint || null;
    const placedError = model?.error || error || null;
    const placedRequired = model?.required || required || false;
    return (
      <div className="flex flex-col gap-2 mb-3">
        {placedLabel && (
          <label
            htmlFor={id}
            title={placedRequired === true ? "Required field" : undefined}
          >
            {placedLabel}
            {placedRequired === true ? (
              <>
                <span className="text-red-500 ml-2">*</span>
              </>
            ) : null}
          </label>
        )}
        <InputTextarea
          id={id}
          value={placedValue as string}
          ref={ref}
          invalid={placedError !== null}
          required={placedRequired}
          autoResize={props.autoResize || true}
          {...props}
        />
        {placedHint && <small id={`${id}-help`}>{placedHint}</small>}
        {placedError && (
          <small id={`${id}-error`} className="text-red-500">
            {placedError}
          </small>
        )}
      </div>
    );
  }
);

export default PrimeInputTextarea;
