import React from "react";
import { InputNumber, InputNumberProps } from "primereact/inputnumber";
import { EntryField } from "../../utils/FormTool/Form";

interface PrimeInputNumberProps extends InputNumberProps {
  id: string;
  model?: EntryField | undefined;
  value?: number | null | undefined;
  label?: string | null | undefined;
  hint?: string | null | undefined;
  error?: string | null | undefined;
  required?: boolean | undefined;
}

const PrimeInputNumber: React.ForwardRefExoticComponent<
  PrimeInputNumberProps & React.RefAttributes<InputNumber>
> = React.forwardRef(
  (
    { id, model, value, label, hint, error, required = false, ...props },
    ref
  ) => {
    const placedValue = model?.value || value || "";
    const placedLabel = model?.label || label || null;
    const placedHint = model?.hint || hint || null;
    const placedError = model?.error || error || null;
    const placedRequired = model?.required || required || false;
    return (
      <div className="flex flex-col gap-2 mb-3">
        {placedLabel && (
          <label
            htmlFor={id}
            title={placedRequired === true ? "Required field" : undefined}
          >
            {placedLabel}
            {placedRequired === true ? (
              <>
                <span className="text-red-500 ml-2">*</span>
              </>
            ) : null}
          </label>
        )}
        <InputNumber
          id={id}
          value={placedValue as number}
          {...props}
          ref={ref}
          invalid={placedError !== null}
          required={placedRequired}
        />
        {placedHint && <small id={`${id}-help`}>{placedHint}</small>}
        {placedError && (
          <small id={`${id}-error`} className="text-red-500">
            {placedError}
          </small>
        )}
      </div>
    );
  }
);

export default PrimeInputNumber;
