import { router } from "@inertiajs/react";
import { Button, ButtonProps } from "primereact/button";
import React from "react";

interface NavButtonProps extends ButtonProps {
  href: string;
  spacing?: boolean;
}

const BaseNavButton: React.FC<NavButtonProps> = ({
  href,
  type = "button",
  spacing = true,
  ...props
}) => (
  <>
    <Button onClick={() => router.get(href)} {...props} type={type} />
    {spacing ? <>&nbsp;</> : null}
  </>
);

/**
 *  #####                                        ######
 * #     # #####  ######   ##   ##### ######     #     # #    # ##### #####  ####  #    #
 * #       #    # #       #  #    #   #          #     # #    #   #     #   #    # ##   #
 * #       #    # #####  #    #   #   #####      ######  #    #   #     #   #    # # #  #
 * #       #####  #      ######   #   #          #     # #    #   #     #   #    # #  # #
 * #     # #   #  #      #    #   #   #          #     # #    #   #     #   #    # #   ##
 *  #####  #    # ###### #    #   #   ######     ######   ####    #     #    ####  #    #
 */

interface CreateNavButtonProps extends NavButtonProps {}

export const CreateNavButton: React.FC<CreateNavButtonProps> = ({
  href,
  ...props
}) => (
  <BaseNavButton
    href={href}
    label="Create"
    icon="fa-solid fa-plus"
    {...props}
  />
);

/**
 * ######                               ######
 * #     #   ##    ####  #    #         #     # #    # ##### #####  ####  #    #
 * #     #  #  #  #    # #   #          #     # #    #   #     #   #    # ##   #
 * ######  #    # #      ####           ######  #    #   #     #   #    # # #  #
 * #     # ###### #      #  #           #     # #    #   #     #   #    # #  # #
 * #     # #    # #    # #   #          #     # #    #   #     #   #    # #   ##
 * ######  #    #  ####  #    #         ######   ####    #     #    ####  #    #
 */

interface BackNavButtonProps extends NavButtonProps {}

export const BackNavButton: React.FC<BackNavButtonProps> = ({
  href,
  ...props
}) => (
  <BaseNavButton href={href} severity="secondary" label="Back" {...props} />
);

/**
 *  #####                                         ######
 * #     #   ##   #    #  ####  ###### #          #     # #    # ##### #####  ####  #    #
 * #        #  #  ##   # #    # #      #          #     # #    #   #     #   #    # ##   #
 * #       #    # # #  # #      #####  #          ######  #    #   #     #   #    # # #  #
 * #       ###### #  # # #      #      #          #     # #    #   #     #   #    # #  # #
 * #     # #    # #   ## #    # #      #          #     # #    #   #     #   #    # #   ##
 *  #####  #    # #    #  ####  ###### ######     ######   ####    #     #    ####  #    #
 */

interface CancelNavButtonProps extends NavButtonProps {}

export const CancelNavButton: React.FC<CancelNavButtonProps> = ({
  href,
  ...props
}) => (
  <BaseNavButton href={href} severity="secondary" label="Cancel" {...props} />
);
