import React from "react";
import { useState, useEffect } from "react";
import { goGet } from "../../utils/goFetch";
import { OSPropertyGroup } from "../../types/OSProperty/os-property";
import { Skeleton } from "primereact/skeleton";
import OSPropertyCard from "./OSPropertyCard";
import OSLabel from "../OSLabel/OSLabel";
import { ucFirst } from "../../utils/StringHelper";

interface Props {
    user: string;
}

interface UserProperty extends OSPropertyGroup {
    role: string;
}

const OSUserProperties: React.FC<Props> = ({ ...props }) => {

    const [properties, setProperties] = useState<UserProperty[]>();

    useEffect(() => {
        goGet(`/frontend/property/user-properties?user=${props.user}`).then((response) => {
            const responseBody = response as { success: boolean, data: UserProperty[] };
            setProperties(responseBody.data);
        });
    }, []);

    return (
        <div className="flex w-full px-10">
            <div className="grid grid-cols-3 w-full gap-y-5 w-full">
                {properties ?
                    properties.map((property) => {
                        return (
                            <OSPropertyCard
                                key={property.guid}
                                property={property}
                                customField={<>
                                    <OSLabel props={{
                                        label: ucFirst(property.role),
                                        labelFontSize: '1.6rem',
                                        primaryIcon: "person-shelter",
                                        width: 'auto',
                                    }} />
                                </>
                                }
                            />
                        );
                    })
                    : <Skeleton height="10rem" className="mx-2" />
                }
            </div>
        </div>
    );
}

export default OSUserProperties;