import React, { useEffect, useState } from "react"
import OSPropertyCard from "./OSPropertyCard";
import { OSPropertyGroup } from "../../types/OSProperty/os-property";
import { OSUserBasic } from "../../types/OSUser/os-user";
import { goGet } from "../../utils/goFetch";
import { Skeleton } from "primereact/skeleton";
import OSLabel from "../OSLabel/OSLabel";
import OSAvatar from "../OSAvatar/OSAvatar";

interface Props {
    property: string;
}

const OSPropertyPrimaryContact: React.FC<Props> = ({ ...props }) => {

    const [property, setProperty] = useState<OSPropertyGroup>();
    const [primary, setPrimary] = useState<OSUserBasic>();

    useEffect(() => {
        goGet(`/frontend/property/property-primary?property=${props.property}`)
            .then((response) => {
                const responseData = response as { property: OSPropertyGroup, primary: OSUserBasic };
                setPrimary(responseData.primary);
                setProperty(responseData.property);
            })
            .catch((e) => {
                console.error(e);
            })
    }, []);

    return (
        <div className="flex w-full">
            <div className="grid grid-cols-3 w-full gap-y-5 gap-x-5 p-2 w-full">
                <div className="flex col-span-3 lg:col-span-2 xl:col-span-1 justify-center items-center w-full">
                    <div className="grid grid-cols-3 grid-rows-5 gap-y-1 gap-x-5 w-full">
                        <div className="row-span-5 row-start-1 col-span-1 flex items-center justify-center">
                            {primary ?
                                <OSAvatar props={{
                                    imageUrl: primary.faceUrl ?? undefined,
                                    icon: primary.faceUrl === null ? 'user' : undefined,
                                    width: '11rem',
                                    height: '11rem',
                                    dialogHeader: primary.name
                                }} />
                                : <Skeleton height="11rem" width="11rem" shape="circle" />}
                        </div>
                        <div className="flex items-center justify-start col-span-2 row-start-2 overflow-hidden text-ellipsis">
                            {primary ?
                                <OSLabel props={{
                                    label: "Primary Contact",
                                    labelWeight: 500,
                                    labelFontSize: '1.6rem',
                                }} />
                                : <Skeleton height="2rem" />
                            }
                        </div>
                        <div className="flex items-center justify-start col-span-2 row-start-3 overflow-hidden text-ellipsis">
                            {primary ?
                                primary.phoneNumber ?
                                    <OSLabel props={{
                                        label: primary.phoneNumber,
                                        primaryIcon: 'phone',
                                        secondaryIcon: primary.phoneNumberVerified ? 'circle-check' : undefined,
                                        secondaryIconColor: primary.phoneNumberVerified ? 'var(--success-green)' : 'transparent',
                                        secondaryIconTitle: primary.phoneNumberVerified ? 'Phone verified!' : ''
                                    }} />
                                    : <OSLabel props={{
                                        label: `Phone Number Unknown`,
                                        labelColor: 'var(--gray-400)',
                                        labelFontSize: '1.4rem',
                                        primaryIcon: 'phone',
                                        primaryIconColor: 'var(--gray-400)',

                                    }} />
                                : <Skeleton height="2rem" />
                            }
                        </div>
                        <div className="flex items-center justify-start col-span-2  row-start-4 overflow-hidden text-ellipsis">
                            {primary ?
                                primary.email ?
                                    <OSLabel props={{
                                        label: primary.email,
                                        primaryIcon: 'envelope',
                                        secondaryIcon: primary.emailVerified ? 'circle-check' : undefined,
                                        secondaryIconColor: primary.emailVerified ? 'var(--success-green)' : 'transparent',
                                        secondaryIconTitle: primary.emailVerified ? 'Phone verified!' : '',
                                        link: `mailto:${primary.email}`
                                    }} />
                                    : <OSLabel props={{
                                        label: `Email Address Unknown`,
                                        labelColor: 'var(--snipr-orange)',
                                        labelFontSize: '1.3rem',
                                        primaryIcon: 'envelope',
                                    }} />
                                : <Skeleton height="2rem" />
                            }
                        </div>
                    </div>
                </div>
                <div className="flex col-span-3 lg:col-span-2 xl:col-span-1 justify-center items-center w-full">
                    {property ?
                        <OSPropertyCard property={property} />
                        : <Skeleton height="10rem" />
                    }
                </div>
            </div>
        </div>
    );
}

export default OSPropertyPrimaryContact;