import React, { ReactNode } from "react";
import {
    OSPropertyGroup,
    PropertyDictionary,

} from "../../types/OSProperty/os-property";
import OSAvatar from "../OSAvatar/OSAvatar";
import OSLabel from "../OSLabel/OSLabel";
import {ucFirst} from "../../utils/StringHelper";

interface Props {
    property: OSPropertyGroup,
    customField?: ReactNode
}

const OSPropertyCard: React.FC<Props> = ({ ...props }) => {
    return (
        <div className="flex col-span-3 lg:col-span-2 xl:col-span-1 justify-center items-center w-full">
            <div className={`grid grid-cols-3 ${props.customField ? 'grid-rows-7' : 'grid-rows-6'} gap-y-1 gap-x-5 w-full`}>
                <div className={`${props.customField ? 'row-span-7' : 'row-span-6'} row-start-1 col-span-1 flex items-center justify-center`}>
                    <OSAvatar props={{
                        icon: PropertyDictionary.find((entry) => entry.type === props.property.type)?.icon ?? "house",
                        dialogHeader: props.property.name,
                        width: '11rem',
                        height: '11rem',
                        iconSize: '6rem'
                    }} />
                </div>
                <div className="flex items-center justify-start col-span-2 row-start-2 overflow-hidden text-ellipsis">
                    <OSLabel props={{
                        label: props.property.name,
                        primaryIcon: PropertyDictionary.find((entry) => entry.type === props.property.type)?.icon ?? "house",
                        width: 'auto',
                    }} />
                </div>
                <div className="flex items-center justify-start col-span-2 row-start-3 overflow-hidden text-ellipsis">
                    <OSLabel props={{
                        label: props.property.street ?? 'Street Not Set',
                        labelFontSize: '1.3rem',
                        primaryIcon: "road",
                        width: 'auto',
                    }} />
                </div>
                <div className="flex items-center justify-start col-span-2 row-start-4 overflow-hidden text-ellipsis">
                    <OSLabel props={{
                        label: ucFirst(PropertyDictionary.find((entry) => entry.type === props.property.type)?.icon ?? "House"),
                        labelFontSize: '1.3rem',
                        primaryIcon: PropertyDictionary.find((entry) => entry.type === props.property.type)?.icon ?? "house",
                        width: 'auto',
                    }} />
                </div>
                <div className="flex items-center justify-start col-span-2  row-start-5 overflow-hidden text-ellipsis">
                    <OSLabel props={{
                        label: props.property.geo_position ? 'View on Map' : 'GPS Coordinates Not Set',
                        labelFontSize: '1.3rem',
                        labelColor: props.property.geo_position ? 'var(--os-accent)' : 'var(--snipr-orange)',
                        primaryIcon: "map-location",
                        primaryIconColor: props.property.geo_position ? 'var(--os-accent)' : 'var(--snipr-orange)',
                        width: 'auto',
                    }} />
                </div>
                {props.customField &&
                    <div className="flex items-center justify-start col-span-2  row-start-6 overflow-hidden text-ellipsis">
                        {props.customField}
                    </div>
                }
            </div>
        </div>
    );
}

export default OSPropertyCard;