import React from "react";
import OSAvatar from "../OSAvatar/OSAvatar";
import OSLabel from "../OSLabel/OSLabel";
import { OSPropertyProps, OSPropertyGroupType, } from "../../types/OSProperty/os-property";
import { FAIdentifier } from "../../types/fa-icons";

const OSProperty: React.FC<{ props: OSPropertyProps }> = ({ props }) => {

    const propertyTypeIcon = () => {
        switch (props.property.type) {
            case OSPropertyGroupType.House: {
                return "house";
            }
            default: {
                let icon: FAIdentifier = "house";
                return icon;
            };
        }
    }

    return (
        <>
            <div className="grid pt-4 pb-4 pl-4 pr-4">
                {props.primary && <div className="col text-center flex justify-content-left">
                    <div className="flex flex-row gap-2 p-2">
                        <div className="flex">
                            <OSAvatar props={{
                                imageUrl: props.primary.faceUrl !== null ? props.primary.faceUrl : undefined,
                                icon: props.primary.faceUrl === null ? "user" : undefined,
                                dialogHeader: `${props.primary.name}`,
                                width: '12rem',
                                height: '12rem'
                            }} />
                        </div>
                        <div className="flex flex-column justify-content-center gap-2">
                            <OSLabel props={{
                                primaryIcon: "house-user",
                                label: "Primary Contact",
                                labelFontSize: "1.6rem",
                                labelWeight: 500
                            }} />
                            <OSLabel props={{
                                label: props.primary.name,
                                labelFontSize: '1.6rem',
                                labelWeight: 400
                            }} />
                            <OSLabel props={{
                                primaryIcon: "circle-phone",
                                primaryIconTitle: "Phone Number",
                                primaryIconColor: props.primary.phone !== undefined ? 'var(--main-colour)' : 'var(--smokey)',
                                label: props.primary.phone ?? 'Phone unknown',
                                labelWeight: 400,
                                labelFontSize: '1.5rem',
                                labelColor: props.primary.phone !== undefined ? 'var(--main-colour)' : 'var(--smokey)',
                                secondaryIcon: props.primary.phone !== undefined ? props.primary.phoneVerified ? 'circle-check' : undefined : undefined,
                                secondaryIconColor: props.primary.phone !== undefined ? props.primary.phoneVerified ? 'var(--success-green)' : 'var(--danger-red)' : undefined,
                                secondaryIconTitle: props.primary.phone !== undefined ? props.primary.phoneVerified ? 'Email verified!' : 'Email not verified!' : undefined
                            }} />
                            <OSLabel props={{
                                primaryIcon: "circle-envelope",
                                primaryIconTitle: "Email",
                                primaryIconColor: props.primary.email !== undefined ? 'var(--main-colour)' : 'var(--smokey)',
                                label: props.primary.email ?? "Email unknown",
                                link: props.primary.email !== undefined ? `mailto:${props.primary.email}` : undefined,
                                labelWeight: 400,
                                labelFontSize: '1.5rem',
                                labelColor: props.primary.email !== undefined ? 'var(--main-colour)' : 'var(--smokey)',
                            }} />
                        </div>
                    </div>
                </div>}
                <div className="col text-center flex justify-content-center">
                    <div className="flex flex-row gap-2 p-2">
                        <div className="flex">
                            <OSAvatar props={{
                                icon: "house",
                                dialogHeader: `${props.property.name}`,
                                alt: `${props.property.name}`,
                                width: '12rem',
                                height: '12rem'
                            }} />
                        </div>
                        <div className="flex flex-column justify-content-center gap-2">
                            <OSLabel props={{
                                label: props.property.name,
                                labelFontSize: '1.6rem',
                                labelWeight: 400
                            }} />
                            <OSLabel props={{
                                primaryIcon: propertyTypeIcon(),
                                primaryIconTitle: props.property.type,
                                label: props.property.type,
                                labelFontSize: '1.6rem',
                                labelWeight: 400,
                                style: { textTransform: 'capitalize' }
                            }} />

                            <OSLabel props={{
                                primaryIcon: "map-location",
                                label: props.property.geo_position !== undefined ? "View Location" : "Location Unknown",
                                link: props.property.geo_position !== undefined ? props.property.geo_position : undefined,
                                labelFontSize: '1.6rem',
                                labelWeight: 400,
                                style: { textTransform: 'capitalize' }
                            }} />
                        </div>
                    </div>
                </div>
                <div className="col text-center flex align-items-center justify-content-center"></div>
            </div>
        </>
    );
}

export default OSProperty;