import React from "react"
import { OSPropertyContact, PropertyRoleDictionary } from "../../types/OSProperty/os-property"
import OSAvatar from "../OSAvatar/OSAvatar";
import OSLabel from "../OSLabel/OSLabel";

interface Props {
    contact: OSPropertyContact;
}

const OSContactCard: React.FC<Props> = ({ ...props }) => {
    return (<>
        <div className={`grid grid-cols-3 grid-rows-6 gap-x-5 w-full`}>
            <div className="row-span-6 row-start-1 col-span-1 flex items-center justify-center">
                <OSAvatar props={{
                    icon: 'user',
                    width: '11rem',
                    height: '11rem',
                    dialogHeader: props.contact.name
                }} />
            </div>
            <div className="flex items-center justify-start col-span-2 row-start-2 overflow-hidden text-ellipsis w-full">
                <OSLabel props={{
                    label: props.contact.name,
                    labelWeight: 500,
                }} />
            </div>
            <div className="flex items-center justify-start col-span-2 row-start-3 overflow-hidden text-ellipsis">
                { props.contact.phoneNumber ?
                        <OSLabel props={{
                            label: props.contact.phoneNumber,
                            primaryIcon: 'phone',
                        }} />
                        : <OSLabel props={{
                            label: `Phone Number Unknown`,
                            labelColor: 'var(--gray-400)',
                            labelFontSize: '1.4rem',
                            primaryIcon: 'phone',
                            primaryIconColor: 'var(--gray-400)',

                        }} />
                }
            </div>
            <div className="flex items-center justify-start col-span-2 row-start-4 overflow-hidden text-ellipsis">
                {props.contact.email ?
                    <OSLabel props={{
                        label: props.contact.email,
                        primaryIcon: 'envelope',
                        link: `mailto:${props.contact.email}`
                    }} />
                    : <OSLabel props={{
                        label: `Email Address Unknown`,
                        labelColor: 'var(--snipr-orange)',
                        labelFontSize: '1.3rem',
                        primaryIcon: 'envelope',
                    }} />
                }
            </div>
            <div className="flex items-center justify-start col-span-2 row-start-5 overflow-hidden text-ellipsis">
                <OSLabel props={{
                    label: PropertyRoleDictionary.find((entry) => entry.role === props.contact.role)?.label ?? 'Unknown Role',
                    primaryIcon: PropertyRoleDictionary.find((entry) => entry.role === props.contact.role)?.icon,
                }} />
            </div>
        </div>
    </>);
}

export default OSContactCard;