/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */

import React, { useState } from "react";
import OSUserCard from "./OSUserCard";
import OSLabel from "../OSLabel/OSLabel";
import { Skeleton } from "primereact/skeleton";
import { FAIdentifier } from "../../types/fa-icons";
import { useEffect } from "react";
import { goGet } from "../../utils/goFetch";
import { Pet } from "../../types/OSUser/os-pet";
import { Vehicle } from "../../types/OSUser/os-vehicle";

interface Props {
    user: string;
}

interface SharedCommunityProps {
    dataLabel: string;
    link?: string;
}

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
const OSUserCommunity: React.FC<Props> = ({ ...props }) => {

    const [incidents, setIncidents] = useState<SharedCommunityProps>();
    const [petItem, setPetItem] = useState<SharedCommunityProps>();
    const [vehicleItem, setVehicleItem] = useState<SharedCommunityProps>();
    const [bookings, setBookings] = useState<SharedCommunityProps>();
    const [clubs, setClubs] = useState<SharedCommunityProps>();
    const [events, setEvents] = useState<SharedCommunityProps>();

    const [pets, setPets] = useState<Pet[]>();
    const [vehicles, setVehicles] = useState<Vehicle[]>();

    {/** Pet Fetching Start */ }

    useEffect(() => {
        goGet(`/frontend/user/manager-pets?user=${props.user}`)
            .then((response) => {
                const responseData = response as Pet[];
                setPets(responseData);
            })
            .catch((e) => {
                console.error(e as string);
            });
    }, []);

    useEffect(() => {
        if (pets) {
            setPetItem({ dataLabel: pets.length > 0 ? `${pets.length} Registered` : `None` });
        }
    }, [pets]);

    {/** Pet Fetching End */ }

    {/** Vehicle Fetching Start */ }

    useEffect(() => {
        goGet(`/frontend/user/manager-vehicles?user=${props.user}`)
            .then((response) => {
                const responseData = response as Vehicle[];
                setVehicles(responseData);
            })
            .catch((e) => {
                console.error(e as string);
            });
    }, []);

    useEffect(() => {
        if (vehicles) {
            setVehicleItem({ dataLabel: vehicles.length > 0 ? `${vehicles.length} Registered` : `None` });
        }
    }, [vehicles]);

    {/** Vehicle Fetching End */ }

    {/** Incident Fetching Start */ }

    useEffect(() => {
        goGet(`/frontend/user/incidents?user=${props.user}`)
            .then((response) => {
                const responseData = response as { success: boolean, data: SharedCommunityProps }
                setIncidents(responseData.data);
            })
            .catch((error) => {
                console.error(error);
            });
    }, []);

    {/** Incident Fetching End */ }

    {/** Bookings Fetching Start */ }

    useEffect(() => {
        goGet(`/frontend/user/bookings?user=${props.user}`)
            .then((response) => {
                const responseData = response as { success: boolean, data: SharedCommunityProps }
                setBookings(responseData.data);
            })
            .catch((error) => {
                console.error(error);
            });
    }, []);

    {/** Bookings Fetching End */ }

    {/** Clubs Fetching Start */ }

    useEffect(() => {
        goGet(`/frontend/user/clubs?user=${props.user}`)
            .then((response) => {
                const responseData = response as { success: boolean, data: SharedCommunityProps }
                setClubs(responseData.data);
            })
            .catch((error) => {
                console.error(error);
            });
    }, []);

    {/** Clubs Fetching End */ }

    {/** Events Fetching Start */ }

    useEffect(() => {
        goGet(`/frontend/user/events?user=${props.user}`)
            .then((response) => {
                const responseData = response as { success: boolean, data: SharedCommunityProps }
                setEvents(responseData.data);
            })
            .catch((error) => {
                console.error(error);
            });
    }, []);

    {/** Events Fetching End */ }

    const communityItem = (label: string, primaryIcon: FAIdentifier, data?: SharedCommunityProps) => {
        console.log("Community label" + label);
        console.table(data);
        return (<>
            <div className="flex col-span-1 gap-4">
                <div className="flex lg:justify-end xs:justify-center items-center w-full">
                    <OSLabel props={{
                        justify: "right",
                        label: label,
                        primaryIcon: primaryIcon
                    }} />
                </div>
                <div className="flex w-full justify-center items-center col-span-2
                rounded-md p-2 bg-(--background-color) border-1 border-white
                hover:border-1 hover:border-(--os-accent) hover:cursor-pointer"
                    onClick={(e) => {
                        if (data) {
                            if (label !== 'Pets' && label !== '1iD Vehicles') {
                                window.open(data.link, '_blank');
                                e.preventDefault();
                            } else {
                                //showDialog
                            }
                        }
                    }}>
                    {data ?
                        <OSLabel props={{
                            label: data.dataLabel,
                            labelFontSize: '1.3rem',
                            labelWeight: 500,
                            secondaryIcon: label !== 'Pets' && label !== '1iD Vehicles' ?
                                'arrow-up-right-from-square'
                                : 'circle-info',
                            secondaryIconStyle: { fontSize: '1.5rem', margin: '0rem', padding: '0rem' }
                        }} />
                        : <Skeleton height="2rem" />
                    }
                </div>
            </div>
        </>);
    }

    return (
        <div className="flex w-full px-10">
            <div className="grid xl:grid-cols-3 xs:grid-cols-4 gap-y-10 w-full">
                <div className="flex xs:col-span-4 lg:col-span-2 xl:col-span-1 justify-center items-center">
                    <OSUserCard guid={props.user} />
                </div>
                <div className="flex xs:col-span-4 lg:col-span-2 xl:col-span-1 justify-center items-center">
                    <div className="flex justify-center items-center h-full w-full">
                        <div className="grid grid-cols-1 grid-rows-3 gap-4 w-full px-5">
                            {communityItem("Incidents", "triangle-exclamation", incidents)}
                            {communityItem("Pets", "paw", petItem)}
                            {communityItem("1iD Vehicles", "car-garage", vehicleItem)}
                        </div>
                    </div>
                </div>
                <div className="flex xs:col-span-4 lg:col-span-2 xl:col-span-1 justify-center items-center">
                    <div className="flex justify-center items-center h-full w-full">
                        <div className="grid grid-cols-1 grid-rows-3 gap-4 w-full px-5">
                            {communityItem("Bookings", "calendar-day", bookings)}
                            {communityItem("Clubs", "circle-star", clubs)}
                            {communityItem("Events", "calendar-star", events)}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    );
}

export default OSUserCommunity;