/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */

import React, { ReactNode, useEffect, useRef, useState } from "react";
import { OSUserBasic } from "../../types/OSUser/os-user";
import { goGet } from "../../utils/goFetch";
import OSLabel from "../OSLabel/OSLabel";
import OSAvatar from "../OSAvatar/OSAvatar";
import { Skeleton } from "primereact/skeleton";
import { Button } from "primereact/button";
import { MenuItem } from "primereact/menuitem";
import { Menu } from "primereact/menu";
import "../../assets/css/defaults.css";

interface Props {
    /** 1iD / Local 1iD guid. */
    guid: string | number;
    /** Custom information to be displayed under the person information. */
    customField?: ReactNode;
    dropDownOptions?: MenuItem[];
}

/**
 * Displays the person card with full name, phone number, email and avatar.
 * 
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
const OSUserCard: React.FC<Props> = ({ ...props }) => {

    const dropDownRef = useRef<Menu>(null);

    const [user, setUser] = useState<OSUserBasic>();

    useEffect(() => {
        goGet(`/frontend/user/basic?user=${props.guid}`)
            .then((response) => {
                const responseData = response as OSUserBasic;
                setUser(responseData);
            })
            .catch((e) => {
                console.error(e as string);
            });
    }, []);

    return (<>
        <div className={`grid grid-cols-3 ${props.customField ? 'grid-rows-6' : 'grid-rows-5'} gap-x-5 w-full ${user ? 'gap-y-1' : 'gap-y-2'}`}>
            <div className="row-span-6 row-start-1 col-span-1 flex items-center justify-center">
                {user ?
                    <OSAvatar props={{
                        imageUrl: user.faceUrl ?? user.avatarUrl ?? undefined,
                        icon: user.faceUrl === null && user.avatarUrl === null ? 'user' : undefined,
                        width: '11rem',
                        height: '11rem',
                        dialogHeader: user.name
                    }} />
                    : <Skeleton height="11rem" width="11rem" shape="circle" />}
            </div>
            <div className="flex items-center justify-between col-span-2 row-start-2 overflow-hidden text-ellipsis w-full">
                {user ?
                    <>
                        <OSLabel props={{
                            label: user.name,
                            style: {
                                overflow: "hidden",
                                textOverflow: "ellipsis",
                                whiteSpace: "nowrap"
                            },
                            labelWeight: 500,
                            labelFontSize: '1.8rem',
                            labelColor: 'var(--os-accent)'
                        }} />
                        <Menu model={props.dropDownOptions ?? []} popup ref={dropDownRef} id="dropdown_user_options" />
                        {props.dropDownOptions &&
                            <Button className="icon-button"
                                type="button"
                                icon={"fa fa-ellipsis-vertical"}
                                onClick={(event) => dropDownRef.current?.toggle(event)} />
                        }
                    </>
                    : <Skeleton height="2rem" />
                }
            </div>
            <div className="flex items-center justify-start col-span-2 row-start-3 overflow-hidden text-ellipsis">
                {user ?
                    user.phoneNumber ?
                        <OSLabel props={{
                            label: user.phoneNumber,
                            primaryIcon: 'phone',
                            secondaryIcon: user.phoneNumberVerified ? 'circle-check' : undefined,
                            secondaryIconColor: user.phoneNumberVerified ? 'var(--success-green)' : 'transparent',
                            secondaryIconTitle: user.phoneNumberVerified ? 'Phone verified!' : ''
                        }} />
                        : <OSLabel props={{
                            label: `Phone Number Unknown`,
                            labelColor: 'var(--gray-400)',
                            labelFontSize: '1.4rem',
                            primaryIcon: 'phone',
                            primaryIconColor: 'var(--gray-400)',

                        }} />
                    : <Skeleton height="2rem" />
                }
            </div>
            <div className="flex items-center justify-start col-span-2 row-start-4 overflow-hidden text-ellipsis">
                {user ?
                    user.email ?
                        <OSLabel props={{
                            label: user.email,
                            primaryIcon: 'envelope',
                            secondaryIcon: user.emailVerified ? 'circle-check' : undefined,
                            secondaryIconColor: user.emailVerified ? 'var(--success-green)' : 'transparent',
                            secondaryIconTitle: user.emailVerified ? 'Phone verified!' : '',
                            link: `mailto:${user.email}`
                        }} />
                        : <OSLabel props={{
                            label: `Email Address Unknown`,
                            labelColor: 'var(--snipr-orange)',
                            labelFontSize: '1.3rem',
                            primaryIcon: 'envelope',
                        }} />
                    : <Skeleton height="2rem" />
                }
            </div>
            {props.customField &&
                <div className="flex items-center justify-start col-span-2 row-start-5 overflow-hidden text-ellipsis">
                    {user ?
                        props.customField
                        : <Skeleton height="2rem" />
                    }
                </div>
            }
        </div>
    </>);
}

export default OSUserCard;