/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */

import React, { useEffect, useState } from "react";
import OSUserCard from "./OSUserCard";
import OSLabel from "../OSLabel/OSLabel";
import { Message } from "primereact/message";
import { goGet } from "../../utils/goFetch";
import { Skeleton } from "primereact/skeleton";

interface Props {
    user: string;
}

interface LinkedProperty {
    name: string;
    link: string;
    type: string;
}

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
const OSUser: React.FC<Props> = ({ ...props }) => {

    const [occupiedProperties, setOccupiedProperties] = useState<LinkedProperty[]>();
    const [ownedProperties, setOwnedProperties] = useState<LinkedProperty[]>();

    useEffect(() => {
        goGet(`/frontend/property/user-occupied-properties?user=${props.user}`)
            .then((response) => {
                const responseData = response as { occupiedProperties: LinkedProperty[] };
                setOccupiedProperties(responseData.occupiedProperties);
            })
            .catch((error) => {
                console.error(error);
            })
    }, []);

    useEffect(() => {
        goGet(`/frontend/property/user-owned-properties?user=${props.user}`)
            .then((response) => {
                const responseData = response as { ownedProperties: LinkedProperty[] };
                setOwnedProperties(responseData.ownedProperties);
            })
            .catch((error) => {
                console.error(error);
            })
    }, []);

    return (
        <div className="flex w-full">
            <div className="grid xl:grid-cols-3 xs:grid-cols-4 gap-y-10 w-full">
                <div className="flex xs:col-span-4 lg:col-span-2 xl:col-span-1 justify-center items-center">
                    <OSUserCard guid={props.user} />
                </div>
                <div className="flex xs:col-span-4 lg:col-span-2 xl:col-span-1 justify-center items-center">
                    {/** Occupied Properties */}
                    <div className="flex flex-col gap-4 items-center" style={{ minHeight: '5rem' }}>
                        <div className="flex">
                            <OSLabel props={{
                                label: `Occupied Properties`,
                                labelFontSize: '1.5rem',
                                labelWeight: 500,
                                primaryIcon: "person-shelter"
                            }} />
                        </div>
                        <div className="flex flex-col">
                            {occupiedProperties ?
                                occupiedProperties.length > 0 ?
                                    occupiedProperties.map((occupiedProperty) => {
                                        return (
                                            <div className="flex">
                                                <OSLabel props={{
                                                    label: `${occupiedProperty.name}`,
                                                    labelFontSize: '1.3rem',
                                                    primaryIcon: "house",
                                                    secondaryIcon: "arrow-up-right-from-square",
                                                    secondaryIconStyle: { marginLeft: '0.5rem', fontSize: '1.8em', cursor: 'pointer' },
                                                    secondaryIconTitle: `View ${occupiedProperty.name} in Property`,
                                                    secondaryIconLink: occupiedProperty.link,
                                                    style: { justifyContent: 'space-evenly', padding: '0.1rem' }
                                                }} />
                                            </div>
                                        );
                                    })
                                    : <Skeleton height="2rem" />
                                : <Message severity="secondary" text="N/A" className="p-0 m-0" style={{ fontFamily: 'Poppins', fontWeight: 500, }} />
                            }
                        </div>
                    </div>
                </div>
                <div className="flex xs:col-span-4 lg:col-span-2 xl:col-span-1 justify-center items-center">
                    {/** Occupied Properties */}
                    <div className="flex flex-col gap-4 items-center" style={{ minHeight: '5rem' }}>
                        <div className="flex">
                            <OSLabel props={{
                                label: `Owned Properties`,
                                labelFontSize: '1.5rem',
                                labelWeight: 500,
                                primaryIcon: "hands-holding-diamond"
                            }} />
                        </div>
                        <div className="flex flex-col">
                            {ownedProperties ?
                                ownedProperties.length > 0 ?
                                    ownedProperties.map((ownedProperty) => {
                                        return (
                                            <div className="flex">
                                                <OSLabel props={{
                                                    label: `${ownedProperty.name}`,
                                                    labelFontSize: '1.3rem',
                                                    primaryIcon: "house",
                                                    secondaryIcon: "arrow-up-right-from-square",
                                                    secondaryIconStyle: { marginLeft: '0.5rem', fontSize: '1.8em', cursor: 'pointer' },
                                                    secondaryIconTitle: `View ${ownedProperty.name} in Property`,
                                                    secondaryIconLink: ownedProperty.link,
                                                    style: { justifyContent: 'space-evenly', padding: '0.1rem' }
                                                }} />
                                            </div>
                                        );
                                    })
                                    : <Skeleton height="2rem" />
                                : <Message severity="secondary" text="N/A" className="p-0 m-0" style={{ fontFamily: 'Poppins', fontWeight: 500, }} />
                            }
                        </div>
                    </div>
                </div>
            </div>
        </div>
    );
}

export default OSUser;