import { FAIdentifier } from "../../types/fa-icons";
import { Image } from "primereact/image";
import { Divider } from "primereact/divider";
import FAIcon from "../FAIcon";
import OSLabel from "../OSLabel/OSLabel";
import React, { CSSProperties, ReactNode, useEffect, useState } from "react";
import "./css/styles.css";

interface Props {
    open: boolean;
    children?: ReactNode;
    closeable?: boolean;
    header?: ReactNode;
    label: string;
    labelStyle?: CSSProperties;
    customLabel?: ReactNode;
    icon?: FAIdentifier;
    iconStyle?: CSSProperties;
    image?: string;
    imageWidth?: string;
    border?: boolean;
    setOpen?: (isOpen: boolean) => void;
}

const OSDivider: React.FC<Props> = ({ ...props }) => {

    const [open, setOpen] = useState<boolean>(props.open ?? false);

    useEffect(() => {
        // console.log("Changing props.open");
        setOpen(props.open);
    }, [props.open]);

    const handleToggle = (e: React.MouseEvent<HTMLDivElement, MouseEvent>) => {
        // console.log("Toggle!");
        if (props.closeable === undefined || props.closeable === true) {
            console.log(props.closeable);
            const newOpenState = !open;
            setOpen(newOpenState);

            // Notify parent through setOpen callback if provided
            if (props.setOpen) {
                props.setOpen(newOpenState);
            }
        }
        e.preventDefault();
    }

    const getIcon = () => {
        return (
            <>
                <div className="flex items-center h-full gap-3">
                    {props.closeable === undefined || props.closeable === true ?
                        <div className="flex items-center"
                            onClick={(e) => { props.header ? undefined : handleToggle(e) }}
                            style={{ cursor: props.header ? 'pointer' : 'default' }}>
                            <FAIcon identifier={open ? "chevron-down" : "chevron-right"}
                                style={{
                                    lineHeight: 1,
                                    margin: '0rem',
                                    padding: '0.5rem 0.5rem 0.5rem 0rem',
                                    fontSize: '1rem',
                                    fontWeight: 600,
                                    color: open ? 'var(--os-accent)' : 'var(--main-colour)',
                                }}
                            />
                        </div> : (<></>)}
                    <div className={props.closeable === false ? 'p-4 pl-6' : ''}>
                        <OSLabel props={{
                            label: props.label,
                            labelFontSize: props.header ? '1.4rem' : undefined,
                            primaryIcon: props.icon,
                            width: 'auto'
                        }} />
                    </div>
                </div>
            </>
        );
    }

    const getImage = () => {
        return (
            <>
                <div className="flex items-center h-full gap-3">
                    {props.closeable === undefined || props.closeable === true ?
                        <div className="flex items-center"
                            onClick={(e) => { props.header ? undefined : handleToggle(e) }}
                            style={{ cursor: props.header ? 'pointer' : 'default' }}>
                            <FAIcon identifier={open ? "chevron-down" : "chevron-right"}
                                style={{
                                    lineHeight: 1,
                                    margin: '0rem',
                                    padding: '0.5rem 0.5rem 0.5rem 0rem',
                                    fontSize: '1rem',
                                    fontWeight: 600,
                                    color: open ? 'var(--os-accent)' : 'var(--main-colour)',
                                }}
                            />
                        </div> : (<></>)}
                    <div className={`flex gap-3 ${props.closeable === false ? 'pl-6' : ''}`}>
                        <Image src={props.image} width={props.imageWidth ?? "75"} />
                        <OSLabel props={{
                            label: props.label,
                            labelFontSize: props.header ? '1.4rem' : undefined,
                            primaryIcon: props.icon,
                            width: 'auto'
                        }} />

                    </div>
                </div>
            </>
        );
    }

    return (<>
        <div className={`flex flex-col w-full ${props.border ? 'border-1 border-(--cool-grey) rounded-lg' : ''}`}>
            <div className={`flex w-full ${open && props.border ? 'border-b-1 border-(--cool-grey)' : ''}`}
                onClick={(e) => { props.header ? undefined : handleToggle(e) }}
                style={{ cursor: props.header ? 'default' : 'pointer' }}>
                {props.header ? (<>
                    <div className="grid grid-cols-3 select-none w-full">
                        <div
                            onClick={(e) => { props.header ? handleToggle(e) : undefined }}
                            style={{ cursor: props.header ? 'pointer' : 'default', padding: '0rem 0.5rem' }}>
                            {props.customLabel ? props.customLabel : props.icon ? getIcon() : props.image ? getImage() : null}
                        </div>
                        <div className="col-span-1 col-start-2 flex justify-center">
                            {props.header}
                        </div>
                    </div>
                </>) :
                    <Divider className="m-0 w-full select-none" align="left" id="os-divider">
                        <div className="flex w-full justify-center items-center gap-3">
                            {props.icon ? getIcon() : props.image ? getImage() : null}
                        </div>
                    </Divider>}
            </div>
            {props.children && <div className={`transition-height ease-in-out duration-100 ${open ? "h-full opacity-100" : "h-0 opacity-0"}`}>
                <div className={`flex w-full ${open ? '' : 'hidden'}`}>
                    {props.children}
                </div>
            </div>}
        </div>
    </>);
}

export default OSDivider;