import { FAIdentifier } from "../../types/fa-icons";
import React from "react";
import FAIcon from "../FAIcon";
import { Dialog } from "primereact/dialog";
import { useState } from "react";
import { Image } from 'primereact/image';

export interface OSAvatarProps {
    imageUrl?: string;
    icon?: FAIdentifier;
    iconSize?: string;
    dialogHeader: string;
    alt?: string;
    width: string;
    height: string;
    border?: string;
}

const OSAvatar: React.FC<{ props: OSAvatarProps }> = ({ props }) => {

    function getBorderStyle() {
        let borderColor: string = "2px solid";
        return props.border ? `${borderColor} ${props.border}` : props.imageUrl ? `${borderColor} var(--main-colour)` : `${borderColor} var(--smokey-grey)`;
    }

    const [imageDialogVisible, setImageDialogVisible] = useState<boolean>(false);
    const avatarStyle = {
        width: props.width,
        height: props.height,
        borderRadius: '50%',
        border: props.icon !== undefined ? getBorderStyle() : 'none'
    };
    const imageStyle = {
        width: props.width,
        height: props.height,
        borderRadius: '50%',
        border: props.imageUrl !== undefined ? getBorderStyle() : 'none',
        cursor: 'pointer',
        objectFit: 'cover' as 'cover'
    };

    const iconStyle = { fontSize: props.iconSize ?? '5rem', margin: '0rem', padding: '0rem', }

    return (
        <>
            <div className="flex items-center justify-center" style={avatarStyle}>
                {props.imageUrl !== undefined && (
                    <>
                        <Image
                            loading="eager"
                            src={props.imageUrl}
                            imageStyle={imageStyle}
                            onClick={() => { setImageDialogVisible(true); }}
                        />
                        <Dialog
                            header={props.dialogHeader}
                            visible={imageDialogVisible}
                            style={{ width: '50rem' }}
                            onHide={() => { setImageDialogVisible(false) }} >
                            <div className="flex justify-center items-center">
                                <Image
                                    loading="eager"
                                    src={props.imageUrl}
                                    alt={props.alt}
                                    imageStyle={{
                                        width: '30rem',
                                        height: '30rem',
                                        maxHeight: '30rem',
                                        marginBottom: '0.6rem',
                                        objectFit: 'cover' as 'cover',
                                        borderRadius: '5px'
                                    }}
                                />
                            </div>
                        </Dialog>
                    </>)}
                {props.icon !== undefined && (
                    <div title={props.dialogHeader}>
                        <FAIcon identifier={props.icon} style={iconStyle} />
                    </div>
                )}
            </div>
        </>
    );
}

export default OSAvatar;