import React from "react";
import OSDivider from "../OSDivider/OSDivider";
import { TabView, TabPanel } from "primereact/tabview";
import OSNote from "./OSNote";
import OSLabel from "../OSLabel/OSLabel";

interface Props {
    user: string;
    property?: string;
    site: string;
}

const OSHistory: React.FC<Props> = ({ ...props }) => {

    const noteHeader = () => {
        return (
            <OSLabel props={{
                primaryIcon: "notes",
                label: "Notes",
                labelWeight: 500,
                labelFontSize: '1.4rem',
                primaryIconSize: 'lg'
            }} />
        );
    }

    return (<>
        <div className="flex w-full px-5">
            <div className="flex w-full h-auto">
                <OSDivider open={false} icon="rectangle-history" label="History" >
                    <div className="px-10 py-0 w-full">
                        <TabView className="w-full" activeIndex={0}>
                            <TabPanel header={noteHeader()} className="">
                                <div className="flex w-full">
                                    <OSNote user={props.user} site={props.site} />
                                </div>
                            </TabPanel>
                        </TabView>
                    </div>
                </OSDivider>
            </div>
        </div>
    </>);
}

export default OSHistory;