/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */

import React from "react";
import {
    BeSecureAccessMethod,
    BeSecureAccessMethodType,
    BeSecureProperty,
    getMethodDictionaryByKey,
    BeSecureAccessRight
} from "../../../types/BesecureAccessControl/besecure-access-control";
import FAIcon from "../../FAIcon";
import OSLabel from "../../OSLabel/OSLabel";
import { Toast } from "primereact/toast";
import './css/styles.css';
import OSAccessMethodBar from "./OSAccessMethodBar";
import { useEffect, useRef, useState } from "react";
import OSDataTable, { TSColumnTemplate } from "../../OSDataTable/OSDataTable";
import { FilterType } from "../../OSDataTable/FilterType";
import { Chip } from "primereact/chip";
import { FAIdentifier } from "../../../types/fa-icons";
import { goGet, goPost } from "../../../utils/goFetch";
import { Skeleton } from "primereact/skeleton";
import { Yii2ResponseObject } from "../../OSForm/OSForm";
import { OSInputSize, OSInputType } from "../../OSForm/Enums";
import OSEditDeleteDialog from "../../OSEditDeleteDialog/OSEditDeleteDialog";
import OSDivider from "../../OSDivider/OSDivider";

interface OSUserAccessControlProps {
    user: string;
    userName: string;
    besecureSiteKey: string;
    showRights: boolean;
}

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
const OSUserAccessControl: React.FC<OSUserAccessControlProps> = ({ ...props }) => {

    const toast = useRef<Toast>(null);
    const [accessMethods, setAccessMethods] = useState<BeSecureAccessMethod[]>();
    const [hasFace, setHasFace] = useState<boolean>(false);
    const [hasPrints, setHasPrints] = useState<boolean>(false);
    const [methodsLoaded, setMethodsLoaded] = useState<boolean>(false);
    const [accessRights, setAccessRights] = useState<BeSecureAccessRight[]>();
    const [properties, setProperties] = useState<BeSecureProperty[]>();
    const [dataTableColumns, setDataTableColumns] = useState<TSColumnTemplate[]>();
    const [reloaded, setReloaded] = useState<boolean>(true);

    const getMethods = async () => {
        setMethodsLoaded(false);
        setReloaded(false);
        goGet(`/accessControl/access-method/user?user=${props.user}`).then((response) => {
            const responseData = response as { dataProvider: { models: BeSecureAccessMethod[] }, hasFace: boolean, hasFingerprints: boolean };
            console.table(responseData);
            setAccessMethods(responseData.dataProvider.models);
            setHasFace(responseData.hasFace);
            setHasPrints(responseData.hasFingerprints);
        }).then(() => {
            setMethodsLoaded(true);
            setReloaded(true);
        });
    }

    const getAccessRights = async () => {
        goGet('/accessControl/access-right/get-site-access-rights').then((response) => {
            console.table(response);
            const responseData = response as BeSecureAccessRight[];
            setAccessRights(responseData);
        });
    }

    const getProperties = async () => {
        goGet(`/accessControl/access-right/get-user-properties?user=${props.user}`).then((response) => {
            console.table(response);
            const responseData = response as BeSecureProperty[];
            setProperties(responseData);
        });
    }

    const methodTypeChipTemplate = (type: BeSecureAccessMethodType) => {
        // console.log("Type: " + type);
        let icon: FAIdentifier;
        let label: string;
        switch (type) {
            case BeSecureAccessMethodType.Biometric: { icon = "universal-access"; label = "Biometric"; break; };
            case BeSecureAccessMethodType.Phone: { icon = "bluetooth"; label = "Bluetooth"; break; };
            case BeSecureAccessMethodType.Tag: { icon = "credit-card-blank"; label = "RFID Card"; break; };
            case BeSecureAccessMethodType.Remote: { icon = "traffic-light"; label = "Remote"; break; };
            case BeSecureAccessMethodType.NumberPlate: { icon = "car-rear"; label = "ANPR"; break; };
            default: {
                icon = "cloud-question";
                label = "Unknown"
                break;
            };
        }

        return (
            <>
                <Chip
                    icon={() => { return (<FAIcon identifier={icon} style={{ fontSize: '1.2rem', fontWeight: '400' }} />) }}
                    label={label}
                    style={{
                        fontFamily: 'Poppins',
                        fontSize: '1.3rem',
                        fontWeight: '500',
                        padding: '0rem 0.8rem',
                        backgroundColor: 'transparent',
                        color: 'var(--main-colour)',
                        border: '1px solid var(--main-colour)'
                    }}
                />
            </>
        );
    }

    const handleMethodDelete = async (method: BeSecureAccessMethod) => {
        try {
            goPost(`/accessControl/access-method/delete?serial=${method.serial}`).then((response) => {
                const responseData = response as Yii2ResponseObject;
                if (!responseData.success) {
                    //something went wrong
                    toast.current?.show({ detail: `Error: ${responseData.errors[0]}`, summary: `Error deleting ${method.name}`, severity: 'error' });
                } else {
                    toast.current?.show({ detail: `Successfully deleted ${method.name}`, summary: `Success!`, severity: 'success' });
                    getMethods();
                }
            });
        } catch (error) {
            console.table(error);
        }
    }

    const handleMethodUpdate = () => {
        toast.current?.show({ summary: 'Successful Update', detail: 'Access Method Successfully Updated', severity: 'success' });
        getMethods();
    }

    const getUpdateFormHeader = (method: BeSecureAccessMethod) => {
        return (<>
            <OSLabel props={{
                label: `Update ${method.name}`,
                primaryIcon: getMethodDictionaryByKey(method.type)?.icon,
            }} />
        </>);
    }

    const getPropertyFilterOptions = () => {
        return properties?.map((property) => {
            return {
                label: property.address,
                value: property.unit
            };
        });
    }

    useEffect(() => { getMethods(); }, []);
    useEffect(() => { getAccessRights(); }, []);
    useEffect(() => { getProperties(); }, []);

    useEffect(() => {
        if (properties && accessRights) {
            const columns: TSColumnTemplate[] = [
                {
                    field: 'type',
                    header: 'Type',
                    // filter: true,
                    filterType: FilterType.Dropdown,
                    filterDropDownOptions: [
                        { value: "Biometric", label: "Biometric" },
                        { value: "Phone", label: 'Bluetooth' },
                        { value: "Tag", label: 'Tag' },
                        { value: "Vehicle", label: 'Vehicle' },
                        { value: "Codehop", label: 'Codehop' },
                    ],
                    dropDownStatic: true,
                    body: (rowData: any) => {
                        return methodTypeChipTemplate(rowData.type);
                    },
                    style: { width: '10%' }
                },
                {
                    field: 'name',
                    header: 'Name',
                    sortable: true,
                    filter: true,
                    filterType: FilterType.Text,
                    style: { width: '10%' }
                },
                {
                    field: 'state',
                    header: 'State',
                    sortable: true,
                    filter: true,
                    filterType: FilterType.Dropdown,
                    dropDownStatic: true,
                    body: (rowData: any) => {
                        return (<>
                            <Chip
                                icon={() => {
                                    return (<FAIcon identifier={rowData.state == 1 ? 'cloud-check' : 'cloud-xmark'}
                                        style={{ fontSize: '1em', fontWeight: '500' }} />)
                                }}
                                label={rowData.state == 1 ? 'Active' : 'Disabled'}
                                style={{
                                    fontFamily: 'Poppins',
                                    fontSize: '1.3rem',
                                    fontWeight: '500',
                                    padding: '0rem 0.8rem',
                                    backgroundColor: 'transparent',
                                    color: rowData.state == 1 ? 'var(--success-green)' : 'var(--snipr-orange)',
                                    border: `1px solid ${rowData.state == 1 ? 'var(--success-green)' : 'var(--snipr-orange)'}`
                                }} />
                        </>);
                    },
                    filterDropDownOptions: [
                        { value: 1, label: 'Active' },
                        { value: 0, label: 'Disabled' }
                    ],
                },
                {
                    field: 'property',
                    header: 'Property',
                    sortable: true,
                    filter: true,
                    filterType: FilterType.Dropdown,
                    dropDownStatic: true,
                    filterDropDownOptions: getPropertyFilterOptions(),
                },
                {
                    field: 'startDate',
                    header: 'Validity Start',
                    sortable: true,
                },
                {
                    field: 'endDate',
                    header: 'Validity End',
                    sortable: true,
                },
                {
                    field: 'accessRightName',
                    header: 'Access Right',
                },
                {
                    field: 'action',
                    header: 'Action',
                    body: (rowData: BeSecureAccessMethod) => {
                        return (<>
                            <div className="flex gap-1">
                                <OSEditDeleteDialog
                                    deleteMessage={`Are you sure you want to delete ${rowData.name}?`}
                                    onDeleteConfirm={() => handleMethodDelete(rowData)}
                                    model={'BesecureAccessMethod'}
                                    controller={'/accessControl/access-method'}
                                    formHeader={getUpdateFormHeader(rowData)}
                                    onUpdate={handleMethodUpdate}
                                    //Todo: move into shared configuration for reusability, currently copied OSAccessMethodBar
                                    fields={[
                                        {
                                            field: 'state',
                                            label: 'State',
                                            value: rowData.state,
                                            icon: 'cloud-check',
                                            type: OSInputType.Switch,
                                            required: true,
                                            size: OSInputSize.Half
                                        },
                                        {
                                            field: 'name',
                                            label: 'Alias',
                                            value: rowData.name,
                                            icon: 'tag',
                                            type: OSInputType.Text,
                                            required: true,
                                            size: OSInputSize.Full
                                        },
                                        {
                                            field: 'startDate',
                                            label: 'Validity Start',
                                            value: rowData.startDate,
                                            hint: 'The date on which this access method will start granting access.',
                                            icon: 'hourglass-start',
                                            disabledOnUpdate: true,
                                            type: OSInputType.Date,
                                            required: true,
                                            size: OSInputSize.Half
                                        },
                                        {
                                            field: 'endDate',
                                            label: 'Validity End',
                                            value: rowData.endDate ?? undefined,
                                            hint: 'The date on which this access method will no longer grant access.',
                                            icon: 'hourglass-end',
                                            type: OSInputType.Date,
                                            required: true,
                                            size: OSInputSize.Half
                                        },
                                        {
                                            field: 'property',
                                            label: 'Property',
                                            icon: 'house',
                                            value: rowData.property ?? undefined,
                                            disabledOnUpdate: false,
                                            type: OSInputType.Dropdown,
                                            dropDownOptions: properties.map((property) => {
                                                return {
                                                    label: property.address,
                                                    value: property.unit
                                                };
                                            }),
                                            required: true,
                                            size: OSInputSize.Full
                                        },
                                        {
                                            field: 'accessRight',
                                            label: 'Access Right',
                                            icon: 'shield-keyhole',
                                            value: rowData.accessRight ?? undefined,
                                            disabledOnUpdate: false,
                                            type: OSInputType.Dropdown,
                                            dropDownOptions: accessRights.map((accessRight) => {
                                                return {
                                                    label: accessRight.name,
                                                    value: accessRight.guid
                                                };
                                            }),
                                            size: OSInputSize.Full
                                        },

                                        {
                                            field: 'type',
                                            value: rowData.type,
                                            type: OSInputType.Hidden,
                                        },
                                        {
                                            field: 'owner',
                                            value: rowData.owner,
                                            type: OSInputType.Hidden,
                                        },
                                        {
                                            field: 'serial',
                                            value: rowData.serial,
                                            label: 'Serial',
                                            icon: 'barcode-read',
                                            type: rowData.type === BeSecureAccessMethodType.Tag ? OSInputType.Text : OSInputType.Hidden,
                                            disabledOnUpdate: true,
                                        },
                                    ]}
                                />
                            </div>
                        </>);
                    }
                },
            ];
            setDataTableColumns(columns);
        };

    }, [properties, accessRights]);

    const methodHeaderTemplate = () => {
        return (<>
            {accessRights && properties && methodsLoaded ?
                <div className="flex w-full items-center justify-center">
                    <OSAccessMethodBar
                        user={props.user}
                        userName={props.userName}
                        besecureSiteKey={props.besecureSiteKey}
                        properties={properties}
                        accessRights={accessRights}
                        existingMethods={accessMethods}
                        hasFace={hasFace}
                        hasPrints={hasPrints}
                        updateData={getMethods}
                    />
                </div>
                : <div className="p-4 w-full">
                    <Skeleton height="4rem" />
                </div>}
        </>);
    }

    const rightBodyTemplate = () => {
        if (methodsLoaded && accessRights) {
            if (accessRights.length > 0) {
                return accessRights.map((accessRight) => {
                    const accessRightHasMethods = accessMethods?.find((accessMethod) => accessMethod.accessRight === accessRight.guid);
                    if (accessRightHasMethods !== undefined) {
                        return (<>
                            <div className="grid grid-cols-3 w-full">
                                <div className="col-span-1 flex items-center justify-start">
                                    <div className="grid grid-cols-15 w-full">
                                        <div className="col-span-10 col-start-2">
                                            <OSLabel props={{
                                                label: accessRight.name,
                                                labelFontSize: '1.3rem',
                                                primaryIcon: 'shield-keyhole',
                                            }} />
                                        </div>
                                    </div>
                                </div>
                                <div className="col-span-1 col-start-2">
                                    {accessRights && properties && methodsLoaded ?
                                        <OSAccessMethodBar
                                            user={props.user}
                                            userName={props.user}
                                            besecureSiteKey={props.besecureSiteKey}
                                            properties={properties}
                                            accessRights={accessRights}
                                            readonly
                                            existingMethods={accessMethods?.filter((accessMethod) => accessMethod.accessRight === accessRight.guid)}
                                            hasFace={hasFace}
                                            hasPrints={hasPrints}
                                            updateData={getMethods} /> : <Skeleton height="4rem"
                                        />}
                                </div>
                            </div>
                        </>);
                    }
                });
            } else {
                return (<></>);
            }
        } else {
            return (<Skeleton height={"4rem"} />)
        }
    }

    return (<>
        <Toast ref={toast} />
        <div className="flex flex-col px-10 py-5 w-full gap-5">
            <OSDivider
                open={false}
                border
                icon="key"
                header={methodHeaderTemplate()}
                label={`${props.userName}'s Access Methods`}>
                {reloaded && dataTableColumns &&
                    <OSDataTable
                        rowCount={5}
                        columns={dataTableColumns}
                        endpoint={`/accessControl/access-method/user?user=${props.user}&`}
                        model="BesecureAccessMethod"
                        pagination
                        noHeader
                    />}
            </OSDivider>
            {props.showRights &&
                <OSDivider
                    open
                    closeable={false}
                    label={`${props.userName}'s Access Rights`}
                    icon="shield-keyhole"
                    border
                    header={<></>}
                >
                    <div className="p-4 w-full">
                        {rightBodyTemplate()}
                    </div>
                </OSDivider>}
        </div>
    </>);
}

export default OSUserAccessControl;