/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */

import {
    BeSecureAccessMethod,
    BeSecureAccessMethodType,
    BeSecureAccessMethodState,
    BeSecureAccessMethodDictionary,
    BeSecureAccessRight,
    BeSecureProperty
} from "../../../types/BesecureAccessControl/besecure-access-control";
import { Button } from "primereact/button";
import FAIcon from "../../FAIcon";
import React, { useEffect, useRef, useState } from "react";
import { Toast } from "primereact/toast";
import { Badge } from "primereact/badge";
import { Dialog } from "primereact/dialog";
import './css/styles.css';
import OSForm, { Yii2InputTemplate } from "../../OSForm/OSForm";
import { OSInputSize, OSInputType } from "../../OSForm/Enums";
import OSLabel from "../../OSLabel/OSLabel";
import OSActionButton, { OSActionButtonType } from "../../OSActionButton/OSActionButton";


interface OSAccessMethodFormProps {
    methods: BeSecureAccessMethod[];
    methodType: BeSecureAccessMethodDictionary;
    user: string;
    userName: string;
    besecureSiteKey: string;
    iconColour: string;
    count: number;
    accessRights: BeSecureAccessRight[];
    properties: BeSecureProperty[];
    hasPrints: boolean;
    hasFace: boolean;
    updateData: () => void;
}

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
const OSAccessMethodForm: React.FC<OSAccessMethodFormProps> = ({ ...props }) => {

    const [formVisible, setFormVisible] = useState<boolean>(false);
    const [isUpdate, setIsUpdate] = useState<boolean>(false);
    const toast = useRef<Toast>(null);
    const [selectedMethod, setSelectedMethod] = useState<BeSecureAccessMethod>();

    const launchBiometricEnrol = (url: string): boolean => {
        window.open(url, 'popup', 'width=650,height=600,scrollbars=no,resizable=no');
        return false;
    };

    const handleOnClick = (methods: BeSecureAccessMethod[]) => {
        console.log(`Click`);
        console.table(methods);
        console.log(`End Click`);
        switch (true) {
            case methods.length == 0: {
                console.log("Length 0");
                //do create
                break;
            }
            case methods.length == 1: {
                console.log("Length 1");
                //do update
                setSelectedMethod(methods[0]);
                setIsUpdate(true);
                break;
            }
            case methods.length > 1: {
                console.log("Length > 1");
                //direct to table
                break;
            }
        }
        console.log("Setting form visible...");
        setFormVisible(true);
    };

    useEffect(() => {
        console.log(`Setting form ${formVisible}`);
    }, [formVisible]);

    const insertNewField = (array: Yii2InputTemplate[], index: number, newItem: Yii2InputTemplate): Yii2InputTemplate[] => {
        return [...array.slice(0, index), newItem, ...array.slice(index)];
    };

    const getFormHeader = () => {
        const label = () => {
            if (props.methodType.label === "Face" || props.methodType.label === "Fingerprint") {
                return "Biometric";
            } else {
                return props.methodType.label;
            }
        }

        return (<>
            <div className="flex m-2 gap-3">
                <OSLabel props={{
                    label: isUpdate ? `Update ${props.userName}'s ${label()} Method` : `Create ${props.methodType.label} Access Method`,
                    primaryIcon: props.methodType.icon,
                    width: 'auto'
                }} />
                {props.methodType.label === "Fingerprint" && !props.hasPrints &&
                    <OSActionButton props={{
                        primaryIconEnabled: false,
                        type: OSActionButtonType.Primary,
                        label: 'Enrol Fingerprints',
                        secondaryIcon: 'arrow-up-right-from-square',
                        secondaryIconEnabled: true,
                        onClick: () => { launchBiometricEnrol(`user-contract/enrol-fingerprints?site=${props.besecureSiteKey}&user=${props.user}`) }
                    }} />}
            </div>
        </>);
    }

    const getForm = () => {
        let fields: Yii2InputTemplate[] = [
            {
                field: 'state',
                label: 'State',
                value: selectedMethod ? selectedMethod.state : BeSecureAccessMethodState.Enabled,
                icon: 'cloud-check',
                type: OSInputType.Switch,
                required: true,
                size: OSInputSize.Full
            },
            {
                field: 'name',
                label: 'Alias',
                value: selectedMethod ? selectedMethod.name : `${props.userName}'s ${props.methodType.label}`,
                icon: 'tag',
                type: OSInputType.Text,
                required: true,
                size: OSInputSize.Full
            },
            {
                field: 'startDate',
                label: 'Validity Start',
                value: selectedMethod ? selectedMethod.startDate : new Date(),
                hint: 'The date on which this access method will start granting access.',
                icon: 'hourglass-start',
                disabledOnUpdate: true,
                type: OSInputType.Date,
                required: true,
                size: OSInputSize.Half
            },
            {
                field: 'endDate',
                label: 'Validity End',
                value: selectedMethod ? selectedMethod.endDate : undefined,
                hint: 'The date on which this access method will no longer grant access.',
                icon: 'hourglass-end',
                type: OSInputType.Date,
                required: true,
                size: OSInputSize.Half
            },
            {
                field: 'property',
                label: 'Property',
                icon: 'house',
                value: selectedMethod ? selectedMethod.property : undefined,
                disabledOnUpdate: true,
                type: OSInputType.Dropdown,
                dropDownOptions: props.properties.map((property) => {
                    return {
                        label: property.address,
                        value: property.unit
                    };
                }),
                required: true,
                size: OSInputSize.Full
            },
            {
                field: 'accessRight',
                label: 'Access Right',
                icon: 'shield-keyhole',
                value: selectedMethod ? selectedMethod.accessRight : undefined,
                disabledOnUpdate: false,
                type: OSInputType.Dropdown,
                dropDownOptions: props.accessRights.map((accessRight) => {
                    return {
                        label: accessRight.name,
                        value: accessRight.guid
                    };
                }),
                required: true,
                size: OSInputSize.Full
            },
            {
                field: 'type',
                value: props.methodType.key,
                type: OSInputType.Hidden,
            },
            {
                field: 'owner',
                value: props.user,
                type: OSInputType.Hidden,
            },
        ];

        switch (props.methodType.key) {
            case BeSecureAccessMethodType.Tag: {
                fields = insertNewField(fields, 1, {
                    field: 'serial',
                    label: 'Serial Number',
                    value: selectedMethod ? selectedMethod.serial : undefined,
                    disabledOnUpdate: true,
                    icon: 'barcode-read',
                    type: OSInputType.Text,
                    required: true,
                });
                break;
            }
        }

        if (isUpdate && props.methodType.key !== BeSecureAccessMethodType.Tag) {
            fields = insertNewField(fields, 1, {
                field: 'serial',
                value: selectedMethod ? selectedMethod.serial : undefined,
                type: OSInputType.Hidden,
            });
        }

        return (<>
            <OSForm
                model="BesecureAccessMethod"
                controller='/accessControl/access-method'
                fields={fields}
                isUpdate={isUpdate}
                afterSubmit={() => {
                    setSelectedMethod(undefined);
                    toast.current?.show({ severity: 'success', detail: `Successfully ${isUpdate ? 'Updated' : 'Created'} Access Method`, summary: 'Success' })
                    if (props.updateData) {
                        props.updateData();
                    }
                }}
                onCancel={() => {
                    setSelectedMethod(undefined);
                    setFormVisible(false);
                }}
            />
        </>
        );
    }

    const getFaceEnrolled = () => {

        return (<>
            <div className="flex flex-col gap-5">
                <div className="flex h-full">
                    <OSLabel props={{
                        label: 'Face',
                        primaryIcon: 'face-viewfinder',
                    }} />
                </div>
                <div className="flex justify-center h-full">
                    {props.hasFace ? (<>
                        <div className="border-0 border-(--os-accent) rounded-lg">
                        <OSLabel props={{
                        label: 'Face Enrolled',
                        labelFontSize: '1.2rem',
                        primaryIcon: 'circle-check',
                        primaryIconColor: 'var(--os-accent)',
                        primaryIconStyle: {fontWeight: '600'}
                    }} />
                        </div>
                    </>) : (<>No Face Enrolled</>)}
                </div>
            </div>
        </>);
    }

    const getFingerprintEnrolled = () => {
        return (<>
            <div className="flex flex-col gap-5">
                <div className="flex">
                    <OSLabel props={{
                        label: 'Fingerprints',
                        primaryIcon: 'fingerprint',
                    }} />
                </div>
                <div className="flex h-auto">
                    {props.hasPrints ? (<>
                        <div className="width-50 height-50 border-0 border-(--os-accent) rounded-lg p-2">
                            Finger Prints Enrolled
                        </div>
                    </>) : (<>
                        <OSActionButton props={{
                        primaryIconEnabled: false,
                        type: OSActionButtonType.Primary,
                        label: 'Enrol Fingerprints',
                        secondaryIcon: 'arrow-up-right-from-square',
                        secondaryIconEnabled: true,
                        onClick: () => { launchBiometricEnrol(`user-contract/enrol-fingerprints?site=${props.besecureSiteKey}&user=${props.user}`) }
                    }} />
                    </>)}
                </div>
            </div>
        </>);
    }

    return (
        <>
            <Toast ref={toast} />
            <Button
                style={{
                    backgroundColor: 'transparent',
                    border: 'transparent'
                }}
                onClick={() => { handleOnClick(props.methods); }}>
                <FAIcon identifier={props.methodType.icon} style={{ margin: '0rem', fontSize: '2.4rem', color: props.iconColour }}>
                    {props.count > 1 &&
                        <Badge value={props.count} size={"large"} style={{
                            position: 'absolute',
                            top: '-0.5rem',
                            right: '-0.7rem',
                            backgroundColor: 'var(--main-colour)',
                            color: 'white'
                        }} />}
                </FAIcon>
            </Button>
            <Dialog
                className="md:w-3/5 xs:w-9/10 xs:h-full md:h-auto"
                header={getFormHeader}
                onHide={() => { setFormVisible(false); setSelectedMethod(undefined) }}
                visible={formVisible}>
                <div className="flex flex-col overflow-y-auto overflow-x-hidden h-full">
                   {selectedMethod?.type === BeSecureAccessMethodType.Biometric && 
                    <div className="flex gap-20 w-full p-4">
                    {getFaceEnrolled()}
                    {getFingerprintEnrolled()}
                </div>}

                    {getForm()}
                </div>
            </Dialog>
        </>
    );
}

export default OSAccessMethodForm;