/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */

import {
    BeSecureAccessMethod,
    BeSecureAccessMethodTypes,
    BeSecureAccessMethodType,
    BeSecureAccessMethodState,
    BeSecureAccessRight,
    BeSecureProperty
} from "../../../types/BesecureAccessControl/besecure-access-control";
import { Button } from "primereact/button";
import FAIcon from "../../FAIcon";
import React, { useEffect, useRef, useState } from "react";
import { Toast } from "primereact/toast";
import { Skeleton } from "primereact/skeleton";
import { Badge } from "primereact/badge";
import './css/styles.css';
import OSAccessMethodForm from "./OSAccessMethodForm";

interface OSAccessMethodBarProps {
    user: string;
    userName: string;
    besecureSiteKey: string;
    hasPrints: boolean;
    hasFace: boolean;
    system?: "BeSecure" | "OneAccess";
    existingMethods?: BeSecureAccessMethod[];
    createDefaults?: boolean;
    readonly?: boolean;
    accessRights: BeSecureAccessRight[];
    properties: BeSecureProperty[];
    updateData: () => void;
}

/**
 * @deprecated 25/03/25 - moved back to Central - out of scope
 */
const OSAccessMethodBar: React.FC<OSAccessMethodBarProps> = ({ ...props }) => {

    //Todo: Implement when adding new method
    // const [existingMethods, setExistingMethods] = useState<BeSecureAccessMethod[]>(props.existingMethods ?? []);
    const [existingMethods] = useState<BeSecureAccessMethod[]>(props.existingMethods ?? []);

    const [defaultsCreated, setDefaultsCreated] = useState<boolean>(false);
    const toast = useRef<Toast>(null);

    const colourDisabled = 'var(--snipr-orange)';
    const colourActive = 'var(--os-accent)';
    const colourNone = 'var(--cool-grey)';

    const getMethodsByType = (type: BeSecureAccessMethodType): BeSecureAccessMethod[] => {
        return existingMethods.filter(method => method.type === type);
    };

    //Todo: Implement
    // const addNewMethod = (method: BeSecureAccessMethod) => {
    //     setExistingMethods((prevMethods) => [...prevMethods, method]);
    // };

    useEffect(() => {
        if (props.createDefaults) {
            const createDefaults = async () => {
                await new Promise(resolve => setTimeout(resolve, 3000)).then(() => {
                    //Todo: Create defaults logic
                    // addNewMethod(responseMethod);
                    setDefaultsCreated(true);
                });
            }
            createDefaults();
        } else {
            setDefaultsCreated(true);
        }
    }, []);

    const displayInteractiveBar = () => {
        return BeSecureAccessMethodTypes.map((methodType) => {
            const methods = getMethodsByType(methodType.key);
            let count = methods.length;
            let iconColour: string;

            switch (count) {
                case 0: { iconColour = colourNone; break; }
                case 1: {
                    iconColour = methods[0].state === BeSecureAccessMethodState.Enabled ? colourActive : colourDisabled;
                    break;
                }
                default: {
                    let activeCount = 0;
                    methods.map((method) => {
                        if (method.state === BeSecureAccessMethodState.Enabled) {
                            activeCount++;
                        }
                    });
                    iconColour = activeCount > 0 ? colourActive : colourDisabled;
                    break;
                }
            }

            if (methodType.key === BeSecureAccessMethodType.Biometric) {
                if (methodType.label === "Face" && !props.hasFace) {
                    iconColour = colourNone;
                }
                if (methodType.label === "Fingerprint" && !props.hasPrints) {
                    iconColour = colourNone;
                }
            }

            return (<>
                <OSAccessMethodForm
                    besecureSiteKey={props.besecureSiteKey}
                    hasFace={props.hasFace}
                    hasPrints={props.hasPrints}
                    methods={methods}
                    accessRights={props.accessRights}
                    properties={props.properties}
                    user={props.user}
                    userName={props.userName}
                    methodType={methodType}
                    iconColour={iconColour}
                    count={count}
                    updateData={() => {
                        if (props.updateData) { props.updateData(); }
                    }}
                />
            </>);
        })
    }

    const displayReadonlyFields = () => {
        return BeSecureAccessMethodTypes.map((methodType) => {
            const methods = getMethodsByType(methodType.key);
            let count = methods.length;
            let iconColour: string;

            switch (count) {
                case 0: { iconColour = colourNone; break; }
                case 1: {
                    iconColour = methods[0].state === BeSecureAccessMethodState.Enabled ? colourActive : colourDisabled;
                    break;
                }
                default: {
                    let activeCount = 0;
                    methods.map((method) => {
                        if (method.state === BeSecureAccessMethodState.Enabled) {
                            activeCount++;
                        }
                    });
                    iconColour = activeCount > 0 ? colourActive : colourDisabled;
                    break;
                }
            }

            if (methodType.key === BeSecureAccessMethodType.Biometric) {
                if (methodType.label === "Face" && !props.hasFace) { iconColour = 'white'; }
                if (methodType.label === "Fingerprint" && !props.hasPrints) { iconColour = 'white'; }
            }

            return (<>
                <Button
                    style={{
                        backgroundColor: 'transparent',
                        border: 'transparent',
                        visibility: count === 0 ? 'hidden' : 'visible',
                        cursor: props.readonly ? 'default' : 'pointer'
                    }}>
                    <FAIcon identifier={methodType.icon} style={{ margin: '0rem', fontSize: '2.4rem', color: iconColour }}>
                        {count > 1 &&
                            <Badge value={count} size={"large"} style={{
                                position: 'absolute',
                                top: '-0.5rem',
                                right: '-0.7rem',
                                backgroundColor: 'var(--main-colour)',
                                color: 'white'
                            }} />}
                    </FAIcon>
                </Button>
            </>);
        })
    }

    return (<>
        <Toast ref={toast} />
        {!props.readonly ? defaultsCreated ?
            <div className="flex gap-15 p-2">
                {displayInteractiveBar()}
            </div>
            : <div className="flex justify-center items-center w-full">
                <Skeleton height="3rem" className="p-2"/>
            </div>
            : <div className="flex gap-15 justify-center items-center">
                {displayReadonlyFields()}
            </div>}
    </>);
}

export default OSAccessMethodBar;