import React from "react";
import { modelProps, TableComponentProps } from "../types/props";
// import { Table } from "react-bootstrap";
import { RenderCell } from "../helpers/TablerHelpers";

interface AppProps extends TableComponentProps {
  model: modelProps;
}

const DataView: React.FC<AppProps> = ({ model, columns = null }) => {
  const fields = model.fields;
  const labels = model.labels;
  return (
    <>
      {/* <Table striped hover> */}
      <table>
        <tbody>
          {columns === null
            ? Object.keys(fields).map((key) => (
                <tr key={key}>
                  <th scope="col">{labels[key] ?? key}</th>
                  <td>{fields[key]}</td>
                </tr>
              ))
            : Object.keys(columns).map((key) => (
                <tr key={key}>
                  <th scope="col">
                    {columns[key]["label"] ?? labels[key] ?? key}
                  </th>
                  <td>
                    {RenderCell(columns[key]["value"], fields[key], model)}
                  </td>
                </tr>
              ))}
        </tbody>
        {/* </Table> */}
      </table>
    </>
  );
};

export default DataView;
