<?php
$baseConfig = require __DIR__ . '/console.php';
$db = require __DIR__ . '/test_db.php';
return yii\helpers\ArrayHelper::merge(
    $baseConfig,
    [
        'components' => [
            'db' => $db,
            'rabbit' => [
                // Mock Rabbit
                'class' => 'app\tests\mocks\RabbitMock',
            ],
            // 'mailer' => [
            //     'useFileTransport' => true,
            // ],
            // Enable logging for testing
            'log' => [
                'traceLevel' => YII_DEBUG ? 3 : 0,
                'targets'  => [
                    [
                        'class'  => 'yii\log\FileTarget',
                        'levels'  => ['error', 'warning'],
                        'logFile'  => '@logs/error.log'
                    ],
                ],
            ],
        ],
    ]
);
