<?php
$baseConfig = require __DIR__ . '/web.php';
$db = require __DIR__ . '/test_db.php';

return yii\helpers\ArrayHelper::merge(
    $baseConfig,
    [
        'components' => [
            'db' => $db,
            // 'mailer' => [
            //     'useFileTransport' => true,
            // ],
            // Enable logging for testing
            'rabbit' => [
                // Mock Rabbit
                'class' => 'app\tests\mocks\RabbitMock',
            ],
            'log' => [
                'traceLevel' => YII_DEBUG ? 3 : 0,
                'targets'  => [
                    [
                        'class'  => 'yii\log\FileTarget',
                        'levels'  => ['error', 'warning'],
                        'logFile'  => '@logs/error.log'
                    ],
                ],
            ],
        ],
        'params' => [
            'disableServiceAuth' => true,
        ],
    ]
);
