<?php

namespace onespace\tools\rabbit\services\base;

use Interop\Amqp\Impl\AmqpMessage;
use onespace\tools\rabbit\services\interfaces\ServiceInterface;

abstract class BaseRabbitService implements ServiceInterface {

    protected readonly AmqpMessage $message;
    protected readonly string $body;
    protected readonly array $headers;
    protected readonly ?string $routingKey;

    public function __construct(AmqpMessage $message) {
        $this->message = $message;
        $this->body = $message->getBody();
        $this->headers = $message->getHeaders();
        $this->routingKey = $message->getRoutingKey();
    }
}
