<?php

namespace app\tests\mocks;

use Closure;
use Interop\Amqp\AmqpDestination;
use Interop\Amqp\Impl\AmqpTopic;
use Interop\Queue\Destination;

/**
 * @NOTE
 *
 * NOT FULL BUILT UP WITH RETURNS. UPDATE AS NEEDED
 */

class RabbitMock {
    public function getConnection() {
        return new RabbitMqConnectionMock();
    }

    public function init() {
    }

    public function connect() {
    }

    public function loadExistingExchange(string $name) {
    }

    public function declareExchange(string $name, string $type, $flags = [], $arguments = []): ?AmqpTopic {
        return $this->getConnection()->createTopic($name);
    }

    public function loadExistingQueue(string $name) {
    }

    public function declareQueue(string $name, $flags = [], $arguments = []) {
    }

    public function getQueueStatus($queue) {
    }

    public function deleteQueue($queue) {
    }

    public function bind(AmqpDestination $item, AmqpDestination $destination, $routingKey = null, $flags = [], $arguments = []) {
    }

    public function unbind(AmqpDestination $item, AmqpDestination $destination, $routingKey = null, $flags = [], $arguments = []) {
    }

    public function subscribeToMessages($sources, Closure $listener, $flags = []) {
    }

    public function sendMessage(
        Destination $destination,
        string $message,
        $routingKey = null,
        $customHeaders = [],
        $timestamp = null,
        $contentType = 'application/json',
        $persistent = true,
        $priority = null,
        $ttl = null
    ) {
    }

    public function outboxSendMessage(
        string $destinationName,
        string $message,
        $routingKey = null,
        $customHeaders = [],
        $timestamp = null,
        $contentType = 'application/json',
        $persistent = true,
        $priority = null,
        $ttl = null
    ) {
    }

    public function createUser($username, $password, $tags = 'none') {
    }

    public function deleteUser(string $username): bool {
    }

    public function getUser($username) {
    }

    public function setUserPermissions(string $username, string $configure = ".*", string $write = ".*", string $read = ".*"): bool {
        return true;
    }

    public function setUserTopicPermissions(string $username, string $exchange = 'amq.topic', string $write = '.*', string $read = '.*'): bool {
        return true;
    }
}

class RabbitMqConnectionMock {
    public function channel() {
        return new RabbitMqChannelMock();
    }

    public function createTopic($name) {
        return new AmqpTopic($name);
    }

    public function close() {
    }
}

class RabbitMqChannelMock {
    public function queue_declare($queue, $passive, $durable, $exclusive, $auto_delete) {
    }

    public function basic_publish($msg, $exchange, $routing_key) {
        // Simulate publishing a message
        echo "Message published: " . $msg->body . "\n";
    }

    public function close() {
    }
}
