<?php

namespace onespace\tools\rabbit\helpers;

use Yii;

/**
 * This allows the class to clear memory in memory ways. The primary way is to clear logs
 */
trait MemoryHelper {
    /**
     * Flush logs from memory. Set threshold and iterator to run it every so often on
     * a loop, otherwise leave both to null to always flush when called.
     */
    protected function flushLogs(?int $threshold = null, ?int $iterator = null): void {
        if ($threshold === null || $iterator === null || $iterator % $threshold === 0) {
            Yii::getLogger()->flush(true);
        }
    }
}
