<?php

namespace onespace\tools\rabbit\helpers;

/**
 * Enum of different logging levels that are prependable on a log entry.
 */
enum Log {
    case NONE;
    case DEBUG;
    case INFO;
    case WARNING;
    case ERROR;
    case CRITICAL;
    case SUCCESS;

    public function level(): string {
        return match ($this) {
            self::NONE => "",
            self::DEBUG => "[ DEBUG ] ",
            self::INFO => "[ INFO ] ",
            self::WARNING => "[ WARNING ] ",
            self::ERROR => "[ ERROR ] ",
            self::CRITICAL => "[ CRITICAL ] ",
            self::SUCCESS => "[ SUCCESS ] ",
        };
    }

    public function yiiLog(string|array|object $data, string $key): void {
        switch ($this) {
            case self::NONE:
            case self::DEBUG:
                \Yii::debug($data, $key);
                break;
            case self::INFO:
            case self::SUCCESS:
                \Yii::info($data, $key);
                break;
            case self::WARNING:
                \Yii::warning($data, $key);
                break;
            case self::ERROR:
            case self::CRITICAL:
                \Yii::error($data, $key);
                break;
        }
    }
}
