<?php

namespace onespace\tools\rabbit\models;

use Yii;
use yii\helpers\ArrayHelper;

/**
 * This is the model class for table "rabbit_outbox".
 */
class RabbitTransactionErrorLog extends \onespace\tools\rabbit\models\base\RabbitTransactionErrorLog {
    public function behaviors() {
        return ArrayHelper::merge(
            parent::behaviors(),
            [
                # custom behaviors
            ]
        );
    }

    public function rules() {
        return ArrayHelper::merge(
            parent::rules(),
            [
                # custom validation rules
            ]
        );
    }

    public static function logError(
        string $workerClass,
        string $body,
        string $headers,
        string $routingKey,
    ): void {
        $model = new self();
        $model->worker_class = $workerClass;
        $model->message_body = $body;
        $model->message_headers = $headers;
        $model->routing_key = $routingKey;
        $model->date_created = date('Y-m-d H:i:s');

        if (!$model->save()) {
            Yii::error($model->getErrors());
        }
    }
}
