# OneSpace Rabbit Library

Helpers for integrating with the OneSpace RabbitMQ system

## Installation

Install `onespace/rabbit` with composer:

```json
  "require" : {
    ...
    "onespace/rabbit": "dev-master"
    ...
  }
```

Configure component in `config/web.php`:

```php
  'components' => [
    'rabbit' => [
      'class' => \onespace\tools\rabbit\components\Rabbit::class,
      'serverUrl' => getenv('RABBIT_HOST_URL'),
      'serverPort' => getenv('RABBIT_HOST_PORT') ? getenv('RABBIT_HOST_PORT') : 5672,
      'vHost' => getenv('RABBIT_VHOST') ? getenv('RABBIT_VHOST') : '/',
      'username' => getenv('RABBIT_USERNAME'),
      'password' => getenv('RABBIT_PASSWORD'),
    ]
  ]
```
