<?php

namespace onespace\tools\rabbit\migrations;

use yii\db\Migration;

/**
 * Class add_rabbit_outbox_table
 *
 * Either copy and paste into your application or include this path in your config to automatically run these migrations
 */
class m250218_000000_add_rabbit_outbox_table extends Migration {
    /**
     * {@inheritdoc}
     */
    public function safeUp() {
        $this->createTable(
            '{{%rabbit_outbox}}',
            [
                'id' => $this->primaryKey(),
                'exchange' => $this->string(1024)->notNull(),
                'message' => $this->binary()->notNull(),
                'routingKey' => $this->string(1024),
                'headers' => $this->json(),
                'timestamp' => $this->integer(),
                'contentType' => $this->string(125)->notNull()->defaultValue('application/json'),
                'persistent' => $this->boolean()->notNull()->defaultValue(1),
                'priority' => $this->integer(),
                'ttl' => $this->integer(),
            ]
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown() {
        $this->dropTable('{{%rabbit_outbox}}');
    }

    /*
    // Use up()/down() to run migration code without a transaction.
    public function up()
    {

    }

    public function down()
    {
        echo "m231006_132008_add_rabbit_outbox_table cannot be reverted.\n";

        return false;
    }
    */
}
