<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# NO CHECKED-IN PROTOBUF GENCODE
# source: configsync.proto

namespace OS\PB;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 **
 * \@brief Configuration Synchronization with Server
 * \@details When synchronizing a database with the cloud server, the following process is applied:
 *          1. The server sends a SyncBegin with a Synchronization Id and Timeout
 *          2. A gateway receives a SyncBegin, creates the necessary files for the resync
 *          3. The gateway sends a SyncReady to server to indicate its ready to receive
 *          4. The server sends the Config messages required, using the synchronization id provided.  
 *             When using the sync id, config messages will be written to the new database. If no sync id is set, and a sync is in progress, then it is
 *             written to both new and old databases.
 *          5. The server sends a SyncEnd to the gateways to say this is it, which causes each gateway to send a SyncDone after swapping to new database.
 *          Sync's are handled per application and cannot be shared between two applications (eg: OneDevice, OneAccess)
 *
 * Generated from protobuf message <code>OS.PB.ConfigSyncAction</code>
 */
class ConfigSyncAction extends \Google\Protobuf\Internal\Message
{
    /**
     * Required: Suggested 900 seconds / 15 minutes. The provided timeout for this process before sending a SyncFailed event. 
     *
     * Generated from protobuf field <code>uint32 Timeout = 5;</code>
     */
    protected $Timeout = 0;
    /**
     * Optional: Only applicable on SyncBegin: The approximate expected number of configs to be sent to the gateway
     *
     * Generated from protobuf field <code>uint32 TotalExpected = 8;</code>
     */
    protected $TotalExpected = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $Timeout
     *           Required: Suggested 900 seconds / 15 minutes. The provided timeout for this process before sending a SyncFailed event. 
     *     @type int $TotalExpected
     *           Optional: Only applicable on SyncBegin: The approximate expected number of configs to be sent to the gateway
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Configsync::initOnce();
        parent::__construct($data);
    }

    /**
     * Required: Suggested 900 seconds / 15 minutes. The provided timeout for this process before sending a SyncFailed event. 
     *
     * Generated from protobuf field <code>uint32 Timeout = 5;</code>
     * @return int
     */
    public function getTimeout()
    {
        return $this->Timeout;
    }

    /**
     * Required: Suggested 900 seconds / 15 minutes. The provided timeout for this process before sending a SyncFailed event. 
     *
     * Generated from protobuf field <code>uint32 Timeout = 5;</code>
     * @param int $var
     * @return $this
     */
    public function setTimeout($var)
    {
        GPBUtil::checkUint32($var);
        $this->Timeout = $var;

        return $this;
    }

    /**
     * Optional: Only applicable on SyncBegin: The approximate expected number of configs to be sent to the gateway
     *
     * Generated from protobuf field <code>uint32 TotalExpected = 8;</code>
     * @return int
     */
    public function getTotalExpected()
    {
        return $this->TotalExpected;
    }

    /**
     * Optional: Only applicable on SyncBegin: The approximate expected number of configs to be sent to the gateway
     *
     * Generated from protobuf field <code>uint32 TotalExpected = 8;</code>
     * @param int $var
     * @return $this
     */
    public function setTotalExpected($var)
    {
        GPBUtil::checkUint32($var);
        $this->TotalExpected = $var;

        return $this;
    }

}

