<?php
$aliases = require __DIR__ . '/aliases.php';
// $db = require __DIR__ . '/db.php';
$params = require __DIR__ . '/params.php';

/**
 * Returns a unix timestamp to the MS.
 * 
 * @return  int
 */

function timeMs(): int {
    return round(microtime(true) * 1000);
}

return [
    'id' => 'microservice-template',
    // the basePath of the application will be the `microservice-template` directory
    'basePath' => dirname(__DIR__),
    // this is where the application will find all controllers
    'controllerNamespace' => 'app\\controllers',
    'defaultRoute' => 'redirect/index',
    'bootstrap' => ['log'],
    'aliases' => $aliases,
    'params' => $params,
    'components' => [
        'request' => [
            // Set Parser to JsonParser to accept Json in request
            'parsers' => [
                'application/json'  => 'yii\web\JsonParser',
            ],
            // Configure to trust LAN hosts, which prevents issues with reverse proxies
            'trustedHosts' => [
                '10.0.0.0/8',
                '172.16.0.0/12',
                '192.168.0.0/16'
            ],
            'enableCsrfValidation' => false,
            'enableCsrfCookie' => false
        ],
        'response' => [
            'format' => yii\web\Response::FORMAT_JSON,
            'charset' => 'UTF-8',
        ],
        // 'db' => $db,
        'urlManager' => [
            'class' => 'yii\web\UrlManager',
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [
                [
                    'class' => 'yii\rest\UrlRule',
                    'controller' => ['api/v1/url' => 'v1/api'],
                    'patterns' => [
                        '<action>' => '<action>'
                    ]
                ]
            ]
        ],
        // Enable logging for API
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets'  => [
                [
                    'class'  => 'yii\log\FileTarget',
                    'levels'  => ['error', 'warning'],
                    'logFile'  => '@logs/error.log'
                ],
            ],
        ],
        'cache' => [
            'class' => 'yii\caching\FileCache',
        ],
        'onespaceServiceClient' => [
            'class' => \app\components\OneSpaceServiceClient::class,
            'serviceGuid' => getenv('ONESPACE_SERVICE_GUID'),
            'serviceKey' => getenv('ONESPACE_SERVICE_AUTHKEY'),
        ],
        'jwt' => [
            'class' => \bizley\jwt\Jwt::class,
            'signer' => \bizley\jwt\Jwt::RS256,
            /**
             * Key is set on the fly later using the `buildKey` method.
             * It does need to be set in class instantiation however
             * 
             * @see models/User.php:findIdentityByAccessToken()
             */
            'signingKey' => 'not used',
            'verifyingKey' => 'not used',
            'validationConstraints' => [
                new \Lcobucci\JWT\Validation\Constraint\LooseValidAt(
                    new \Lcobucci\Clock\SystemClock(new DateTimeZone('Africa/Johannesburg')),
                    \DateInterval::createFromDateString('30 minute')
                )
            ]
        ],
    ],
];
