# OneSpace Protobuf Microservice

## Examples Of JSON Payloads

### Events

```json
{
  "PacketType": 64,
  "DestinationAddressEx": "a18c4241-c0fa-330d-a748-d9e9845cc5f2",
  "SourceAddressEx": "bb080156-0e1c-33b7-bf4e-8c98536fd91b",
  "SequenceNumber": 7,
  "RedeliveryCounter": 1,
  "TimeStampMs": "1707475961732",
  "Messages": [
    {
      "TimeStampMs": "1707475961733",
      "TimeToLive": "3600",
      "CorrelationId": "4",
      "Event": {
        "WiegandCode": {
          "Code": "25f74175fa",
          "BitCount": 1,
          "ParityFailed": 1
        }
      }
    },
    {
      "TimeStampMs": "1707475961897",
      "TimeToLive": "3600",
      "CorrelationId": "33",
      "Event": {
        "RelayState": {
          "State": 1,
          "DurationMs": 1139
        }
      }
    },
    {
      "TimeStampMs": "1707475961898",
      "TimeToLive": "3600",
      "CorrelationId": "145",
      "Event": {
        "BleAssetTrack": {
          "NewId": [
            104393,
            100368,
            110807
          ],
          "NewMacAddress": [
            "146712681480751",
            "157284043048852",
            "105128336138050"
          ],
          "NewRawData": [
            "a0e73d026861e41b156b1",
            "b52e22bbc4f3e08c683c8",
            "c7af31d0d5dd281a0221a"
          ],
          "NewRssi": [
            -1603,
            -622,
            1138
          ],
          "NewTsMinus": [
            4,
            169,
            369
          ],
          "LostId": [
            4294965534,
            131,
            4294965602
          ],
          "LostRssi": [
            2229,
            1967,
            415
          ],
          "LostTsMinus": [
            365,
            219,
            165
          ],
          "CurrentId": [
            4294728420,
            4294963039,
            9032
          ],
          "CurrentRssi": [
            -2372,
            391,
            -1322
          ]
        }
      }
    },
    {
      "TimeStampMs": "1707475961900",
      "TimeToLive": "3600",
      "CorrelationId": "131",
      "Event": {
        "ConfigUpdateSuccess": []
      }
    },
    {
      "TimeStampMs": "1707475961901",
      "TimeToLive": "3600",
      "CorrelationId": "77",
      "Event": {
        "ConfigUpdateFailed": {
          "ConfigName": [
            "Config Random A",
            "The Rain in Spain"
          ],
          "FailedReasons": [
            "The Rain in Spain",
            "No internet"
          ]
        }
      }
    },
    {
      "TimeStampMs": "1707475961903",
      "TimeToLive": "3600",
      "CorrelationId": "145",
      "Event": {
        "AccessAllowed": {
          "AccessGatewayId": "149",
          "AllowedAccessDevice": {
            "NumberPlate": "NU 254234",
            "AccessUserId": "167548",
            "AccessGroupIds": [
              "214697",
              "381107",
              "708764"
            ],
            "SpecialDaysOfWeekBits": 109864
          },
          "UserEntriesUsed": 3,
          "UserExitsUsed": 3
        }
      }
    },
    {
      "TimeStampMs": "1707475961908",
      "TimeToLive": "3600",
      "CorrelationId": "138",
      "Event": {
        "AccessDeniedDeviceUnknown": {
          "AccessGatewayId": "1273",
          "DeniedAccessDevice": {
            "NumberPlate": "NU 254234",
            "AccessUserId": "150206",
            "AccessGroupIds": [
              "33661",
              "59",
              "459269"
            ],
            "SpecialDaysOfWeekBits": 188605
          }
        }
      }
    },
    {
      "TimeStampMs": "1707475961908",
      "TimeToLive": "3600",
      "CorrelationId": "153",
      "Event": {
        "AccessDeniedDeviceTypeMismatch": {
          "AccessGatewayId": "119",
          "DeniedAccessDevice": {
            "NumberPlate": "NU 254234",
            "AccessUserId": "43977",
            "AccessGroupIds": [
              "310667",
              "327910",
              "364349"
            ],
            "SpecialDaysOfWeekBits": 155094
          },
          "MatchingAccessDevice": {
            "NumberPlate": "NU 254234",
            "AccessUserId": "160906",
            "AccessGroupIds": [
              "157710",
              "317408",
              "98931"
            ],
            "SpecialDaysOfWeekBits": 80949
          }
        }
      }
    },
    {
      "TimeStampMs": "1707475961909",
      "TimeToLive": "3600",
      "CorrelationId": "19",
      "Event": {
        "AccessDeniedDeviceSpecialDaysOfWeek": {
          "AccessGatewayId": "152",
          "DeniedAccessDevice": {
            "WiegandCode": "d8c95b04831a4f44",
            "AccessUserId": "145664",
            "AccessGroupIds": [
              "733688",
              "609565",
              "726654"
            ],
            "SpecialDaysOfWeekBits": 59128
          }
        }
      }
    },
    {
      "TimeStampMs": "1707475961912",
      "TimeToLive": "3600",
      "CorrelationId": "47",
      "Event": {
        "AccessDeniedGroupGateway": {
          "AccessGatewayId": "1030",
          "DeniedAccessDevice": {
            "NumberPlate": "NU 254234",
            "AccessUserId": "36426",
            "AccessGroupIds": [
              "659144",
              "368435",
              "533790"
            ],
            "SpecialDaysOfWeekBits": 217666
          }
        }
      }
    },
    {
      "TimeStampMs": "1707475961916",
      "TimeToLive": "3600",
      "CorrelationId": "4",
      "Event": {
        "AccessDeniedGroupDaysOfWeek": {
          "AccessGatewayId": "1482",
          "DeniedAccessDevice": {
            "NumberPlate": "NU 254234",
            "AccessUserId": "221307",
            "AccessGroupIds": [
              "23488",
              "233655",
              "253189"
            ],
            "SpecialDaysOfWeekBits": 108855
          }
        }
      }
    },
    {
      "TimeStampMs": "1707475961917",
      "TimeToLive": "3600",
      "CorrelationId": "98",
      "Event": {
        "AccessDeniedGroupTimeOfDay": {
          "AccessGatewayId": "968",
          "DeniedAccessDevice": {
            "NumberPlate": "NU 254234",
            "AccessUserId": "194593",
            "AccessGroupIds": [
              "688421",
              "355859",
              "603124"
            ],
            "SpecialDaysOfWeekBits": 106161
          }
        }
      }
    },
    {
      "TimeStampMs": "1707475961919",
      "TimeToLive": "3600",
      "CorrelationId": "78",
      "Event": {
        "AccessDeniedNoEntriesLeft": {
          "AccessGatewayId": "525",
          "DeniedAccessDevice": {
            "NumberPlate": "NU 254234",
            "AccessUserId": "120134",
            "AccessGroupIds": [
              "747425",
              "354749",
              "210825"
            ],
            "SpecialDaysOfWeekBits": 176821
          },
          "DeniedUser": {
            "Id": "12902",
            "FirstExitsThenEnters": 1,
            "RollOverExitToNextDay": 1,
            "EntriesMax": 5,
            "ExitsMax": 5,
            "StartDateTime": "1707475961924",
            "EndDateTime": "1707475961924",
            "AccessGroupIds": [
              21198,
              7059,
              31400
            ]
          },
          "UserEntriesUsed": 3,
          "UserExitsUsed": 3
        }
      }
    },
    {
      "TimeStampMs": "1707475961924",
      "TimeToLive": "3600",
      "CorrelationId": "179",
      "Event": {
        "AccessDeniedNoExitsLeft": {
          "AccessGatewayId": "984",
          "DeniedAccessDevice": {
            "NumberPlate": "NU 254234",
            "AccessUserId": "72227",
            "AccessGroupIds": [
              "341370",
              "690324",
              "296207"
            ],
            "SpecialDaysOfWeekBits": 124400
          },
          "DeniedUser": {
            "Id": "74774",
            "FirstExitsThenEnters": 1,
            "RollOverExitToNextDay": 1,
            "EntriesMax": 5,
            "ExitsMax": 5,
            "StartDateTime": "1707475961925",
            "EndDateTime": "1707475961925",
            "AccessGroupIds": [
              23410,
              12293,
              36935
            ]
          },
          "UserEntriesUsed": 3,
          "UserExitsUsed": 3
        }
      }
    },
    {
      "TimeStampMs": "1707475961926",
      "TimeToLive": "3600",
      "CorrelationId": "46",
      "Event": {
        "SystemRestart": {
          "RestartReason": 4,
          "ActionReceived": {
            "RestartMethod": 2
          }
        }
      }
    }
  ]
}
```

### Actions

```json
{
  "PacketType": 64,
  "DestinationAddressEx": "672ded32-e013-3940-b116-dac07348b91e",
  "SourceAddressEx": "21b41c91-bc9d-3ce3-ad0e-3157c539063b",
  "SequenceNumber": 3,
  "RedeliveryCounter": 1,
  "TimeStampMs": "1707476046306",
  "Messages": [
    {
      "TimeStampMs": "1707476046309",
      "TimeToLive": "3600",
      "CorrelationId": "192",
      "Action": {
        "WiegandLineActivate": {
          "LineOutput": 3,
          "DurationMs": 2283
        }
      }
    },
    {
      "TimeStampMs": "1707476046750",
      "TimeToLive": "3600",
      "CorrelationId": "145",
      "Action": {
        "WiegandLineBlink": {
          "LineOutput": 3,
          "DurationMs": 194,
          "PeriodOnMs": 2997,
          "PeriodOffMs": 968
        }
      }
    },
    {
      "TimeStampMs": "1707476046760",
      "TimeToLive": "3600",
      "CorrelationId": "103",
      "Action": {
        "RelayActivate": {
          "DurationMs": 1919
        }
      }
    },
    {
      "TimeStampMs": "1707476046760",
      "TimeToLive": "3600",
      "CorrelationId": "136",
      "Action": {
        "SystemRestart": {
          "RestartMethod": 2
        }
      }
    }
  ]
}
```

### Config

```json
{
  "PacketType": 64,
  "DestinationAddressEx": "2ac4b708-e445-3a16-abc1-d222c8872bd9",
  "SourceAddressEx": "de74a1c9-704c-3812-b7f6-ac58958ecf49",
  "SequenceNumber": 6,
  "RedeliveryCounter": 3,
  "TimeStampMs": "1707476097194",
  "Messages": [
    {
      "TimeStampMs": "1707476097194",
      "TimeToLive": "3600",
      "CorrelationId": "174",
      "Config": {
        "AccessDeviceUpdate": {
          "NumberPlate": "NU 254234",
          "AccessUserId": "18998",
          "AccessGroupIds": [
            "237019",
            "543853",
            "574378"
          ],
          "SpecialDaysOfWeekBits": 73841
        }
      }
    },
    {
      "TimeStampMs": "1707476097423",
      "TimeToLive": "3600",
      "CorrelationId": "20",
      "Config": {
        "AccessDeviceDelete": {
          "NumberPlate": "NU 254234",
          "AccessUserId": "21810",
          "AccessGroupIds": [
            "56155",
            "225337",
            "654121"
          ],
          "SpecialDaysOfWeekBits": 60553
        }
      }
    },
    {
      "TimeStampMs": "1707476097423",
      "TimeToLive": "3600",
      "CorrelationId": "116",
      "Config": {
        "AccessUserUpdate": {
          "Id": "55716",
          "FirstExitsThenEnters": 1,
          "RollOverExitToNextDay": 1,
          "EntriesMax": 5,
          "ExitsMax": 5,
          "StartDateTime": "1707476097426",
          "EndDateTime": "1707476097426",
          "AccessGroupIds": [
            36244,
            45864,
            43973
          ]
        }
      }
    },
    {
      "TimeStampMs": "1707476097426",
      "TimeToLive": "3600",
      "CorrelationId": "191",
      "Config": {
        "AccessUserDelete": {
          "Id": "52219",
          "FirstExitsThenEnters": 1,
          "RollOverExitToNextDay": 1,
          "EntriesMax": 5,
          "ExitsMax": 5,
          "StartDateTime": "1707476097426",
          "EndDateTime": "1707476097426",
          "AccessGroupIds": [
            15795,
            12923,
            403
          ]
        }
      }
    },
    {
      "TimeStampMs": "1707476097426",
      "TimeToLive": "3600",
      "CorrelationId": "143",
      "Config": {
        "AccessGroupUpdate": {
          "Id": "44253",
          "DaysOfWeekBits": 4,
          "TimesOfDayBits": 9,
          "AccessPeripheralIds": [
            2542,
            5690,
            6436
          ]
        }
      }
    },
    {
      "TimeStampMs": "1707476097426",
      "TimeToLive": "3600",
      "CorrelationId": "160",
      "Config": {
        "AccessGroupDelete": {
          "Id": "12608",
          "DaysOfWeekBits": 6,
          "TimesOfDayBits": 26,
          "AccessPeripheralIds": [
            5755,
            9874,
            7612
          ]
        }
      }
    },
    {
      "TimeStampMs": "1707476097431",
      "TimeToLive": "3600",
      "CorrelationId": "89",
      "Config": {
        "AccessGateway": {
          "AccessDevicesHashModulo": 43,
          "AccessGroupsHashModulo": 5,
          "AccessUsersHashModulo": 3,
          "AccessGatewayId": "475",
          "AccessGatewayDirection": 2,
          "AccessEnabled": 1
        }
      }
    },
    {
      "TimeStampMs": "1707476097432",
      "TimeToLive": "3600",
      "CorrelationId": "34",
      "Config": {
        "AccessDevicesErase": {
          "AreYouSure": 1
        }
      }
    },
    {
      "TimeStampMs": "1707476097432",
      "TimeToLive": "3600",
      "CorrelationId": "117",
      "Config": {
        "AccessUsersErase": {
          "AreYouSure": 1
        }
      }
    },
    {
      "TimeStampMs": "1707476097433",
      "TimeToLive": "3600",
      "CorrelationId": "169",
      "Config": {
        "AccessGroupsErase": {
          "AreYouSure": 1
        }
      }
    },
    {
      "TimeStampMs": "1707476097433",
      "TimeToLive": "3600",
      "CorrelationId": "92",
      "Config": {
        "EventRuleUpdate": {
          "Id": "847",
          "OnEvent": {
            "BleAssetTrack": {
              "NewId": [
                768902,
                203656,
                22303
              ],
              "NewMacAddress": [
                "247016053171761",
                "187979651543331",
                "87985868327101"
              ],
              "NewRawData": [
                "a650bfaf47ec9db3ba724",
                "be20855159f8949b71b7f",
                "c2f73915d9ead04e4b4c3"
              ],
              "NewRssi": [
                -1175,
                -2354,
                2077
              ],
              "NewTsMinus": [
                423,
                134,
                445
              ],
              "LostId": [
                267,
                1476,
                4294965226
              ],
              "LostRssi": [
                2052,
                2360,
                1191
              ],
              "LostTsMinus": [
                202,
                132,
                84
              ],
              "CurrentId": [
                4294767783,
                176109,
                15370
              ],
              "CurrentRssi": [
                2298,
                1652,
                1471
              ]
            }
          },
          "PerformTheseActions": [
            {
              "WiegandLineActivate": {
                "LineOutput": 3,
                "DurationMs": 1180
              }
            },
            {
              "WiegandLineBlink": {
                "LineOutput": 3,
                "DurationMs": 1493,
                "PeriodOnMs": 1079,
                "PeriodOffMs": 1264
              }
            },
            {
              "RelayActivate": {
                "DurationMs": 2330
              }
            },
            {
              "SystemRestart": {
                "RestartMethod": 2
              }
            }
          ],
          "DestinationSerial": 9861,
          "DestinationAddress": [
            "7215423",
            "5259480",
            "7746478"
          ]
        }
      }
    },
    {
      "TimeStampMs": "1707476097452",
      "TimeToLive": "3600",
      "CorrelationId": "58",
      "Config": {
        "EventRuleDelete": {
          "Id": "7888",
          "OnEvent": {
            "BleAssetTrack": {
              "NewId": [
                420740,
                534389,
                708507
              ],
              "NewMacAddress": [
                "175986645633408",
                "194682747087818",
                "243841665093866"
              ],
              "NewRawData": [
                "a931124f0db1ecb14c9d7",
                "b9ca7aa0b73fb2613b937",
                "ce1bdb45d51773e1d4993"
              ],
              "NewRssi": [
                1052,
                1897,
                1630
              ],
              "NewTsMinus": [
                385,
                264,
                253
              ],
              "LostId": [
                47,
                4294965907,
                4294965290
              ],
              "LostRssi": [
                1842,
                579,
                2404
              ],
              "LostTsMinus": [
                6,
                46,
                287
              ],
              "CurrentId": [
                171818,
                78559,
                4294865919
              ],
              "CurrentRssi": [
                663,
                432,
                267
              ]
            }
          },
          "PerformTheseActions": [
            {
              "WiegandLineActivate": {
                "LineOutput": 3,
                "DurationMs": 780
              }
            },
            {
              "WiegandLineBlink": {
                "LineOutput": 3,
                "DurationMs": 2749,
                "PeriodOnMs": 3401,
                "PeriodOffMs": 2099
              }
            },
            {
              "RelayActivate": {
                "DurationMs": 1926
              }
            },
            {
              "SystemRestart": {
                "RestartMethod": 2
              }
            }
          ],
          "DestinationSerial": 8507,
          "DestinationAddress": [
            "3025364",
            "3651239",
            "4994411"
          ]
        }
      }
    },
    {
      "TimeStampMs": "1707476097453",
      "TimeToLive": "3600",
      "CorrelationId": "192",
      "Config": {
        "NetworkAddress": {
          "Address": "1066058376"
        }
      }
    },
    {
      "TimeStampMs": "1707476097455",
      "TimeToLive": "3600",
      "CorrelationId": "186",
      "Config": {
        "NetworkRouteUpdate": {
          "DestinationAddress": "1271531710",
          "DestinationPort": 62344,
          "AddressRoute": [
            "844758451",
            "2445843917",
            "1983200075"
          ]
        }
      }
    },
    {
      "TimeStampMs": "1707476097457",
      "TimeToLive": "3600",
      "CorrelationId": "35",
      "Config": {
        "NetworkRouteDelete": {
          "DestinationAddress": "2093392122",
          "DestinationPort": 18324,
          "AddressRoute": [
            "1811370316",
            "1713336347",
            "811030322"
          ]
        }
      }
    },
    {
      "TimeStampMs": "1707476097457",
      "TimeToLive": "3600",
      "CorrelationId": "107",
      "Config": {
        "BlueToothPort": {
          "BeSecureService": 1
        }
      }
    }
  ]
}
```

### Log

```json
{
  "PacketType": 64,
  "DestinationAddressEx": "61179a12-2377-3733-8f95-2986ffecb2af",
  "SourceAddressEx": "102b6137-cae0-3d03-8b38-cfd62ccf104f",
  "SequenceNumber": 2,
  "RedeliveryCounter": 5,
  "TimeStampMs": "1707476132713",
  "Messages": [
    {
      "TimeStampMs": "1707476132714",
      "TimeToLive": "3600",
      "CorrelationId": "72",
      "Log": {
        "Debug": "Debug: The message has been sent successfully",
        "CoreDumpBin": "3baf24405d1a75a350655a13a4a949ce499aa38d78d11a52ccbdaf9e9ab761f59637a16a23bccda1a7c3bef505c6554ff7f4",
        "CoreDumpLog": "b2879c6a7490dfa9a776283a5889fc5f0647605182742f9ed9d2833efa043d4ad207bee0a70516940a6ef6f450792b86ed3f"
      }
    },
    {
      "TimeStampMs": "1707476132929",
      "TimeToLive": "3600",
      "CorrelationId": "153",
      "Log": {
        "Info": "Log: The message has been sent successfully",
        "CoreDumpBin": "24574cb156a07e3053fb7a705487cf6bb8b0738eec3bd1109b1a707a35ee6d712e6ca3a86b8570bc7889af86463c801ed136",
        "CoreDumpLog": "3074f41b72385e9cb2b5f679e65db14eddfa29e37b29b1224c1c340531c13d53ff4a6a70218f3139543b746ea9f68630caf7"
      }
    },
    {
      "TimeStampMs": "1707476132929",
      "TimeToLive": "3600",
      "CorrelationId": "117",
      "Log": {
        "Warning": "Warning: The message has been sent successfully",
        "CoreDumpBin": "1df799d53128a9ccfa674cebb13155dca069a997620ffccba0e3dc022827e539d247fb6ec89f2c500926831aabe381a3d867",
        "CoreDumpLog": "46766fee1a2b98e6da9ceffa8a9f1f7d861af42c1fe5e2eff06ab163735a788e2100a426691b5ad5475c89d8133dcadb566c"
      }
    },
    {
      "TimeStampMs": "1707476132929",
      "TimeToLive": "3600",
      "CorrelationId": "168",
      "Log": {
        "Error": "Error: The message has been sent successfully",
        "CoreDumpBin": "b6470dcafccd452383ab80544d0331fa6c901b4e22a2de1c346acacdbf9c9e02509495d70d9969aa384eeddf8a55b2d5c6e3",
        "CoreDumpLog": "5f658b7f15fca1192c32e31e712a078f2f3fc57281206768431ff86e9d59e7f73735a3eeedae65b6871c1450a8a1e4cddc08"
      }
    },
    {
      "TimeStampMs": "1707476132929",
      "TimeToLive": "3600",
      "CorrelationId": "179",
      "Log": {
        "Fatal": "Fatal: The message has been sent successfully",
        "CoreDumpBin": "25ba7aea333cfd24ac33b4b70d001b2a14cefbf33c45cd4879910e777894237b8dcb1f1849db04cacd5028845f5f923e4c7e",
        "CoreDumpLog": "0cbdccaae7bb4c551c1956512af077fc6c1f15fe7b7f36380c90057d90374a70e3d75a6e50abdc9ed6f1a3efb7717dd9a950"
      }
    }
  ]
}
```

### Metric

```json
{
  "PacketType": 64,
  "DestinationAddressEx": "2d8b0605-6ce1-35b9-a30a-fe93729719be",
  "SourceAddressEx": "0e7e6ed6-d2ec-398f-bf9e-cf74c06dc221",
  "SequenceNumber": 3,
  "RedeliveryCounter": 2,
  "TimeStampMs": "1707476172066",
  "Messages": [
    {
      "TimeStampMs": "1707476172067",
      "TimeToLive": "3600",
      "CorrelationId": "178",
      "Metric": {
        "Interval": 1490,
        "Log": {
          "InfoLogCount": 517,
          "WarningLogCount": 912,
          "ErrorLogCount": 1642
        },
        "RS485MainPort": {
          "BytesTransmitted": 3449,
          "BytesReceived": 751,
          "BytesReceivedExclusive": 3560,
          "ReceiveOverrunErrors": 4533,
          "ReceiveFramingErrors": 4249,
          "ReceiveBreakErrors": 4970,
          "PacketsTransmitted": 921,
          "PacketsReceived": 2783,
          "PacketsReceivedExclusive": 3831,
          "PacketsACKed": 4395,
          "PacketsNACKedCorrupted": 4732,
          "PacketsCorruptedDiscarded": 3841,
          "PacketsTimedOut": 1296,
          "PacketsDecodingFailed": 443
        },
        "WiegandPort1": {
          "FailedParityChecks": 4827
        },
        "Access": {
          "AccessDeviceLookupTimeMin": 3292,
          "AccessDeviceLookupTimeMax": 4846,
          "AccessUserLookupTimeMin": 813,
          "AccessUserLookupTimeMax": 32,
          "AcesssGroupLookupTimeMin": 935,
          "AccessGroupLookupTimeMax": 4009
        },
        "Network": {
          "LargestQueueMessageCount": 4948,
          "NetworkQueues": [
            {
              "Address": "8920360955164874210",
              "MessageCount": 232,
              "QueueSize": 51,
              "ExpiredMessages": 4430
            }
          ]
        }
      }
    }
  ]
}
```

### Request

```json
{
  "PacketType": 64,
  "DestinationAddressEx": "d9b73acd-8395-369f-94f2-0712fed5d26c",
  "SourceAddressEx": "e9b95de4-3d1e-3191-ac55-d848fa85534b",
  "SequenceNumber": 9,
  "RedeliveryCounter": 3,
  "TimeStampMs": "1707476205784",
  "Messages": [
    {
      "TimeStampMs": "1707476205785",
      "TimeToLive": "3600",
      "CorrelationId": "106",
      "Request": {
        "Method": 4,
        "Json": "{\"cheese\":\"cake\",\"abc\":true,\"def\":21}"
      }
    }
  ]
}
```

### Response

```json
{
  "PacketType": 64,
  "DestinationAddressEx": "171d06cb-8b59-3449-b86d-d8833f0584d3",
  "SourceAddressEx": "e14aab55-4db1-3926-af8c-a54f99973c8b",
  "SequenceNumber": 5,
  "RedeliveryCounter": 5,
  "TimeStampMs": "1707476250078",
  "Messages": [
    {
      "TimeStampMs": "1707476250079",
      "TimeToLive": "3600",
      "CorrelationId": "6",
      "Response": {
        "Code": 413,
        "SystemHardwareInfo": {
          "SerialNumber": 595,
          "BootFirmwareVersion": "3.11.21",
          "AppFirmwareVersion": "3.10.6",
          "HardwarePlatform": "AOH1000-007",
          "HardwareVersion": 4,
          "ManufacturedDate": "1707476250",
          "InternalFileSystemSize": 996,
          "ExternalFileSystemSize": 1241,
          "MCUUID": "2717415941",
          "MCUSocRevision": 1261,
          "MCUPartId": 3451,
          "BLEMAC": "237165089634294",
          "BLECodedPhyPresent": 1,
          "EthernetMAC": "272244221167687",
          "GSMModemManufacturer": "Cheese Inc",
          "GSMModemModel": "EC200U",
          "GSMModemRevision": "EC200UCNAAR01A04M08",
          "GSMModemIMEI": "796a7e06",
          "GSMModemSerialNumber": "3ae36c234c69",
          "GSMSIM1IMSI": "a624b9393c2a864c4945c870e1df070e",
          "GSMSIM1ICCID": "c2f06773b78aef47d65db0771f60cecc236d86bb",
          "GSMSIM1SubscriberNumber": "+27761234567",
          "GSMSIM2IMSI": "b132dc4ad2bb4fcddb82b4b79d2f44c9",
          "GSMSIM2ICCID": "75cf3c5413c38dbf7c7bc31ed3bbd8d986e6d4b1",
          "GSMSIM2SubscriberNumber": "+27767654321"
        }
      }
    }
  ]
}
```

### Dead Letter Message

```json
{
  "PacketType": 64,
  "DestinationAddressEx": "c253c79d-7fe0-3490-9b98-642c066c300e",
  "SourceAddressEx": "3cf5e96b-8569-31b3-ae28-7a5aee02cdb5",
  "SequenceNumber": 3,
  "RedeliveryCounter": 1,
  "TimeStampMs": "1707476274443",
  "Messages": [
    {
      "TimeStampMs": "1707476274444",
      "TimeToLive": "3600",
      "CorrelationId": "83",
      "DeadLetterMessage": "faa48da8156b9c43b086"
    }
  ]
}
```

### Routed Packet

```json
{
  "PacketType": 64,
  "DestinationAddressEx": "0d5ed5db-7fc3-3418-bffd-382966759740",
  "SourceAddressEx": "ab92d86a-d746-381e-96cf-64df17772240",
  "SequenceNumber": 6,
  "RedeliveryCounter": 3,
  "TimeStampMs": "1707476317067",
  "Messages": [
    {
      "TimeStampMs": "1707476317068",
      "TimeToLive": "3600",
      "CorrelationId": "193",
      "RoutedPacket": "08401a2430643565643564622d376663332d333431382d626666642d3338323936363735393734303a2461623932643836612d643734362d333831652d393663662d36346466313737373232343058046002688ce793ecd8317221088ce793ecd83110901c18a80142123210089f8504100418274206d72c9510ac4a"
    }
  ]
}
```

### BeSecure Packet

```json
{
  "PacketType": 64,
  "DestinationAddressEx": "cdbf04db-7889-34b7-94d4-4248b8bfc11d",
  "SourceAddressEx": "d4db9f61-7b0f-32a0-9d8b-a7341e98dbad",
  "SequenceNumber": 3,
  "RedeliveryCounter": 1,
  "TimeStampMs": "1707476356542",
  "Messages": [
    {
      "TimeStampMs": "1707476356542",
      "TimeToLive": "3600",
      "CorrelationId": "81",
      "BeSecurePacket": "02abf82efacc29f159ee"
    }
  ]
}
```

### System Audit Packet

```json
{
  "PacketType": 64,
  "DestinationAddressEx": "ae46e98c-4db5-396e-bbcf-d2d0e38855ca",
  "SourceAddressEx": "44b2627c-3bc5-38f5-88e0-83b48842151a",
  "SequenceNumber": 2,
  "RedeliveryCounter": 4,
  "TimeStampMs": "1707476402783",
  "Messages": [
    {
      "TimeStampMs": "1707476402789",
      "TimeToLive": "3600",
      "CorrelationId": "191",
      "SystemAuditPacket": "a5a78d5e5897a21910c6"
    }
  ]
}
```
