<?php


namespace Unit\models;

use app\models\Wrapper;
use \UnitTester;
use OS\PB\LogMessage;
use OS\PB\Message;
use OS\PB\Packet;

class WrapperTest extends \Codeception\Test\Unit {

    protected UnitTester $tester;

    protected function _before() {
    }

    private function getBasePacket(): string {
        $packet = new Packet([
            "DestinationSerial" => 1234,
            "Messages" => [
                new Message([
                    "TimeStampMs" => round(microtime(true) * 1000),
                    "TimeToLive" => 3600,
                    "Log" => new LogMessage([
                        "Info" => "The message has been sent successfully"
                    ])
                ])
            ]
        ]);

        return $packet->serializeToString();
    }

    // tests
    public function testSettingWrappedMessage() {
        $basePacket = $this->getBasePacket();
        $wrapper = new Wrapper();
        $wrappedMessage = $wrapper->setWrappedMessage($basePacket, 3600, 25);

        $this->assertInstanceOf(Message::class, $wrappedMessage);
        $this->assertEquals($basePacket, $wrappedMessage->getRoutedPacket());
        $this->assertEquals(3600, $wrappedMessage->getTimeToLive());
        $this->assertEquals(25, $wrappedMessage->getCorrelationId());
    }


    public function testUnwrappingMessage() {
        $binary = $this->getBasePacket();
        $wrapper = new Wrapper;

        $wrappedPacket = new Packet([
            "DestinationSerial" => 3456,
            "Messages" => [$wrapper->setWrappedMessage($binary, 3600)],
        ]);
        $wrapped = $wrappedPacket->serializeToString();

        $unwrapped = $wrapper->unwrapMessage($wrapped);
        $this->assertEquals($binary, $unwrapped);
    }
}
