<?php

namespace app\controllers\v1;

use app\controllers\traits\ProtobufSender;
use app\models\Proto;
use app\models\Wrapper;
use Faker\Provider\Uuid;
use OS\PB\AccessAllowedEvent;
use OS\PB\AccessDeniedDeviceSpecialDaysOfWeekEvent;
use OS\PB\AccessDeniedDeviceTypeMismatchEvent;
use OS\PB\AccessDeniedDeviceUnknownEvent;
use OS\PB\AccessDeniedGroupDaysOfWeekEvent;
use OS\PB\AccessDeniedGroupGatewayEvent;
use OS\PB\AccessDeniedGroupTimeOfDayEvent;
use OS\PB\AccessDeniedNoEntriesLeftEvent;
use OS\PB\AccessDeniedNoExitsLeftEvent;
use OS\PB\AccessDevice;
use OS\PB\AccessDevicesEraseConfig;
use OS\PB\AccessDirectionTypes;
use OS\PB\AccessGatewayConfig;
use OS\PB\AccessGroup;
use OS\PB\AccessGroupsEraseConfig;
use OS\PB\AccessMetric;
use OS\PB\AccessUser;
use OS\PB\AccessUsersEraseConfig;
use OS\PB\ActionMessage;
use OS\PB\BleAssetTrackEvent;
use OS\PB\BlueToothPortConfig;
use OS\PB\ConfigMessage;
use OS\PB\ConfigUpdateFailedEvent;
use OS\PB\ConfigUpdateSuccessEvent;
use OS\PB\EventMessage;
use OS\PB\EventRule;
use OS\PB\LogMessage;
use OS\PB\LogMetric;
use OS\PB\Message;
use OS\PB\MetricMessage;
use OS\PB\NetworkAddressConfig;
use OS\PB\NetworkMetric;
use OS\PB\NetworkQueueMetric;
use OS\PB\NetworkRouteConfig;
use OS\PB\Packet;
use OS\PB\Packet\PacketTypes;
use OS\PB\RelayActivateAction;
use OS\PB\RelayStateEvent;
use OS\PB\RelayStateEvent\RelayState;
use OS\PB\RequestMessage;
use OS\PB\RequestMessage\RequestIdTypes;
use OS\PB\RequestMessage\RequestMethodType;
use OS\PB\ResponseMessage;
use OS\PB\ResponseMessage\ResponseCode;
use OS\PB\RS485PortMetric;
use OS\PB\SystemFeaturesResponse;
use OS\PB\SystemHardwareInfoResponse;
use OS\PB\SystemPingResponse;
use OS\PB\SystemRestartAction;
use OS\PB\SystemRestartAction\RestartMethodType;
use OS\PB\SystemRestartEvent;
use OS\PB\SystemRestartEvent\RestartReasonType;
use OS\PB\WiegandCodeEvent;
use OS\PB\WiegandLineActivateAction;
use OS\PB\WiegandLineBlinkAction;
use OS\PB\WiegandLineTypes;
use OS\PB\WiegandPortMetric;
use Yii;
use yii\web\Response;

class DemoController extends BaseController {

    use ProtobufSender;

    public $publicEndpoints = [];

    public function actionDemo() {
        // https://www.yiiframework.com/doc/api/2.0/yii-web-request#getRawBody()-detail
        $body = Yii::$app->request->getRawBody();

        $q = new Packet();
        try {
            $q->mergeFromString($body);
        } catch (\Throwable $th) {
            return $this->asJson(['success' => false, 'error' => $th->getMessage()]);
        }

        $response = [
            'success' => true,
            'sourceSerial' => $q->getSourceSerial(),
            'packetType' => $q->getPacketType(),
            'messages' => json_decode($q->serializeToJsonString(), true)['Messages'] ?? null,
            'Emessages' => json_decode($q->serializeToJsonString(), true)['EncryptedMessages'] ?? null,
        ];

        return $this->asJson($response);
    }


    public function actionTest(): string {
        // Demo for working out EventRuleUpdate
        $packet = new Packet();
        $packet->setDestinationSerial(5);
        $packet->setMessages([
            new Message([
                'Config' => new ConfigMessage([
                    "EventRuleUpdate" => [
                        new EventRule([
                            "Id" => 123,
                            "OnEvent" => new EventMessage([
                                "WiegandCode" => new WiegandCodeEvent([
                                    "Code" => "Test",
                                    "BitCount" => 1,
                                    "SingleKeyBitBurstMode" => true
                                ])
                            ]),
                            "PerformTheseActions" => new ActionMessage([
                                "WiegandLineActivate" => new WiegandLineActivateAction([
                                    "LineOutput" => WiegandLineTypes::Wiegand_LED_Red,
                                    "DurationMs" => 123,
                                ])
                            ]),
                        ])
                    ]
                ])
            ])

        ]);

        echo $packet->serializeToString();
        echo "\n\n";
        echo $packet->serializeToJsonString();
        die;
    }


    private function getBasePacket(): string {
        $packet = new Packet([
            "DestinationSerial" => 1234,
            "Messages" => [
                new Message([
                    "TimeStampMs" => round(microtime(true) * 1000),
                    "TimeToLive" => 3600,
                    "Log" => new LogMessage([
                        "Info" => "The message has been sent successfully"
                    ])
                ])
            ]
        ]);

        return $packet->serializeToString();
    }


    public function actionWrap(): Response {
        $binary = $this->getBasePacket();
        $wrapper = new Wrapper;

        $wrappedPacket = new Packet([
            "DestinationSerial" => 3456,
            "Messages" => [$wrapper->setWrappedMessage($binary, 3600)],
        ]);

        // print_r($binary);
        // echo "\n|---------------------------------------------|\n";
        // print_r($wrappedPacket->serializeToString());

        // die;
    }


    public function actionUnwrap(): Response {
        $binary = $this->getBasePacket();
        $wrapper = new Wrapper;

        $wrappedPacket = new Packet([
            "DestinationSerial" => 3456,
            "Messages" => [$wrapper->setWrappedMessage($binary, 3600)],
        ]);
        $wrapped = $wrappedPacket->serializeToString();

        $unwrapped = $wrapper->unwrapMessage($wrapped);

        print_r($binary);
        echo "\n|---------------------------------------------|\n";
        print_r($wrapped);
        echo "\n|---------------------------------------------|\n";
        print_r($unwrapped);
        echo "\n|---------------------------------------------|\n";
        var_dump($binary == $unwrapped);

        die;
    }


    public function actionStream() {
        $dest = Uuid::uuid();
        $source = Uuid::uuid();

        $randomMac = function () {
            return hexdec(bin2hex((random_bytes(6))));
        };

        $p = new Packet([
            "PacketType" => PacketTypes::PacketType_Response_NACK_Corrupt,
            "DestinationAddressEx" => $dest,
            'SourceAddressEx' => $source,
            'SequenceNumber' => random_int(1, 10),
            'RedeliveryCounter' => random_int(1, 5),
            'TimeStampMs' => timeMs(),
            "Messages" => [

                /**********
                 * Events *
                 **********/

                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Event" => new EventMessage([
                //         "WiegandCode" => new WiegandCodeEvent([
                //             "Code" =>  strval(bin2hex(random_bytes(5))),
                //             "BitCount" => random_int(1, 3),
                //             "ParityFailed" => true,
                //             "SingleKeyBitBurstMode" => false,
                //         ])
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Event" => new EventMessage([
                //         "RelayState" => new RelayStateEvent([
                //             'State' => RelayState::RelayActivated,
                //             'DurationMs' => random_int(500, 2500),
                //         ])
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Event" => new EventMessage([
                //         "BleAssetTrack" => new BleAssetTrackEvent([
                //             "New_id" => [
                //                 random_int(1, 999999),
                //                 random_int(1, 999999),
                //                 random_int(1, 999999),
                //             ],
                //             "New_macAddress" => [
                //                 $randomMac(),
                //                 $randomMac(),
                //                 $randomMac(),
                //             ],
                //             "New_rawData" => [
                //                 'a' . bin2hex(random_bytes(10)),
                //                 'b' . bin2hex(random_bytes(10)),
                //                 'c' . bin2hex(random_bytes(10)),
                //             ],
                //             "New_rssi" => [
                //                 random_int(-2500, 2500),
                //                 random_int(-2500, 2500),
                //                 random_int(-2500, 2500),
                //             ],
                //             "New_tsMinus" => [
                //                 random_int(1, 500),
                //                 random_int(1, 500),
                //                 random_int(1, 500),
                //             ],
                //             "Lost_id" => [
                //                 random_int(-2500, 2500),
                //                 random_int(-2500, 2500),
                //                 random_int(-2500, 2500),
                //             ],
                //             "Lost_rssi" => [
                //                 random_int(1, 2500),
                //                 random_int(1, 2500),
                //                 random_int(1, 2500),
                //             ],
                //             "Lost_tsMinus" => [
                //                 random_int(1, 400),
                //                 random_int(1, 400),
                //                 random_int(1, 400),
                //             ],
                //             "Current_id" => [
                //                 random_int(-250000, 250000),
                //                 random_int(-250000, 250000),
                //                 random_int(-250000, 250000),
                //             ],
                //             "Current_rssi" => [
                //                 random_int(-2500, 2500),
                //                 random_int(-2500, 2500),
                //                 random_int(-2500, 2500),
                //             ]
                //         ])
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Event" => new EventMessage([
                //         "ConfigUpdateSuccess" => new ConfigUpdateSuccessEvent([])
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Event" => new EventMessage([
                //         "ConfigUpdateFailed" => new ConfigUpdateFailedEvent([
                //             "ConfigName" => [
                //                 "Config Random A",
                //                 "The Rain in Spain"
                //             ],
                //             "FailedReasons" => [
                //                 "The Rain in Spain",
                //                 "No internet"
                //             ],
                //         ])
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Event" => new EventMessage([
                //         "AccessAllowed" => new AccessAllowedEvent([
                //             "AccessGatewayId" => random_int(1, 250),
                //             "AllowedAccessDevice" => new AccessDevice([
                //                 "AccessUserId" => random_int(1, 250000),
                //                 "AccessGroupIds" => [
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                 ],
                //                 "SpecialDaysOfWeekBits" => random_int(1, 250000),
                //                 // One of:
                //                 // "WiegandCode" => bin2hex(random_bytes(8)),
                //                 // "RFIDTagUID" => random_int(1, 50),
                //                 // "BTPhoneUID" => random_int(1, 50),
                //                 // "RemoteUID" => random_int(1, 50),
                //                 // "BiometricUID" => random_int(1, 50),
                //                 "NumberPlate" => 'NU 254234',
                //                 // "PinCode" => random_int(1000, 9999),
                //             ]),
                //             "UserEntriesUsed" => 3,
                //             "UserExitsUsed" => 3,
                //         ])
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Event" => new EventMessage([
                //         "AccessDeniedDeviceUnknown" => new AccessDeniedDeviceUnknownEvent([
                //             "AccessGatewayId" => random_int(1, 2000),
                //             "DeniedAccessDevice" => new AccessDevice([
                //                 "AccessUserId" => random_int(1, 250000),
                //                 "AccessGroupIds" => [
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                 ],
                //                 "SpecialDaysOfWeekBits" => random_int(1, 250000),
                //                 // One of:
                //                 // "WiegandCode" => bin2hex(random_bytes(8)),
                //                 // "RFIDTagUID" => random_int(1, 50),
                //                 // "BTPhoneUID" => random_int(1, 50),
                //                 // "RemoteUID" => random_int(1, 50),
                //                 // "BiometricUID" => random_int(1, 50),
                //                 "NumberPlate" => 'NU 254234',
                //                 // "PinCode" => random_int(1000, 9999),
                //             ]),
                //         ])
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Event" => new EventMessage([
                //         "AccessDeniedDeviceTypeMismatch" => new AccessDeniedDeviceTypeMismatchEvent([
                //             "AccessGatewayId" => random_int(1, 2000),
                //             "DeniedAccessDevice" => new AccessDevice([
                //                 "AccessUserId" => random_int(1, 250000),
                //                 "AccessGroupIds" => [
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                 ],
                //                 "SpecialDaysOfWeekBits" => random_int(1, 250000),
                //                 // One of:
                //                 // "WiegandCode" => bin2hex(random_bytes(8)),
                //                 // "RFIDTagUID" => random_int(1, 50),
                //                 // "BTPhoneUID" => random_int(1, 50),
                //                 // "RemoteUID" => random_int(1, 50),
                //                 // "BiometricUID" => random_int(1, 50),
                //                 "NumberPlate" => 'NU 254234',
                //                 // "PinCode" => random_int(1000, 9999),
                //             ]),
                //             "MatchingAccessDevice" => new AccessDevice([
                //                 "AccessUserId" => random_int(1, 250000),
                //                 "AccessGroupIds" => [
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                 ],
                //                 "SpecialDaysOfWeekBits" => random_int(1, 250000),
                //                 // One of:
                //                 // "WiegandCode" => bin2hex(random_bytes(8)),
                //                 // "RFIDTagUID" => random_int(1, 50),
                //                 // "BTPhoneUID" => random_int(1, 50),
                //                 // "RemoteUID" => random_int(1, 50),
                //                 // "BiometricUID" => random_int(1, 50),
                //                 "NumberPlate" => 'NU 254234',
                //                 // "PinCode" => random_int(1000, 9999),
                //             ]),
                //         ])
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Event" => new EventMessage([
                //         "AccessDeniedDeviceSpecialDaysOfWeek" => new AccessDeniedDeviceSpecialDaysOfWeekEvent([
                //             "AccessGatewayId" => random_int(1, 2000),
                //             "DeniedAccessDevice" => new AccessDevice([
                //                 "AccessUserId" => random_int(1, 250000),
                //                 "AccessGroupIds" => [
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                 ],
                //                 "SpecialDaysOfWeekBits" => random_int(1, 250000),
                //                 // One of:
                //                 "WiegandCode" => bin2hex(random_bytes(8)),
                //                 // "RFIDTagUID" => random_int(1, 50),
                //                 // "BTPhoneUID" => random_int(1, 50),
                //                 // "RemoteUID" => random_int(1, 50),
                //                 // "BiometricUID" => random_int(1, 50),
                //                 // "NumberPlate" => 'NU 254234',
                //                 // "PinCode" => random_int(1000, 9999),
                //             ]),
                //         ])
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Event" => new EventMessage([
                //         "AccessDeniedGroupGateway" => new AccessDeniedGroupGatewayEvent([
                //             "AccessGatewayId" => random_int(1, 2000),
                //             "DeniedAccessDevice" => new AccessDevice([
                //                 "AccessUserId" => random_int(1, 250000),
                //                 "AccessGroupIds" => [
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                 ],
                //                 "SpecialDaysOfWeekBits" => random_int(1, 250000),
                //                 // One of:
                //                 // "WiegandCode" => bin2hex(random_bytes(8)),
                //                 // "RFIDTagUID" => random_int(1, 50),
                //                 // "BTPhoneUID" => random_int(1, 50),
                //                 // "RemoteUID" => random_int(1, 50),
                //                 // "BiometricUID" => random_int(1, 50),
                //                 "NumberPlate" => 'NU 254234',
                //                 // "PinCode" => random_int(1000, 9999),
                //             ]),
                //         ])
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Event" => new EventMessage([
                //         "AccessDeniedGroupDaysOfWeek" => new AccessDeniedGroupDaysOfWeekEvent([
                //             "AccessGatewayId" => random_int(1, 2000),
                //             "DeniedAccessDevice" => new AccessDevice([
                //                 "AccessUserId" => random_int(1, 250000),
                //                 "AccessGroupIds" => [
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                 ],
                //                 "SpecialDaysOfWeekBits" => random_int(1, 250000),
                //                 // One of:
                //                 // "WiegandCode" => bin2hex(random_bytes(8)),
                //                 // "RFIDTagUID" => random_int(1, 50),
                //                 // "BTPhoneUID" => random_int(1, 50),
                //                 // "RemoteUID" => random_int(1, 50),
                //                 // "BiometricUID" => random_int(1, 50),
                //                 "NumberPlate" => 'NU 254234',
                //                 // "PinCode" => random_int(1000, 9999),
                //             ]),
                //         ])
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Event" => new EventMessage([
                //         "AccessDeniedGroupTimeOfDay" => new AccessDeniedGroupTimeOfDayEvent([
                //             "AccessGatewayId" => random_int(1, 2000),
                //             "DeniedAccessDevice" => new AccessDevice([
                //                 "AccessUserId" => random_int(1, 250000),
                //                 "AccessGroupIds" => [
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                 ],
                //                 "SpecialDaysOfWeekBits" => random_int(1, 250000),
                //                 // One of:
                //                 // "WiegandCode" => bin2hex(random_bytes(8)),
                //                 // "RFIDTagUID" => random_int(1, 50),
                //                 // "BTPhoneUID" => random_int(1, 50),
                //                 // "RemoteUID" => random_int(1, 50),
                //                 // "BiometricUID" => random_int(1, 50),
                //                 "NumberPlate" => 'NU 254234',
                //                 // "PinCode" => random_int(1000, 9999),
                //             ]),
                //         ])
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Event" => new EventMessage([
                //         "AccessDeniedNoEntriesLeft" => new AccessDeniedNoEntriesLeftEvent([
                //             "AccessGatewayId" => random_int(1, 2000),
                //             "UserEntriesUsed" => 3,
                //             "UserExitsUsed" => 3,
                //             "DeniedAccessDevice" => new AccessDevice([
                //                 "AccessUserId" => random_int(1, 250000),
                //                 "AccessGroupIds" => [
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                 ],
                //                 "SpecialDaysOfWeekBits" => random_int(1, 250000),
                //                 // One of:
                //                 // "WiegandCode" => bin2hex(random_bytes(8)),
                //                 // "RFIDTagUID" => random_int(1, 50),
                //                 // "BTPhoneUID" => random_int(1, 50),
                //                 // "RemoteUID" => random_int(1, 50),
                //                 // "BiometricUID" => random_int(1, 50),
                //                 "NumberPlate" => 'NU 254234',
                //                 // "PinCode" => random_int(1000, 9999),
                //             ]),
                //             "DeniedUser" => new AccessUser([
                //                 "Id" => random_int(1, 99999),
                //                 "FirstExitsThenEnters" => true,
                //                 "RollOverExitToNextDay" => true,
                //                 "EntriesMax" => 5,
                //                 "ExitsMax" => 5,
                //                 "StartDateTime" => timeMs(),
                //                 "EndDateTime" => timeMs(),
                //                 "AccessGroupIds" => [
                //                     random_int(1, 50000),
                //                     random_int(1, 50000),
                //                     random_int(1, 50000),
                //                 ]
                //             ]),
                //         ]),
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Event" => new EventMessage([
                //         "AccessDeniedNoExitsLeft" => new AccessDeniedNoExitsLeftEvent([
                //             "AccessGatewayId" => random_int(1, 2000),
                //             "UserEntriesUsed" => 3,
                //             "UserExitsUsed" => 3,
                //             "DeniedAccessDevice" => new AccessDevice([
                //                 "AccessUserId" => random_int(1, 250000),
                //                 "AccessGroupIds" => [
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                     random_int(1, 750000),
                //                 ],
                //                 "SpecialDaysOfWeekBits" => random_int(1, 250000),
                //                 // One of:
                //                 // "WiegandCode" => bin2hex(random_bytes(8)),
                //                 // "RFIDTagUID" => random_int(1, 50),
                //                 // "BTPhoneUID" => random_int(1, 50),
                //                 // "RemoteUID" => random_int(1, 50),
                //                 // "BiometricUID" => random_int(1, 50),
                //                 "NumberPlate" => 'NU 254234',
                //                 // "PinCode" => random_int(1000, 9999),
                //             ]),
                //             "DeniedUser" => new AccessUser([
                //                 "Id" => random_int(1, 99999),
                //                 "FirstExitsThenEnters" => true,
                //                 "RollOverExitToNextDay" => true,
                //                 "EntriesMax" => 5,
                //                 "ExitsMax" => 5,
                //                 "StartDateTime" => timeMs(),
                //                 "EndDateTime" => timeMs(),
                //                 "AccessGroupIds" => [
                //                     random_int(1, 50000),
                //                     random_int(1, 50000),
                //                     random_int(1, 50000),
                //                 ],
                //             ]),
                //         ]),
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Event" => new EventMessage([
                //         "SystemRestart" => new SystemRestartEvent([
                //             // "RestartReason" => RestartReasonType::RestartReasonNotSet,
                //             // "RestartReason" => RestartReasonType::RestartReasonAction,
                //             // "RestartReason" => RestartReasonType::RestartDFURollback,
                //             // "RestartReason" => RestartReasonType::RestartReasonEthernetDriverUnresponsive,
                //             "RestartReason" => RestartReasonType::RestartReasonModemDriverUnresponsive,
                //             "ActionReceived" => new SystemRestartAction([
                //                 // "RestartMethod" => RestartMethodType::RestartMethodNotSet,
                //                 // "RestartMethod" => RestartMethodType::RestartMethodGraceful,
                //                 "RestartMethod" => RestartMethodType::RestartMethodForceful,
                //             ])
                //         ])
                //     ]),
                // ]),


                /***********
                 * Actions *
                 ***********/

                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Action" => new ActionMessage([
                //         "WiegandLineActivate" => new WiegandLineActivateAction([
                //             // "LineOutput" => WiegandLineTypes::Wiegand_LineNotSet,
                //             // "LineOutput" => WiegandLineTypes::Wiegand_D0,
                //             // "LineOutput" => WiegandLineTypes::Wiegand_D1,
                //             "LineOutput" => WiegandLineTypes::Wiegand_LED_Green,
                //             // "LineOutput" => WiegandLineTypes::Wiegand_LED_Red,
                //             // "LineOutput" => WiegandLineTypes::Wiegand_Buzzer,
                //             "DurationMs" => random_int(500, 2500),
                //         ]),
                //     ])
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Action" => new ActionMessage([
                //         "WiegandLineBlink" => new WiegandLineBlinkAction([
                //             // "LineOutput" => WiegandLineTypes::Wiegand_LineNotSet,
                //             // "LineOutput" => WiegandLineTypes::Wiegand_D0,
                //             // "LineOutput" => WiegandLineTypes::Wiegand_D1,
                //             "LineOutput" => WiegandLineTypes::Wiegand_LED_Green,
                //             // "LineOutput" => WiegandLineTypes::Wiegand_LED_Red,
                //             // "LineOutput" => WiegandLineTypes::Wiegand_Buzzer,
                //             "DurationMs" => random_int(100, 3500),
                //             "PeriodOnMs" => random_int(100, 3500),
                //             "PeriodOffMs" => random_int(100, 3500),
                //         ]),
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Action" => new ActionMessage([
                //         "RelayActivate" => new RelayActivateAction([
                //             "DurationMs" => random_int(100, 3500),
                //         ]),
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Action" => new ActionMessage([
                //         "SystemRestart" => new SystemRestartAction([
                //             // "RestartMethod" => RestartMethodType::RestartMethodNotSet,
                //             // "RestartMethod" => RestartMethodType::RestartMethodGraceful,
                //             "RestartMethod" => RestartMethodType::RestartMethodForceful,
                //         ]),
                //     ]),
                // ]),


                /**********
                 * CONFIG *
                 **********/

                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Config" => new ConfigMessage([
                //         "AccessDeviceUpdate" => new AccessDevice([
                //             "AccessUserId" => random_int(1, 250000),
                //             "AccessGroupIds" => [
                //                 random_int(1, 750000),
                //                 random_int(1, 750000),
                //                 random_int(1, 750000),
                //             ],
                //             "SpecialDaysOfWeekBits" => random_int(1, 250000),
                //             // One of:
                //             // "WiegandCode" => bin2hex(random_bytes(8)),
                //             // "RFIDTagUID" => random_int(1, 50),
                //             // "BTPhoneUID" => random_int(1, 50),
                //             // "RemoteUID" => random_int(1, 50),
                //             // "BiometricUID" => random_int(1, 50),
                //             "NumberPlate" => 'NU 254234',
                //             // "PinCode" => random_int(1000, 9999),
                //         ])
                //     ])
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Config" => new ConfigMessage([
                //         "AccessDeviceDelete" => new AccessDevice([
                //             "AccessUserId" => random_int(1, 250000),
                //             "AccessGroupIds" => [
                //                 random_int(1, 750000),
                //                 random_int(1, 750000),
                //                 random_int(1, 750000),
                //             ],
                //             "SpecialDaysOfWeekBits" => random_int(1, 250000),
                //             // One of:
                //             // "WiegandCode" => bin2hex(random_bytes(8)),
                //             // "RFIDTagUID" => random_int(1, 50),
                //             // "BTPhoneUID" => random_int(1, 50),
                //             // "RemoteUID" => random_int(1, 50),
                //             // "BiometricUID" => random_int(1, 50),
                //             "NumberPlate" => 'NU 254234',
                //             // "PinCode" => random_int(1000, 9999),
                //         ])
                //     ])
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Config" => new ConfigMessage([
                //         "AccessUserUpdate" => new AccessUser([
                //             "Id" => random_int(1, 99999),
                //             "FirstExitsThenEnters" => true,
                //             "RollOverExitToNextDay" => true,
                //             "EntriesMax" => 5,
                //             "ExitsMax" => 5,
                //             "StartDateTime" => timeMs(),
                //             "EndDateTime" => timeMs(),
                //             "AccessGroupIds" => [
                //                 random_int(1, 50000),
                //                 random_int(1, 50000),
                //                 random_int(1, 50000),
                //             ],
                //         ])
                //     ])
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Config" => new ConfigMessage([
                //         "AccessUserDelete" => new AccessUser([
                //             "Id" => random_int(1, 99999),
                //             "FirstExitsThenEnters" => true,
                //             "RollOverExitToNextDay" => true,
                //             "EntriesMax" => 5,
                //             "ExitsMax" => 5,
                //             "StartDateTime" => timeMs(),
                //             "EndDateTime" => timeMs(),
                //             "AccessGroupIds" => [
                //                 random_int(1, 50000),
                //                 random_int(1, 50000),
                //                 random_int(1, 50000),
                //             ],
                //         ])
                //     ])
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Config" => new ConfigMessage([
                //         "AccessGroupUpdate" => new AccessGroup([
                //             "Id" => random_int(1, 99999),
                //             "DaysOfWeekBits" => random_int(0, 7),
                //             "TimesOfDayBits" => random_int(0, 47),
                //             "AccessPeripheralIds" => [
                //                 random_int(1, 9999),
                //                 random_int(1, 9999),
                //                 random_int(1, 9999),
                //             ],
                //         ]),
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Config" => new ConfigMessage([
                //         "AccessGroupDelete" => new AccessGroup([
                //             "Id" => random_int(1, 99999),
                //             "DaysOfWeekBits" => random_int(0, 7),
                //             "TimesOfDayBits" => random_int(0, 47),
                //             "AccessPeripheralIds" => [
                //                 random_int(1, 9999),
                //                 random_int(1, 9999),
                //                 random_int(1, 9999),
                //             ],
                //         ]),
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Config" => new ConfigMessage([
                //         "AccessGateway" => new AccessGatewayConfig([
                //             "AccessDevicesHashModulo" => random_int(1, 64),
                //             "AccessGroupsHashModulo" => random_int(1, 10),
                //             "AccessUsersHashModulo" => random_int(1, 10),
                //             "AccessGatewayId" => random_int(1, 19999),
                //             // "AccessGatewayDirection" => AccessDirectionTypes::AccessDirection_NotSet,
                //             // "AccessGatewayDirection" => AccessDirectionTypes::AccessDirection_Both,
                //             "AccessGatewayDirection" => AccessDirectionTypes::AccessDirection_Entry,
                //             // "AccessGatewayDirection" => AccessDirectionTypes::AccessDirection_Exit,
                //             "AccessEnabled" => true,
                //         ]),
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Config" => new ConfigMessage([
                //         "AccessDevicesErase" => new AccessDevicesEraseConfig([
                //             "AreYouSure" => true,
                //         ]),
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Config" => new ConfigMessage([
                //         "AccessUsersErase" => new AccessUsersEraseConfig([
                //             "AreYouSure" => true,
                //         ]),
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Config" => new ConfigMessage([
                //         "AccessGroupsErase" => new AccessGroupsEraseConfig([
                //             "AreYouSure" => true,
                //         ]),
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Config" => new ConfigMessage([
                //         "EventRuleUpdate" => new EventRule([
                //             "Id" => random_int(1, 99999),
                //             "OnEvent" => new EventMessage([
                //                 "BleAssetTrack" => new BleAssetTrackEvent([
                //                     "New_id" => [
                //                         random_int(1, 999999),
                //                         random_int(1, 999999),
                //                         random_int(1, 999999),
                //                     ],
                //                     "New_macAddress" => [
                //                         $randomMac(),
                //                         $randomMac(),
                //                         $randomMac(),
                //                     ],
                //                     "New_rawData" => [
                //                         'a' . bin2hex(random_bytes(10)),
                //                         'b' . bin2hex(random_bytes(10)),
                //                         'c' . bin2hex(random_bytes(10)),
                //                     ],
                //                     "New_rssi" => [
                //                         random_int(-2500, 2500),
                //                         random_int(-2500, 2500),
                //                         random_int(-2500, 2500),
                //                     ],
                //                     "New_tsMinus" => [
                //                         random_int(1, 500),
                //                         random_int(1, 500),
                //                         random_int(1, 500),
                //                     ],
                //                     "Lost_id" => [
                //                         random_int(-2500, 2500),
                //                         random_int(-2500, 2500),
                //                         random_int(-2500, 2500),
                //                     ],
                //                     "Lost_rssi" => [
                //                         random_int(1, 2500),
                //                         random_int(1, 2500),
                //                         random_int(1, 2500),
                //                     ],
                //                     "Lost_tsMinus" => [
                //                         random_int(1, 400),
                //                         random_int(1, 400),
                //                         random_int(1, 400),
                //                     ],
                //                     "Current_id" => [
                //                         random_int(-250000, 250000),
                //                         random_int(-250000, 250000),
                //                         random_int(-250000, 250000),
                //                     ],
                //                     "Current_rssi" => [
                //                         random_int(-2500, 2500),
                //                         random_int(-2500, 2500),
                //                         random_int(-2500, 2500),
                //                     ]
                //                 ])
                //             ]),
                //             "PerformTheseActions" => [
                //                 new ActionMessage([
                //                     "WiegandLineActivate" => new WiegandLineActivateAction([
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_LineNotSet,
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_D0,
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_D1,
                //                         "LineOutput" => WiegandLineTypes::Wiegand_LED_Green,
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_LED_Red,
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_Buzzer,
                //                         "DurationMs" => random_int(500, 2500),
                //                     ]),
                //                 ]),
                //                 new ActionMessage([
                //                     "WiegandLineBlink" => new WiegandLineBlinkAction([
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_LineNotSet,
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_D0,
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_D1,
                //                         "LineOutput" => WiegandLineTypes::Wiegand_LED_Green,
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_LED_Red,
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_Buzzer,
                //                         "DurationMs" => random_int(100, 3500),
                //                         "PeriodOnMs" => random_int(100, 3500),
                //                         "PeriodOffMs" => random_int(100, 3500),
                //                     ]),
                //                 ]),
                //                 new ActionMessage([
                //                     "RelayActivate" => new RelayActivateAction([
                //                         "DurationMs" => random_int(100, 3500),
                //                     ]),
                //                 ]),
                //                 new ActionMessage([
                //                     "SystemRestart" => new SystemRestartAction([
                //                         // "RestartMethod" => RestartMethodType::RestartMethodNotSet,
                //                         // "RestartMethod" => RestartMethodType::RestartMethodGraceful,
                //                         "RestartMethod" => RestartMethodType::RestartMethodForceful,
                //                     ]),
                //                 ]),
                //             ],
                //             "DestinationSerial" => random_int(1, 9999),
                //             "DestinationAddress" => [
                //                 random_int(1, 9999999),
                //                 random_int(1, 9999999),
                //                 random_int(1, 9999999),
                //             ],
                //         ]),
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Config" => new ConfigMessage([
                //         "EventRuleDelete" => new EventRule([
                //             "Id" => random_int(1, 99999),
                //             "OnEvent" => new EventMessage([
                //                 "BleAssetTrack" => new BleAssetTrackEvent([
                //                     "New_id" => [
                //                         random_int(1, 999999),
                //                         random_int(1, 999999),
                //                         random_int(1, 999999),
                //                     ],
                //                     "New_macAddress" => [
                //                         $randomMac(),
                //                         $randomMac(),
                //                         $randomMac(),
                //                     ],
                //                     "New_rawData" => [
                //                         'a' . bin2hex(random_bytes(10)),
                //                         'b' . bin2hex(random_bytes(10)),
                //                         'c' . bin2hex(random_bytes(10)),
                //                     ],
                //                     "New_rssi" => [
                //                         random_int(-2500, 2500),
                //                         random_int(-2500, 2500),
                //                         random_int(-2500, 2500),
                //                     ],
                //                     "New_tsMinus" => [
                //                         random_int(1, 500),
                //                         random_int(1, 500),
                //                         random_int(1, 500),
                //                     ],
                //                     "Lost_id" => [
                //                         random_int(-2500, 2500),
                //                         random_int(-2500, 2500),
                //                         random_int(-2500, 2500),
                //                     ],
                //                     "Lost_rssi" => [
                //                         random_int(1, 2500),
                //                         random_int(1, 2500),
                //                         random_int(1, 2500),
                //                     ],
                //                     "Lost_tsMinus" => [
                //                         random_int(1, 400),
                //                         random_int(1, 400),
                //                         random_int(1, 400),
                //                     ],
                //                     "Current_id" => [
                //                         random_int(-250000, 250000),
                //                         random_int(-250000, 250000),
                //                         random_int(-250000, 250000),
                //                     ],
                //                     "Current_rssi" => [
                //                         random_int(-2500, 2500),
                //                         random_int(-2500, 2500),
                //                         random_int(-2500, 2500),
                //                     ]
                //                 ])
                //             ]),
                //             "PerformTheseActions" => [
                //                 new ActionMessage([
                //                     "WiegandLineActivate" => new WiegandLineActivateAction([
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_LineNotSet,
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_D0,
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_D1,
                //                         "LineOutput" => WiegandLineTypes::Wiegand_LED_Green,
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_LED_Red,
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_Buzzer,
                //                         "DurationMs" => random_int(500, 2500),
                //                     ]),
                //                 ]),
                //                 new ActionMessage([
                //                     "WiegandLineBlink" => new WiegandLineBlinkAction([
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_LineNotSet,
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_D0,
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_D1,
                //                         "LineOutput" => WiegandLineTypes::Wiegand_LED_Green,
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_LED_Red,
                //                         // "LineOutput" => WiegandLineTypes::Wiegand_Buzzer,
                //                         "DurationMs" => random_int(100, 3500),
                //                         "PeriodOnMs" => random_int(100, 3500),
                //                         "PeriodOffMs" => random_int(100, 3500),
                //                     ]),
                //                 ]),
                //                 new ActionMessage([
                //                     "RelayActivate" => new RelayActivateAction([
                //                         "DurationMs" => random_int(100, 3500),
                //                     ]),
                //                 ]),
                //                 new ActionMessage([
                //                     "SystemRestart" => new SystemRestartAction([
                //                         // "RestartMethod" => RestartMethodType::RestartMethodNotSet,
                //                         // "RestartMethod" => RestartMethodType::RestartMethodGraceful,
                //                         "RestartMethod" => RestartMethodType::RestartMethodForceful,
                //                     ]),
                //                 ]),
                //             ],
                //             "DestinationSerial" => random_int(1, 9999),
                //             "DestinationAddress" => [
                //                 random_int(1, 9999999),
                //                 random_int(1, 9999999),
                //                 random_int(1, 9999999),
                //             ],
                //         ]),
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Config" => new ConfigMessage([
                //         "NetworkAddress" => new NetworkAddressConfig([
                //             "Address" => random_int(268435456, 2576980377),
                //         ]),
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Config" => new ConfigMessage([
                //         "NetworkRouteUpdate" => new NetworkRouteConfig([
                //             "DestinationAddress" => random_int(268435456, 2576980377),
                //             "DestinationPort" => random_int(8000, 140000),
                //             "AddressRoute" => [
                //                 random_int(268435456, 2576980377),
                //                 random_int(268435456, 2576980377),
                //                 random_int(268435456, 2576980377),
                //             ],
                //         ]),
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Config" => new ConfigMessage([
                //         "NetworkRouteDelete" => new NetworkRouteConfig([
                //             "DestinationAddress" => random_int(268435456, 2576980377),
                //             "DestinationPort" => random_int(8000, 140000),
                //             "AddressRoute" => [
                //                 random_int(268435456, 2576980377),
                //                 random_int(268435456, 2576980377),
                //                 random_int(268435456, 2576980377),
                //             ],
                //         ]),
                //     ]),
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Config" => new ConfigMessage([
                //         "BlueToothPort" => new BlueToothPortConfig([
                //             "BeSecureService" => true
                //         ]),
                //     ]),
                // ]),


                /*******
                 * Log *
                 *******/

                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Log" => new LogMessage([
                //         "CoreDumpBin" => bin2hex(random_bytes(50)),
                //         "CoreDumpLog" => bin2hex(random_bytes(50)),
                //         "Debug" => "Debug: The message has been sent successfully"
                //     ])
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Log" => new LogMessage([
                //         "CoreDumpBin" => bin2hex(random_bytes(50)),
                //         "CoreDumpLog" => bin2hex(random_bytes(50)),
                //         "Info" => "Log: The message has been sent successfully"
                //     ])
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Log" => new LogMessage([
                //         "CoreDumpBin" => bin2hex(random_bytes(50)),
                //         "CoreDumpLog" => bin2hex(random_bytes(50)),
                //         "Warning" => "Warning: The message has been sent successfully"
                //     ])
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Log" => new LogMessage([
                //         "CoreDumpBin" => bin2hex(random_bytes(50)),
                //         "CoreDumpLog" => bin2hex(random_bytes(50)),
                //         "Error" => "Error: The message has been sent successfully"
                //     ])
                // ]),
                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Log" => new LogMessage([
                //         "CoreDumpBin" => bin2hex(random_bytes(50)),
                //         "CoreDumpLog" => bin2hex(random_bytes(50)),
                //         "Fatal" => "Fatal: The message has been sent successfully"
                //     ])
                // ]),


                /**********
                 * Metric *
                 **********/

                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Metric" => new MetricMessage([
                //         "Interval" => random_int(500, 2500),
                //         "Log" => new LogMetric([
                //             "InfoLogCount" => random_int(1, 4000),
                //             "WarningLogCount" => random_int(1, 4000),
                //             "ErrorLogCount" => random_int(1, 4000),
                //         ]),
                //         "RS485MainPort" => new RS485PortMetric([
                //             "BytesTransmitted" => random_int(1, 5000),
                //             "BytesReceived" => random_int(1, 5000),
                //             "BytesReceivedExclusive" => random_int(1, 5000),
                //             "ReceiveOverrunErrors" => random_int(1, 5000),
                //             "ReceiveFramingErrors" => random_int(1, 5000),
                //             "ReceiveBreakErrors" => random_int(1, 5000),
                //             "PacketsTransmitted" => random_int(1, 5000),
                //             "PacketsReceived" => random_int(1, 5000),
                //             "PacketsReceivedExclusive" => random_int(1, 5000),
                //             "PacketsACKed" => random_int(1, 5000),
                //             "PacketsNACKedCorrupted" => random_int(1, 5000),
                //             "PacketsCorruptedDiscarded" => random_int(1, 5000),
                //             "PacketsTimedOut" => random_int(1, 5000),
                //             "PacketsDecodingFailed" => random_int(1, 5000),
                //         ]),
                //         "WiegandPort1" => new WiegandPortMetric([
                //             "FailedParityChecks" => random_int(1, 5000),
                //         ]),
                //         "Access" => new AccessMetric([
                //             "AccessDeviceLookupTimeMin" => random_int(1, 5000),
                //             "AccessDeviceLookupTimeMax" => random_int(1, 5000),
                //             "AccessUserLookupTimeMin" => random_int(1, 5000),
                //             "AccessUserLookupTimeMax" => random_int(1, 5000),
                //             "AcesssGroupLookupTimeMin" => random_int(1, 5000),
                //             "AccessGroupLookupTimeMax" => random_int(1, 5000),
                //         ]),
                //         "Network" => new NetworkMetric([
                //             "LargestQueueMessageCount" => random_int(1, 5000),
                //             "NetworkQueues" => [
                //                 new NetworkQueueMetric([
                //                     "Address" => hexdec(bin2hex(random_bytes(8))),
                //                     "MessageCount" => random_int(1, 500),
                //                     "QueueSize" => random_int(1, 500),
                //                     "ExpiredMessages" => random_int(1, 5000),
                //                 ]),
                //             ],
                //         ]),
                //     ]),
                // ]),


                /***********
                 * Request *
                 ***********/

                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Request" => new RequestMessage([
                //         // "Method" => RequestMethodType::NotSet,
                //         // "Method" => RequestMethodType::Get,
                //         // "Method" => RequestMethodType::Post,
                //         // "Method" => RequestMethodType::Put,
                //         "Method" => RequestMethodType::Patch,
                //         // "Method" => RequestMethodType::Delete,
                //         // "Method" => RequestMethodType::Head,
                //         // "Method" => RequestMethodType::Options,

                //         // One of
                //         // "Raw" => bin2hex(random_bytes(10)),
                //         // "Binary" => bin2hex(random_bytes(10)),
                //         "Json" => json_encode([
                //             'cheese' => 'cake',
                //             'abc' => true,
                //             'def' => random_int(1, 25)
                //         ]),
                //         // "RequestId" => RequestIdTypes::Request_SystemFeatures
                //     ])
                // ]),


                /************
                 * Response *
                 ************/

                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "Response" => new ResponseMessage([
                //         "Code" => ResponseCode::Payload_Too_large,

                //         // One of
                //         // "Raw" => bin2hex(random_bytes(10)),
                //         // "Binary" => bin2hex(random_bytes(10)),
                //         // "Json" => json_encode([
                //         //     'cheese' => 'cake',
                //         //     'abc' => true,
                //         //     'def' => random_int(1, 25)
                //         // ]),
                //         // "SystemPing" => new SystemPingResponse([
                //         //     "ReceivedTimeStampMs" => random_int(500, 2500),
                //         // ]),
                //         "SystemHardwareInfo" => new SystemHardwareInfoResponse([
                //             "SerialNumber" => random_int(1, 3000),
                //             "BootFirmwareVersion" => implode('.', [
                //                 random_int(1, 3),
                //                 random_int(1, 18),
                //                 random_int(1, 25),
                //             ]),
                //             "AppFirmwareVersion" => implode('.', [
                //                 random_int(1, 3),
                //                 random_int(1, 18),
                //                 random_int(1, 25),
                //             ]),
                //             "HardwarePlatform" => 'AOH1000-007',
                //             "HardwareVersion" => random_int(1, 5),
                //             "ManufacturedDate" => time(),
                //             "InternalFileSystemSize" => random_int(50, 6000),
                //             "ExternalFileSystemSize" => random_int(300, 7000),
                //             "MCUUID" => random_int(1111111111, 9999999999),
                //             "MCUSocRevision" => random_int(1, 5000),
                //             "MCUPartId" => random_int(1, 5000),
                //             "BLEMAC" => $randomMac(),
                //             "BLECodedPhyPresent" => true,
                //             "EthernetMAC" => $randomMac(),
                //             "GSM_Modem_Manufacturer" => "Cheese Inc",
                //             "GSM_Modem_Model" => 'EC200U',
                //             "GSM_Modem_Revision" => 'EC200UCNAAR01A04M08',
                //             "GSM_Modem_IMEI" => bin2hex(random_bytes(4)),
                //             "GSM_Modem_SerialNumber" => bin2hex(random_bytes(6)),
                //             "GSM_SIM1_IMSI" => bin2hex(random_bytes(16)),
                //             "GSM_SIM1_ICCID" => bin2hex(random_bytes(20)),
                //             "GSM_SIM1_SubscriberNumber" => '+27761234567',
                //             "GSM_SIM2_IMSI" => bin2hex(random_bytes(16)),
                //             "GSM_SIM2_ICCID" => bin2hex(random_bytes(20)),
                //             "GSM_SIM2_SubscriberNumber" => '+27767654321',
                //         ]),
                //         // "SystemFeatures" => new SystemFeaturesResponse([
                //         //     "BLEPorts" => random_int(1, 3),
                //         //     "RS485Ports" => random_int(1, 3),
                //         //     "ModemPorts" => random_int(1, 3),
                //         //     "EthernetPorts" => random_int(1, 3),
                //         //     "WiegandPorts" => random_int(1, 3),
                //         //     "RelayPorts" => random_int(1, 3),
                //         //     "InputPorts" => random_int(1, 3),
                //         //     "ExpansionPorts" => random_int(1, 3),
                //         // ]),
                //     ]),
                // ]),


                /**********************
                 * Dead Leter Message *
                 **********************/

                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "DeadLetterMessage" => bin2hex(random_bytes(10)),
                // ]),


                /*****************
                 * Routed Packet *
                 *****************/

                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "RoutedPacket" => bin2hex(
                //         (new Packet([
                //             "PacketType" => PacketTypes::PacketType_Response_NACK_Corrupt,
                //             "DestinationAddressEx" => $dest,
                //             'SourceAddressEx' => $source,
                //             'SequenceNumber' => random_int(1, 10),
                //             'RedeliveryCounter' => random_int(1, 5),
                //             'TimeStampMs' => timeMs(),
                //             "Messages" => [
                //                 new Message([
                //                     "TimeStampMs" => timeMs(),
                //                     "TimeToLive" => 3600,
                //                     "CorrelationId" => random_int(1, 200),
                //                     "Config" => new ConfigMessage([
                //                         "AccessGroupDelete" => new AccessGroup([
                //                             "Id" => random_int(1, 99999),
                //                             "DaysOfWeekBits" => random_int(0, 7),
                //                             "TimesOfDayBits" => random_int(0, 47),
                //                             "AccessPeripheralIds" => [
                //                                 random_int(1, 9999),
                //                                 random_int(1, 9999),
                //                                 random_int(1, 9999),
                //                             ],
                //                         ]),
                //                     ]),
                //                 ]),
                //             ],
                //         ]))->serializeToString()
                //     ),
                // ]),


                /*******************
                 * BeSecure Packet *
                 *******************/

                // new Message([
                //     "TimeStampMs" => timeMs(),
                //     "TimeToLive" => 3600,
                //     "CorrelationId" => random_int(1, 200),
                //     "BeSecurePacket" => bin2hex(random_bytes(10)),
                // ]),


                /***********************
                 * System Audit Packet *
                 ***********************/

                new Message([
                    "TimeStampMs" => timeMs(),
                    "TimeToLive" => 3600,
                    "CorrelationId" => random_int(1, 200),
                    "SystemAuditPacket" => bin2hex(random_bytes(10)),
                ]),
            ],
        ]);

        $proto = new Proto();
        $serialized = $proto->protoPacketToUnserializedArray($p);

        return $this->asJson($serialized);
    }


    public function actionUnstream(): Response {
        $proto = new Proto();

        $body = Yii::$app->request->getRawBody();
        $data = $proto->jsonToSerializedArray($body);

        $packet = new Packet();
        $packet->mergeFromJsonString(json_encode($data));

        return $this->sendProtofbuf($packet->serializeToString());
    }
}
