<?php

namespace app\controllers\traits;

use app\models\Proto;
use Yii;
use yii\web\Response;

trait ProtobufSender {

    /**
     * Send an encoded protobuf binary as a HTTP response.
     * 
     * @param   string  $protobuf   The protobuf binary string.
     * 
     * @return  yii\web\Response
     * 
     * @access  public
     */

    public function sendProtofbuf(string $protobuf): Response {
        Yii::$app->response->format = Response::FORMAT_RAW;
        Yii::$app->response->headers->set('Content-Type', Proto::CONTENT_TYPE);
        Yii::$app->response->content = $protobuf;
        return Yii::$app->response;
    }
}
