<?php
$aliases = require __DIR__ . '/aliases.php';
// $db = require __DIR__ . '/db.php';
$params = require __DIR__ . '/params.php';

return [
    'id' => 'microservice-template',
    // the basePath of the application will be the `microservice-template` directory
    'basePath' => dirname(__DIR__),
    // this is where the application will find all controllers
    'controllerNamespace' => 'app\\commands',
    'aliases' => $aliases,
    'bootstrap' => ['log'],
    'params' => $params,
    'components' => [
        // 'db' => $db,
        // Enable logging for API
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets'  => [
                [
                    'class'  => 'yii\log\FileTarget',
                    'levels'  => ['error', 'warning'],
                    'logFile'  => '@logs/error.log'
                ],
            ],
        ],
        'cache' => [
            'class' => 'yii\caching\FileCache',
        ],
        'jwt' => [
            'class' => \bizley\jwt\Jwt::class,
            'signer' => \bizley\jwt\Jwt::RS256,
            /**
             * Key is set on the fly later using the `buildKey` method.
             * It does need to be set in class instantiation however
             * 
             * @see models/User.php:findIdentityByAccessToken()
             */
            'signingKey' => 'not used',
            'verifyingKey' => 'not used',
            'validationConstraints' => [
                new \Lcobucci\JWT\Validation\Constraint\LooseValidAt(
                    new \Lcobucci\Clock\SystemClock(new DateTimeZone('Africa/Johannesburg')),
                    \DateInterval::createFromDateString('30 minute')
                )
            ]
        ],
        'onespaceServiceClient' => [
            'class' => \app\components\OneSpaceServiceClient::class,
            'serviceGuid' => getenv('ONESPACE_SERVICE_GUID'),
            'serviceKey' => getenv('ONESPACE_SERVICE_AUTHKEY'),
        ],
    ],
];
