<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# NO CHECKED-IN PROTOBUF GENCODE
# source: event.proto

namespace OS\PB;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 **
 * \@brief   An event is when something happened, such as presenting a tag or triggering an input. 
 * \@details While events can be sent through a network, eventually to the server, they cannot be consumed by
 *          devices other than the original device that generated the event. 
 *          Events are classified into high and low usage types based on how often they occur
 *
 * Generated from protobuf message <code>OS.PB.EventMessage</code>
 */
class EventMessage extends \Google\Protobuf\Internal\Message
{
    /**
     * (Optional) The index of the interface the event occured on
     *
     * Generated from protobuf field <code>uint32 InterfaceIndex = 1;</code>
     */
    protected $InterfaceIndex = 0;
    protected $EventType;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $InterfaceIndex
     *           (Optional) The index of the interface the event occured on
     *     @type \OS\PB\WiegandEvent $WiegandRawCode
     *           high usage event types
     *     @type \OS\PB\WiegandEvent $WiegandPinCode
     *           1.4 such as a Wiegand Keypad reader in Key Bit Burst mode
     *     @type \OS\PB\BLEBeSecureEvent $BLEBeSecure
     *           0.9 for Connect mobile app mostly
     *     @type \OS\PB\OSDPEvent $RS485OSDPRawCode
     *          BLEPhoneEvent               BLEPhone                                = 5;
     *     @type \OS\PB\OSDPEvent $RS485OSDPPinCode
     *           1.0 such as a OSDP Keypad reader
     *     @type \OS\PB\CodeHopEvent $CodeHopSherlo
     *           1.4 Sherlo remote including the button code along with the remote id
     *     @type \OS\PB\RelayEvent $RelayStateChange
     *           CodeHopEvent           CodeHopCenturion                        = 9;  // TBC: Centurion Gate Remotes
     *     @type \OS\PB\InputEvent $InputStateChange
     *           1.4 When the input changes state
     *     @type \OS\PB\ANPREvent $RS485ANPRNumberPlate
     *           ANPR read a number plate
     *     @type \OS\PB\AccessEvent $AccessAllowed
     *           low usage event types
     *           OneAccess Application Events 20 to 99
     *     @type \OS\PB\AccessEvent $AccessConfirmed
     *           1.4 A Input activated event occurred which suggests the access gateway successfully opened the door/gate
     *     @type \OS\PB\AccessEvent $AccessUnconfirmed
     *           1.4 A relay deactivated event occured before the Input Activated Event with Access Confirmation
     *     @type \OS\PB\AccessEvent $AccessNoTouchDEPRECIATED
     *           1.4 The input was configured for No Touch (default), the event direction is Exit by default
     *     @type \OS\PB\AccessEvent $AccessPushButtonDEPRECIATED
     *           1.4 The input was configured for Push Button, the event direction is Exit by default
     *     @type \OS\PB\AccessEvent $AccessEmergencyButtonDEPRECIATED
     *           1.4 The input was configured for Emergency Button, the event direction is Exit by default
     *     @type \OS\PB\AccessEvent $AccessLoopDetectorDEPRECIATED
     *           1.4 The input was configured for Vehicle Loop Detector, the event direction is Exit by default
     *     @type \OS\PB\AccessEvent $AccessOverridden
     *           An event was received on a Reader Interface and access was allowed on the basis that access control was overridden
     *     @type \OS\PB\AccessEvent $AccessMethodDeniedUnknown
     *           0.9 The method could not be found in the database
     *     @type \OS\PB\AccessEvent $AccessMethodDeniedZeroUIDEvent
     *           0.9 The reader reported zero for this method, which is not allowed
     *     @type \OS\PB\AccessEvent $AccessMethodDeniedDaysOfWeek
     *           0.9 The method was denied based on its DoW configured
     *     @type \OS\PB\AccessEvent $AccessMethodDeniedNoRights
     *           0.9 The method has no access rights configured
     *     @type \OS\PB\AccessEvent $AccessMethodDeniedUserNotFound
     *           0.9 The associated user with this method was not found
     *     @type \OS\PB\AccessEvent $AccessMethodDeniedGatewayDisabled
     *           0.9 Gateway is disabled
     *     @type \OS\PB\AccessEvent $AccessMethodDeniedReaderUnknown
     *           0.9 Reader is unknown or not configured
     *     @type \OS\PB\AccessEvent $AccessMethodDeniedReaderDaysOfWeek
     *           Access Method Denied based on Days Of Week set with Gateway Reader Config
     *     @type \OS\PB\AccessEvent $AccessMethodDeniedReaderTimesOfDay
     *           Access Method Denied based on Times of Day set with Gateway Reader Config
     *     @type \OS\PB\AccessEvent $AccessRightsDeniedReader
     *           1.0 User not allowed access on this reader
     *     @type \OS\PB\AccessEvent $AccessRightsDeniedDaysOfWeek
     *           0.9 Access was denied based on the DoW Rights configured
     *     @type \OS\PB\AccessEvent $AccessRightsDeniedTimeOfDay
     *           0.9 Access was denied based on the ToD Rights configured
     *     @type \OS\PB\AccessEvent $AccessUserDeniedNoRights
     *           0.9 User does not have any access rights configured
     *     @type \OS\PB\AccessEvent $AccessUserDeniedNoEntriesLeft
     *           1.0 The visitor has no entries left
     *     @type \OS\PB\AccessEvent $AccessUserDeniedNoExitsLeft
     *           1.0 The visitor has no exits left
     *     @type \OS\PB\AccessEvent $AccessUserDeniedFutureDated
     *           1.0 The visitor does not have access yet
     *     @type \OS\PB\AccessEvent $AccessUserDeniedExpired
     *           1.0 The visitor no longer has access past the date and time
     *     @type \OS\PB\AccessEvent $AccessUserDeniedEntryAllExitsRedeemed
     *           1.1 The visitor has used all their exits and tried to enter
     *     @type \OS\PB\AccessEvent $AccessUserDeniedExitAllEntriesRedeemed
     *           1.1 The visitor has used all their entries and tried to exit, with FirstExitThenEnters enabled
     *     @type \OS\PB\ConfigSyncEvent $AccessSyncReady
     *           Generated when AccessSyncBegin Action is received, indicating it is ready to synchronize its database
     *     @type \OS\PB\ConfigSyncEvent $AccessSyncProgress
     *           Generated when a percentage point elapses on syncing a database if ProgressTotal is set in AccessSyncBegin
     *     @type \OS\PB\ConfigSyncEvent $AccessSyncDone
     *           Generated when AccessSyncEnd Action is received and once the database has swapped over to new one
     *     @type \OS\PB\ConfigSyncEvent $AccessSyncFailed
     *           Generated when Timeout or some other error occurs either on begin or while in progress
     *     @type \OS\PB\AccessDatabaseEvent $AccessCompacted
     *           Generated when compaction has completed
     *     @type \OS\PB\AccessDatabaseEvent $AccessCorruption
     *           Generated when corruption is detected in the access database, reports the totals OneAccess knows about
     *     @type \OS\PB\DeviceEvent $DeviceRestart
     *           OneDevice Application Events 300 to 499
     *     @type \OS\PB\DeviceEvent $DeviceFormat
     *           1.0 when a device has its non-volatile memory erased
     *     @type \OS\PB\DeviceNetworkEvent $DeviceConnected
     *           0.9 when a device makes a connection with server or peer network device
     *     @type \OS\PB\DeviceNetworkEvent $DeviceConnectionDenied
     *           1.4 gave a bad answer to a challenge or was refused connection on transport layer
     *     @type \OS\PB\DeviceNetworkEvent $DeviceConnectionMismatch
     *           1.4 the device in question gave an Id that was different from the routing config
     *     @type \OS\PB\DeviceNetworkEvent $DeviceUnconfigured
     *           the device's id changed from some number to 0, indicating it got factory defaulted                      
     *     @type \OS\PB\DeviceNetworkEvent $DeviceDisconnected
     *           0.9 when a device disconnects from server or another device
     *     @type \OS\PB\DeviceNetworkEvent $DeviceDisconnectedTimedOut
     *           0.9 the connection timedout
     *     @type \OS\PB\DeviceNetworkEvent $DeviceDisconnectedError
     *           0.9 software error caused a disconnect
     *     @type \OS\PB\DeviceNetworkEvent $DeviceDisconnectedRemoved
     *                  DeviceNetworkEvent   DeviceDisconnectedBadRoute              = 323;  // the device gave a NACK No Route to a Destination Device Id, route flagged as bad, lets cloud know and closes connection
     *     @type \OS\PB\DeviceNetworkEvent $DeviceDisconnectedChangingSims
     *           1.1 every day at 2am UTC, the LTE Gateway changes to the other SIM (due to MTN expiring unused SIMs)
     *     @type \OS\PB\DeviceNetworkEvent $DeviceDisconnectedLostNetwork
     *           1.1 every day at 2am UTC, the LTE Gateway changes to the other SIM (due to MTN expiring unused SIMs)
     *     @type \OS\PB\DeviceNetworkEvent $DeviceDiscovered
     *           1.4 discovered an unknown device advertising
     *     @type \OS\PB\DFUEvent $DFUInitiated
     *           1.1 The DFU process has been initated
     *     @type \OS\PB\DFUEvent $DFUDownloading
     *           1.1 The firmware is downloading
     *     @type \OS\PB\DFUEvent $DFUVerifying
     *           1.1 The firmware is verifying
     *     @type \OS\PB\DFUEvent $DFUValidating
     *           1.1 The device has updated its flash with new firmware, it is now seeing if there is no crashes or wierd issues
     *     @type \OS\PB\DFUEvent $DFUCompleted
     *           1.1 The device has completed the flashing of the new firmware and is running
     *     @type \OS\PB\DFUEvent $DFUFailed
     *           1.1 The device failed to update the firmware and cancelled/rolled back
     *     @type \OS\PB\OSDPEvent $RS485OSDPDeviceOffline
     *           1.0 The OSDP PD is offline and not responding to polls
     *     @type \OS\PB\OSDPEvent $RS485OSDPDeviceOnline
     *           1.0 The OSDP PD is online again. Only occurs if PD went offline first
     *     @type \OS\PB\OSDPEvent $RS485OSDPPinCodeIncomplete
     *           1.1 Incomplete pin code that did not meet KeypadDigits criteria and timedout or hashkey not pressed
     *     @type \OS\PB\WiegandEvent $WiegandPinCodeIncomplete
     *           1.4 Incomplete pin code that did not meet KeypadDigits criteria and timedout or hashkey not pressed
     *     @type \OS\PB\WiegandEvent $WiegandAntiTamper
     *           1.4 Impro keypads reports an Antitamper 0x0F when keypad is removed from base
     *     @type \OS\PB\ANPREvent $RS485ANPRNoPlate
     *           ANPR performed a read, but couldn't identity a number plate
     *     @type \OS\PB\CodeHopEvent $CodeHopEnroll
     *           If SendEnrollEvents is enabled in CodeHopRequest, it will send an event each time correct button is pushed
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Event::initOnce();
        parent::__construct($data);
    }

    /**
     * (Optional) The index of the interface the event occured on
     *
     * Generated from protobuf field <code>uint32 InterfaceIndex = 1;</code>
     * @return int
     */
    public function getInterfaceIndex()
    {
        return $this->InterfaceIndex;
    }

    /**
     * (Optional) The index of the interface the event occured on
     *
     * Generated from protobuf field <code>uint32 InterfaceIndex = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setInterfaceIndex($var)
    {
        GPBUtil::checkUint32($var);
        $this->InterfaceIndex = $var;

        return $this;
    }

    /**
     * high usage event types
     *
     * Generated from protobuf field <code>.OS.PB.WiegandEvent WiegandRawCode = 2;</code>
     * @return \OS\PB\WiegandEvent|null
     */
    public function getWiegandRawCode()
    {
        return $this->readOneof(2);
    }

    public function hasWiegandRawCode()
    {
        return $this->hasOneof(2);
    }

    /**
     * high usage event types
     *
     * Generated from protobuf field <code>.OS.PB.WiegandEvent WiegandRawCode = 2;</code>
     * @param \OS\PB\WiegandEvent $var
     * @return $this
     */
    public function setWiegandRawCode($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\WiegandEvent::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * 1.4 such as a Wiegand Keypad reader in Key Bit Burst mode
     *
     * Generated from protobuf field <code>.OS.PB.WiegandEvent WiegandPinCode = 3;</code>
     * @return \OS\PB\WiegandEvent|null
     */
    public function getWiegandPinCode()
    {
        return $this->readOneof(3);
    }

    public function hasWiegandPinCode()
    {
        return $this->hasOneof(3);
    }

    /**
     * 1.4 such as a Wiegand Keypad reader in Key Bit Burst mode
     *
     * Generated from protobuf field <code>.OS.PB.WiegandEvent WiegandPinCode = 3;</code>
     * @param \OS\PB\WiegandEvent $var
     * @return $this
     */
    public function setWiegandPinCode($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\WiegandEvent::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * 0.9 for Connect mobile app mostly
     *
     * Generated from protobuf field <code>.OS.PB.BLEBeSecureEvent BLEBeSecure = 4;</code>
     * @return \OS\PB\BLEBeSecureEvent|null
     */
    public function getBLEBeSecure()
    {
        return $this->readOneof(4);
    }

    public function hasBLEBeSecure()
    {
        return $this->hasOneof(4);
    }

    /**
     * 0.9 for Connect mobile app mostly
     *
     * Generated from protobuf field <code>.OS.PB.BLEBeSecureEvent BLEBeSecure = 4;</code>
     * @param \OS\PB\BLEBeSecureEvent $var
     * @return $this
     */
    public function setBLEBeSecure($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\BLEBeSecureEvent::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     *BLEPhoneEvent               BLEPhone                                = 5;
     *
     * Generated from protobuf field <code>.OS.PB.OSDPEvent RS485OSDPRawCode = 6;</code>
     * @return \OS\PB\OSDPEvent|null
     */
    public function getRS485OSDPRawCode()
    {
        return $this->readOneof(6);
    }

    public function hasRS485OSDPRawCode()
    {
        return $this->hasOneof(6);
    }

    /**
     *BLEPhoneEvent               BLEPhone                                = 5;
     *
     * Generated from protobuf field <code>.OS.PB.OSDPEvent RS485OSDPRawCode = 6;</code>
     * @param \OS\PB\OSDPEvent $var
     * @return $this
     */
    public function setRS485OSDPRawCode($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\OSDPEvent::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * 1.0 such as a OSDP Keypad reader
     *
     * Generated from protobuf field <code>.OS.PB.OSDPEvent RS485OSDPPinCode = 7;</code>
     * @return \OS\PB\OSDPEvent|null
     */
    public function getRS485OSDPPinCode()
    {
        return $this->readOneof(7);
    }

    public function hasRS485OSDPPinCode()
    {
        return $this->hasOneof(7);
    }

    /**
     * 1.0 such as a OSDP Keypad reader
     *
     * Generated from protobuf field <code>.OS.PB.OSDPEvent RS485OSDPPinCode = 7;</code>
     * @param \OS\PB\OSDPEvent $var
     * @return $this
     */
    public function setRS485OSDPPinCode($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\OSDPEvent::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * 1.4 Sherlo remote including the button code along with the remote id
     *
     * Generated from protobuf field <code>.OS.PB.CodeHopEvent CodeHopSherlo = 8;</code>
     * @return \OS\PB\CodeHopEvent|null
     */
    public function getCodeHopSherlo()
    {
        return $this->readOneof(8);
    }

    public function hasCodeHopSherlo()
    {
        return $this->hasOneof(8);
    }

    /**
     * 1.4 Sherlo remote including the button code along with the remote id
     *
     * Generated from protobuf field <code>.OS.PB.CodeHopEvent CodeHopSherlo = 8;</code>
     * @param \OS\PB\CodeHopEvent $var
     * @return $this
     */
    public function setCodeHopSherlo($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\CodeHopEvent::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * CodeHopEvent           CodeHopCenturion                        = 9;  // TBC: Centurion Gate Remotes
     *
     * Generated from protobuf field <code>.OS.PB.RelayEvent RelayStateChange = 10;</code>
     * @return \OS\PB\RelayEvent|null
     */
    public function getRelayStateChange()
    {
        return $this->readOneof(10);
    }

    public function hasRelayStateChange()
    {
        return $this->hasOneof(10);
    }

    /**
     * CodeHopEvent           CodeHopCenturion                        = 9;  // TBC: Centurion Gate Remotes
     *
     * Generated from protobuf field <code>.OS.PB.RelayEvent RelayStateChange = 10;</code>
     * @param \OS\PB\RelayEvent $var
     * @return $this
     */
    public function setRelayStateChange($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\RelayEvent::class);
        $this->writeOneof(10, $var);

        return $this;
    }

    /**
     * 1.4 When the input changes state
     *
     * Generated from protobuf field <code>.OS.PB.InputEvent InputStateChange = 11;</code>
     * @return \OS\PB\InputEvent|null
     */
    public function getInputStateChange()
    {
        return $this->readOneof(11);
    }

    public function hasInputStateChange()
    {
        return $this->hasOneof(11);
    }

    /**
     * 1.4 When the input changes state
     *
     * Generated from protobuf field <code>.OS.PB.InputEvent InputStateChange = 11;</code>
     * @param \OS\PB\InputEvent $var
     * @return $this
     */
    public function setInputStateChange($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\InputEvent::class);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * ANPR read a number plate
     *
     * Generated from protobuf field <code>.OS.PB.ANPREvent RS485ANPRNumberPlate = 12;</code>
     * @return \OS\PB\ANPREvent|null
     */
    public function getRS485ANPRNumberPlate()
    {
        return $this->readOneof(12);
    }

    public function hasRS485ANPRNumberPlate()
    {
        return $this->hasOneof(12);
    }

    /**
     * ANPR read a number plate
     *
     * Generated from protobuf field <code>.OS.PB.ANPREvent RS485ANPRNumberPlate = 12;</code>
     * @param \OS\PB\ANPREvent $var
     * @return $this
     */
    public function setRS485ANPRNumberPlate($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\ANPREvent::class);
        $this->writeOneof(12, $var);

        return $this;
    }

    /**
     * low usage event types
     * OneAccess Application Events 20 to 99
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessAllowed = 20;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessAllowed()
    {
        return $this->readOneof(20);
    }

    public function hasAccessAllowed()
    {
        return $this->hasOneof(20);
    }

    /**
     * low usage event types
     * OneAccess Application Events 20 to 99
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessAllowed = 20;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessAllowed($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(20, $var);

        return $this;
    }

    /**
     * 1.4 A Input activated event occurred which suggests the access gateway successfully opened the door/gate
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessConfirmed = 21;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessConfirmed()
    {
        return $this->readOneof(21);
    }

    public function hasAccessConfirmed()
    {
        return $this->hasOneof(21);
    }

    /**
     * 1.4 A Input activated event occurred which suggests the access gateway successfully opened the door/gate
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessConfirmed = 21;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessConfirmed($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(21, $var);

        return $this;
    }

    /**
     * 1.4 A relay deactivated event occured before the Input Activated Event with Access Confirmation
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessUnconfirmed = 22;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessUnconfirmed()
    {
        return $this->readOneof(22);
    }

    public function hasAccessUnconfirmed()
    {
        return $this->hasOneof(22);
    }

    /**
     * 1.4 A relay deactivated event occured before the Input Activated Event with Access Confirmation
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessUnconfirmed = 22;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessUnconfirmed($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(22, $var);

        return $this;
    }

    /**
     * 1.4 The input was configured for No Touch (default), the event direction is Exit by default
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessNoTouchDEPRECIATED = 23;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessNoTouchDEPRECIATED()
    {
        return $this->readOneof(23);
    }

    public function hasAccessNoTouchDEPRECIATED()
    {
        return $this->hasOneof(23);
    }

    /**
     * 1.4 The input was configured for No Touch (default), the event direction is Exit by default
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessNoTouchDEPRECIATED = 23;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessNoTouchDEPRECIATED($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(23, $var);

        return $this;
    }

    /**
     * 1.4 The input was configured for Push Button, the event direction is Exit by default
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessPushButtonDEPRECIATED = 24;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessPushButtonDEPRECIATED()
    {
        return $this->readOneof(24);
    }

    public function hasAccessPushButtonDEPRECIATED()
    {
        return $this->hasOneof(24);
    }

    /**
     * 1.4 The input was configured for Push Button, the event direction is Exit by default
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessPushButtonDEPRECIATED = 24;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessPushButtonDEPRECIATED($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(24, $var);

        return $this;
    }

    /**
     * 1.4 The input was configured for Emergency Button, the event direction is Exit by default
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessEmergencyButtonDEPRECIATED = 25;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessEmergencyButtonDEPRECIATED()
    {
        return $this->readOneof(25);
    }

    public function hasAccessEmergencyButtonDEPRECIATED()
    {
        return $this->hasOneof(25);
    }

    /**
     * 1.4 The input was configured for Emergency Button, the event direction is Exit by default
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessEmergencyButtonDEPRECIATED = 25;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessEmergencyButtonDEPRECIATED($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(25, $var);

        return $this;
    }

    /**
     * 1.4 The input was configured for Vehicle Loop Detector, the event direction is Exit by default
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessLoopDetectorDEPRECIATED = 26;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessLoopDetectorDEPRECIATED()
    {
        return $this->readOneof(26);
    }

    public function hasAccessLoopDetectorDEPRECIATED()
    {
        return $this->hasOneof(26);
    }

    /**
     * 1.4 The input was configured for Vehicle Loop Detector, the event direction is Exit by default
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessLoopDetectorDEPRECIATED = 26;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessLoopDetectorDEPRECIATED($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(26, $var);

        return $this;
    }

    /**
     * An event was received on a Reader Interface and access was allowed on the basis that access control was overridden
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessOverridden = 27;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessOverridden()
    {
        return $this->readOneof(27);
    }

    public function hasAccessOverridden()
    {
        return $this->hasOneof(27);
    }

    /**
     * An event was received on a Reader Interface and access was allowed on the basis that access control was overridden
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessOverridden = 27;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessOverridden($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(27, $var);

        return $this;
    }

    /**
     * 0.9 The method could not be found in the database
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedUnknown = 30;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessMethodDeniedUnknown()
    {
        return $this->readOneof(30);
    }

    public function hasAccessMethodDeniedUnknown()
    {
        return $this->hasOneof(30);
    }

    /**
     * 0.9 The method could not be found in the database
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedUnknown = 30;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessMethodDeniedUnknown($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(30, $var);

        return $this;
    }

    /**
     * 0.9 The reader reported zero for this method, which is not allowed
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedZeroUIDEvent = 31;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessMethodDeniedZeroUIDEvent()
    {
        return $this->readOneof(31);
    }

    public function hasAccessMethodDeniedZeroUIDEvent()
    {
        return $this->hasOneof(31);
    }

    /**
     * 0.9 The reader reported zero for this method, which is not allowed
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedZeroUIDEvent = 31;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessMethodDeniedZeroUIDEvent($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(31, $var);

        return $this;
    }

    /**
     * 0.9 The method was denied based on its DoW configured
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedDaysOfWeek = 32;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessMethodDeniedDaysOfWeek()
    {
        return $this->readOneof(32);
    }

    public function hasAccessMethodDeniedDaysOfWeek()
    {
        return $this->hasOneof(32);
    }

    /**
     * 0.9 The method was denied based on its DoW configured
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedDaysOfWeek = 32;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessMethodDeniedDaysOfWeek($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(32, $var);

        return $this;
    }

    /**
     * 0.9 The method has no access rights configured
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedNoRights = 33;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessMethodDeniedNoRights()
    {
        return $this->readOneof(33);
    }

    public function hasAccessMethodDeniedNoRights()
    {
        return $this->hasOneof(33);
    }

    /**
     * 0.9 The method has no access rights configured
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedNoRights = 33;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessMethodDeniedNoRights($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(33, $var);

        return $this;
    }

    /**
     * 0.9 The associated user with this method was not found
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedUserNotFound = 34;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessMethodDeniedUserNotFound()
    {
        return $this->readOneof(34);
    }

    public function hasAccessMethodDeniedUserNotFound()
    {
        return $this->hasOneof(34);
    }

    /**
     * 0.9 The associated user with this method was not found
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedUserNotFound = 34;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessMethodDeniedUserNotFound($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(34, $var);

        return $this;
    }

    /**
     * 0.9 Gateway is disabled
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedGatewayDisabled = 35;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessMethodDeniedGatewayDisabled()
    {
        return $this->readOneof(35);
    }

    public function hasAccessMethodDeniedGatewayDisabled()
    {
        return $this->hasOneof(35);
    }

    /**
     * 0.9 Gateway is disabled
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedGatewayDisabled = 35;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessMethodDeniedGatewayDisabled($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(35, $var);

        return $this;
    }

    /**
     * 0.9 Reader is unknown or not configured
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedReaderUnknown = 36;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessMethodDeniedReaderUnknown()
    {
        return $this->readOneof(36);
    }

    public function hasAccessMethodDeniedReaderUnknown()
    {
        return $this->hasOneof(36);
    }

    /**
     * 0.9 Reader is unknown or not configured
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedReaderUnknown = 36;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessMethodDeniedReaderUnknown($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(36, $var);

        return $this;
    }

    /**
     * Access Method Denied based on Days Of Week set with Gateway Reader Config
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedReaderDaysOfWeek = 37;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessMethodDeniedReaderDaysOfWeek()
    {
        return $this->readOneof(37);
    }

    public function hasAccessMethodDeniedReaderDaysOfWeek()
    {
        return $this->hasOneof(37);
    }

    /**
     * Access Method Denied based on Days Of Week set with Gateway Reader Config
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedReaderDaysOfWeek = 37;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessMethodDeniedReaderDaysOfWeek($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(37, $var);

        return $this;
    }

    /**
     * Access Method Denied based on Times of Day set with Gateway Reader Config
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedReaderTimesOfDay = 38;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessMethodDeniedReaderTimesOfDay()
    {
        return $this->readOneof(38);
    }

    public function hasAccessMethodDeniedReaderTimesOfDay()
    {
        return $this->hasOneof(38);
    }

    /**
     * Access Method Denied based on Times of Day set with Gateway Reader Config
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessMethodDeniedReaderTimesOfDay = 38;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessMethodDeniedReaderTimesOfDay($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(38, $var);

        return $this;
    }

    /**
     * 1.0 User not allowed access on this reader
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessRightsDeniedReader = 40;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessRightsDeniedReader()
    {
        return $this->readOneof(40);
    }

    public function hasAccessRightsDeniedReader()
    {
        return $this->hasOneof(40);
    }

    /**
     * 1.0 User not allowed access on this reader
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessRightsDeniedReader = 40;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessRightsDeniedReader($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(40, $var);

        return $this;
    }

    /**
     * 0.9 Access was denied based on the DoW Rights configured
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessRightsDeniedDaysOfWeek = 41;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessRightsDeniedDaysOfWeek()
    {
        return $this->readOneof(41);
    }

    public function hasAccessRightsDeniedDaysOfWeek()
    {
        return $this->hasOneof(41);
    }

    /**
     * 0.9 Access was denied based on the DoW Rights configured
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessRightsDeniedDaysOfWeek = 41;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessRightsDeniedDaysOfWeek($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(41, $var);

        return $this;
    }

    /**
     * 0.9 Access was denied based on the ToD Rights configured
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessRightsDeniedTimeOfDay = 42;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessRightsDeniedTimeOfDay()
    {
        return $this->readOneof(42);
    }

    public function hasAccessRightsDeniedTimeOfDay()
    {
        return $this->hasOneof(42);
    }

    /**
     * 0.9 Access was denied based on the ToD Rights configured
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessRightsDeniedTimeOfDay = 42;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessRightsDeniedTimeOfDay($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(42, $var);

        return $this;
    }

    /**
     * 0.9 User does not have any access rights configured
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessUserDeniedNoRights = 50;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessUserDeniedNoRights()
    {
        return $this->readOneof(50);
    }

    public function hasAccessUserDeniedNoRights()
    {
        return $this->hasOneof(50);
    }

    /**
     * 0.9 User does not have any access rights configured
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessUserDeniedNoRights = 50;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessUserDeniedNoRights($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(50, $var);

        return $this;
    }

    /**
     * 1.0 The visitor has no entries left
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessUserDeniedNoEntriesLeft = 51;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessUserDeniedNoEntriesLeft()
    {
        return $this->readOneof(51);
    }

    public function hasAccessUserDeniedNoEntriesLeft()
    {
        return $this->hasOneof(51);
    }

    /**
     * 1.0 The visitor has no entries left
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessUserDeniedNoEntriesLeft = 51;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessUserDeniedNoEntriesLeft($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(51, $var);

        return $this;
    }

    /**
     * 1.0 The visitor has no exits left
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessUserDeniedNoExitsLeft = 52;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessUserDeniedNoExitsLeft()
    {
        return $this->readOneof(52);
    }

    public function hasAccessUserDeniedNoExitsLeft()
    {
        return $this->hasOneof(52);
    }

    /**
     * 1.0 The visitor has no exits left
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessUserDeniedNoExitsLeft = 52;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessUserDeniedNoExitsLeft($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(52, $var);

        return $this;
    }

    /**
     * 1.0 The visitor does not have access yet
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessUserDeniedFutureDated = 53;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessUserDeniedFutureDated()
    {
        return $this->readOneof(53);
    }

    public function hasAccessUserDeniedFutureDated()
    {
        return $this->hasOneof(53);
    }

    /**
     * 1.0 The visitor does not have access yet
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessUserDeniedFutureDated = 53;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessUserDeniedFutureDated($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(53, $var);

        return $this;
    }

    /**
     * 1.0 The visitor no longer has access past the date and time
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessUserDeniedExpired = 54;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessUserDeniedExpired()
    {
        return $this->readOneof(54);
    }

    public function hasAccessUserDeniedExpired()
    {
        return $this->hasOneof(54);
    }

    /**
     * 1.0 The visitor no longer has access past the date and time
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessUserDeniedExpired = 54;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessUserDeniedExpired($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(54, $var);

        return $this;
    }

    /**
     * 1.1 The visitor has used all their exits and tried to enter
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessUserDeniedEntryAllExitsRedeemed = 55;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessUserDeniedEntryAllExitsRedeemed()
    {
        return $this->readOneof(55);
    }

    public function hasAccessUserDeniedEntryAllExitsRedeemed()
    {
        return $this->hasOneof(55);
    }

    /**
     * 1.1 The visitor has used all their exits and tried to enter
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessUserDeniedEntryAllExitsRedeemed = 55;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessUserDeniedEntryAllExitsRedeemed($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(55, $var);

        return $this;
    }

    /**
     * 1.1 The visitor has used all their entries and tried to exit, with FirstExitThenEnters enabled
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessUserDeniedExitAllEntriesRedeemed = 56;</code>
     * @return \OS\PB\AccessEvent|null
     */
    public function getAccessUserDeniedExitAllEntriesRedeemed()
    {
        return $this->readOneof(56);
    }

    public function hasAccessUserDeniedExitAllEntriesRedeemed()
    {
        return $this->hasOneof(56);
    }

    /**
     * 1.1 The visitor has used all their entries and tried to exit, with FirstExitThenEnters enabled
     *
     * Generated from protobuf field <code>.OS.PB.AccessEvent AccessUserDeniedExitAllEntriesRedeemed = 56;</code>
     * @param \OS\PB\AccessEvent $var
     * @return $this
     */
    public function setAccessUserDeniedExitAllEntriesRedeemed($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessEvent::class);
        $this->writeOneof(56, $var);

        return $this;
    }

    /**
     * Generated when AccessSyncBegin Action is received, indicating it is ready to synchronize its database
     *
     * Generated from protobuf field <code>.OS.PB.ConfigSyncEvent AccessSyncReady = 90;</code>
     * @return \OS\PB\ConfigSyncEvent|null
     */
    public function getAccessSyncReady()
    {
        return $this->readOneof(90);
    }

    public function hasAccessSyncReady()
    {
        return $this->hasOneof(90);
    }

    /**
     * Generated when AccessSyncBegin Action is received, indicating it is ready to synchronize its database
     *
     * Generated from protobuf field <code>.OS.PB.ConfigSyncEvent AccessSyncReady = 90;</code>
     * @param \OS\PB\ConfigSyncEvent $var
     * @return $this
     */
    public function setAccessSyncReady($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\ConfigSyncEvent::class);
        $this->writeOneof(90, $var);

        return $this;
    }

    /**
     * Generated when a percentage point elapses on syncing a database if ProgressTotal is set in AccessSyncBegin
     *
     * Generated from protobuf field <code>.OS.PB.ConfigSyncEvent AccessSyncProgress = 91;</code>
     * @return \OS\PB\ConfigSyncEvent|null
     */
    public function getAccessSyncProgress()
    {
        return $this->readOneof(91);
    }

    public function hasAccessSyncProgress()
    {
        return $this->hasOneof(91);
    }

    /**
     * Generated when a percentage point elapses on syncing a database if ProgressTotal is set in AccessSyncBegin
     *
     * Generated from protobuf field <code>.OS.PB.ConfigSyncEvent AccessSyncProgress = 91;</code>
     * @param \OS\PB\ConfigSyncEvent $var
     * @return $this
     */
    public function setAccessSyncProgress($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\ConfigSyncEvent::class);
        $this->writeOneof(91, $var);

        return $this;
    }

    /**
     * Generated when AccessSyncEnd Action is received and once the database has swapped over to new one
     *
     * Generated from protobuf field <code>.OS.PB.ConfigSyncEvent AccessSyncDone = 95;</code>
     * @return \OS\PB\ConfigSyncEvent|null
     */
    public function getAccessSyncDone()
    {
        return $this->readOneof(95);
    }

    public function hasAccessSyncDone()
    {
        return $this->hasOneof(95);
    }

    /**
     * Generated when AccessSyncEnd Action is received and once the database has swapped over to new one
     *
     * Generated from protobuf field <code>.OS.PB.ConfigSyncEvent AccessSyncDone = 95;</code>
     * @param \OS\PB\ConfigSyncEvent $var
     * @return $this
     */
    public function setAccessSyncDone($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\ConfigSyncEvent::class);
        $this->writeOneof(95, $var);

        return $this;
    }

    /**
     * Generated when Timeout or some other error occurs either on begin or while in progress
     *
     * Generated from protobuf field <code>.OS.PB.ConfigSyncEvent AccessSyncFailed = 96;</code>
     * @return \OS\PB\ConfigSyncEvent|null
     */
    public function getAccessSyncFailed()
    {
        return $this->readOneof(96);
    }

    public function hasAccessSyncFailed()
    {
        return $this->hasOneof(96);
    }

    /**
     * Generated when Timeout or some other error occurs either on begin or while in progress
     *
     * Generated from protobuf field <code>.OS.PB.ConfigSyncEvent AccessSyncFailed = 96;</code>
     * @param \OS\PB\ConfigSyncEvent $var
     * @return $this
     */
    public function setAccessSyncFailed($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\ConfigSyncEvent::class);
        $this->writeOneof(96, $var);

        return $this;
    }

    /**
     * Generated when compaction has completed
     *
     * Generated from protobuf field <code>.OS.PB.AccessDatabaseEvent AccessCompacted = 98;</code>
     * @return \OS\PB\AccessDatabaseEvent|null
     */
    public function getAccessCompacted()
    {
        return $this->readOneof(98);
    }

    public function hasAccessCompacted()
    {
        return $this->hasOneof(98);
    }

    /**
     * Generated when compaction has completed
     *
     * Generated from protobuf field <code>.OS.PB.AccessDatabaseEvent AccessCompacted = 98;</code>
     * @param \OS\PB\AccessDatabaseEvent $var
     * @return $this
     */
    public function setAccessCompacted($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessDatabaseEvent::class);
        $this->writeOneof(98, $var);

        return $this;
    }

    /**
     * Generated when corruption is detected in the access database, reports the totals OneAccess knows about
     *
     * Generated from protobuf field <code>.OS.PB.AccessDatabaseEvent AccessCorruption = 99;</code>
     * @return \OS\PB\AccessDatabaseEvent|null
     */
    public function getAccessCorruption()
    {
        return $this->readOneof(99);
    }

    public function hasAccessCorruption()
    {
        return $this->hasOneof(99);
    }

    /**
     * Generated when corruption is detected in the access database, reports the totals OneAccess knows about
     *
     * Generated from protobuf field <code>.OS.PB.AccessDatabaseEvent AccessCorruption = 99;</code>
     * @param \OS\PB\AccessDatabaseEvent $var
     * @return $this
     */
    public function setAccessCorruption($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\AccessDatabaseEvent::class);
        $this->writeOneof(99, $var);

        return $this;
    }

    /**
     * OneDevice Application Events 300 to 499
     *
     * Generated from protobuf field <code>.OS.PB.DeviceEvent DeviceRestart = 300;</code>
     * @return \OS\PB\DeviceEvent|null
     */
    public function getDeviceRestart()
    {
        return $this->readOneof(300);
    }

    public function hasDeviceRestart()
    {
        return $this->hasOneof(300);
    }

    /**
     * OneDevice Application Events 300 to 499
     *
     * Generated from protobuf field <code>.OS.PB.DeviceEvent DeviceRestart = 300;</code>
     * @param \OS\PB\DeviceEvent $var
     * @return $this
     */
    public function setDeviceRestart($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DeviceEvent::class);
        $this->writeOneof(300, $var);

        return $this;
    }

    /**
     * 1.0 when a device has its non-volatile memory erased
     *
     * Generated from protobuf field <code>.OS.PB.DeviceEvent DeviceFormat = 301;</code>
     * @return \OS\PB\DeviceEvent|null
     */
    public function getDeviceFormat()
    {
        return $this->readOneof(301);
    }

    public function hasDeviceFormat()
    {
        return $this->hasOneof(301);
    }

    /**
     * 1.0 when a device has its non-volatile memory erased
     *
     * Generated from protobuf field <code>.OS.PB.DeviceEvent DeviceFormat = 301;</code>
     * @param \OS\PB\DeviceEvent $var
     * @return $this
     */
    public function setDeviceFormat($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DeviceEvent::class);
        $this->writeOneof(301, $var);

        return $this;
    }

    /**
     * 0.9 when a device makes a connection with server or peer network device
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceConnected = 310;</code>
     * @return \OS\PB\DeviceNetworkEvent|null
     */
    public function getDeviceConnected()
    {
        return $this->readOneof(310);
    }

    public function hasDeviceConnected()
    {
        return $this->hasOneof(310);
    }

    /**
     * 0.9 when a device makes a connection with server or peer network device
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceConnected = 310;</code>
     * @param \OS\PB\DeviceNetworkEvent $var
     * @return $this
     */
    public function setDeviceConnected($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DeviceNetworkEvent::class);
        $this->writeOneof(310, $var);

        return $this;
    }

    /**
     * 1.4 gave a bad answer to a challenge or was refused connection on transport layer
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceConnectionDenied = 311;</code>
     * @return \OS\PB\DeviceNetworkEvent|null
     */
    public function getDeviceConnectionDenied()
    {
        return $this->readOneof(311);
    }

    public function hasDeviceConnectionDenied()
    {
        return $this->hasOneof(311);
    }

    /**
     * 1.4 gave a bad answer to a challenge or was refused connection on transport layer
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceConnectionDenied = 311;</code>
     * @param \OS\PB\DeviceNetworkEvent $var
     * @return $this
     */
    public function setDeviceConnectionDenied($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DeviceNetworkEvent::class);
        $this->writeOneof(311, $var);

        return $this;
    }

    /**
     * 1.4 the device in question gave an Id that was different from the routing config
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceConnectionMismatch = 312;</code>
     * @return \OS\PB\DeviceNetworkEvent|null
     */
    public function getDeviceConnectionMismatch()
    {
        return $this->readOneof(312);
    }

    public function hasDeviceConnectionMismatch()
    {
        return $this->hasOneof(312);
    }

    /**
     * 1.4 the device in question gave an Id that was different from the routing config
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceConnectionMismatch = 312;</code>
     * @param \OS\PB\DeviceNetworkEvent $var
     * @return $this
     */
    public function setDeviceConnectionMismatch($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DeviceNetworkEvent::class);
        $this->writeOneof(312, $var);

        return $this;
    }

    /**
     * the device's id changed from some number to 0, indicating it got factory defaulted                      
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceUnconfigured = 315;</code>
     * @return \OS\PB\DeviceNetworkEvent|null
     */
    public function getDeviceUnconfigured()
    {
        return $this->readOneof(315);
    }

    public function hasDeviceUnconfigured()
    {
        return $this->hasOneof(315);
    }

    /**
     * the device's id changed from some number to 0, indicating it got factory defaulted                      
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceUnconfigured = 315;</code>
     * @param \OS\PB\DeviceNetworkEvent $var
     * @return $this
     */
    public function setDeviceUnconfigured($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DeviceNetworkEvent::class);
        $this->writeOneof(315, $var);

        return $this;
    }

    /**
     * 0.9 when a device disconnects from server or another device
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceDisconnected = 320;</code>
     * @return \OS\PB\DeviceNetworkEvent|null
     */
    public function getDeviceDisconnected()
    {
        return $this->readOneof(320);
    }

    public function hasDeviceDisconnected()
    {
        return $this->hasOneof(320);
    }

    /**
     * 0.9 when a device disconnects from server or another device
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceDisconnected = 320;</code>
     * @param \OS\PB\DeviceNetworkEvent $var
     * @return $this
     */
    public function setDeviceDisconnected($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DeviceNetworkEvent::class);
        $this->writeOneof(320, $var);

        return $this;
    }

    /**
     * 0.9 the connection timedout
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceDisconnectedTimedOut = 321;</code>
     * @return \OS\PB\DeviceNetworkEvent|null
     */
    public function getDeviceDisconnectedTimedOut()
    {
        return $this->readOneof(321);
    }

    public function hasDeviceDisconnectedTimedOut()
    {
        return $this->hasOneof(321);
    }

    /**
     * 0.9 the connection timedout
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceDisconnectedTimedOut = 321;</code>
     * @param \OS\PB\DeviceNetworkEvent $var
     * @return $this
     */
    public function setDeviceDisconnectedTimedOut($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DeviceNetworkEvent::class);
        $this->writeOneof(321, $var);

        return $this;
    }

    /**
     * 0.9 software error caused a disconnect
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceDisconnectedError = 322;</code>
     * @return \OS\PB\DeviceNetworkEvent|null
     */
    public function getDeviceDisconnectedError()
    {
        return $this->readOneof(322);
    }

    public function hasDeviceDisconnectedError()
    {
        return $this->hasOneof(322);
    }

    /**
     * 0.9 software error caused a disconnect
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceDisconnectedError = 322;</code>
     * @param \OS\PB\DeviceNetworkEvent $var
     * @return $this
     */
    public function setDeviceDisconnectedError($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DeviceNetworkEvent::class);
        $this->writeOneof(322, $var);

        return $this;
    }

    /**
     *        DeviceNetworkEvent   DeviceDisconnectedBadRoute              = 323;  // the device gave a NACK No Route to a Destination Device Id, route flagged as bad, lets cloud know and closes connection
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceDisconnectedRemoved = 324;</code>
     * @return \OS\PB\DeviceNetworkEvent|null
     */
    public function getDeviceDisconnectedRemoved()
    {
        return $this->readOneof(324);
    }

    public function hasDeviceDisconnectedRemoved()
    {
        return $this->hasOneof(324);
    }

    /**
     *        DeviceNetworkEvent   DeviceDisconnectedBadRoute              = 323;  // the device gave a NACK No Route to a Destination Device Id, route flagged as bad, lets cloud know and closes connection
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceDisconnectedRemoved = 324;</code>
     * @param \OS\PB\DeviceNetworkEvent $var
     * @return $this
     */
    public function setDeviceDisconnectedRemoved($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DeviceNetworkEvent::class);
        $this->writeOneof(324, $var);

        return $this;
    }

    /**
     * 1.1 every day at 2am UTC, the LTE Gateway changes to the other SIM (due to MTN expiring unused SIMs)
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceDisconnectedChangingSims = 325;</code>
     * @return \OS\PB\DeviceNetworkEvent|null
     */
    public function getDeviceDisconnectedChangingSims()
    {
        return $this->readOneof(325);
    }

    public function hasDeviceDisconnectedChangingSims()
    {
        return $this->hasOneof(325);
    }

    /**
     * 1.1 every day at 2am UTC, the LTE Gateway changes to the other SIM (due to MTN expiring unused SIMs)
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceDisconnectedChangingSims = 325;</code>
     * @param \OS\PB\DeviceNetworkEvent $var
     * @return $this
     */
    public function setDeviceDisconnectedChangingSims($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DeviceNetworkEvent::class);
        $this->writeOneof(325, $var);

        return $this;
    }

    /**
     * 1.1 every day at 2am UTC, the LTE Gateway changes to the other SIM (due to MTN expiring unused SIMs)
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceDisconnectedLostNetwork = 326;</code>
     * @return \OS\PB\DeviceNetworkEvent|null
     */
    public function getDeviceDisconnectedLostNetwork()
    {
        return $this->readOneof(326);
    }

    public function hasDeviceDisconnectedLostNetwork()
    {
        return $this->hasOneof(326);
    }

    /**
     * 1.1 every day at 2am UTC, the LTE Gateway changes to the other SIM (due to MTN expiring unused SIMs)
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceDisconnectedLostNetwork = 326;</code>
     * @param \OS\PB\DeviceNetworkEvent $var
     * @return $this
     */
    public function setDeviceDisconnectedLostNetwork($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DeviceNetworkEvent::class);
        $this->writeOneof(326, $var);

        return $this;
    }

    /**
     * 1.4 discovered an unknown device advertising
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceDiscovered = 327;</code>
     * @return \OS\PB\DeviceNetworkEvent|null
     */
    public function getDeviceDiscovered()
    {
        return $this->readOneof(327);
    }

    public function hasDeviceDiscovered()
    {
        return $this->hasOneof(327);
    }

    /**
     * 1.4 discovered an unknown device advertising
     *
     * Generated from protobuf field <code>.OS.PB.DeviceNetworkEvent DeviceDiscovered = 327;</code>
     * @param \OS\PB\DeviceNetworkEvent $var
     * @return $this
     */
    public function setDeviceDiscovered($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DeviceNetworkEvent::class);
        $this->writeOneof(327, $var);

        return $this;
    }

    /**
     * 1.1 The DFU process has been initated
     *
     * Generated from protobuf field <code>.OS.PB.DFUEvent DFUInitiated = 350;</code>
     * @return \OS\PB\DFUEvent|null
     */
    public function getDFUInitiated()
    {
        return $this->readOneof(350);
    }

    public function hasDFUInitiated()
    {
        return $this->hasOneof(350);
    }

    /**
     * 1.1 The DFU process has been initated
     *
     * Generated from protobuf field <code>.OS.PB.DFUEvent DFUInitiated = 350;</code>
     * @param \OS\PB\DFUEvent $var
     * @return $this
     */
    public function setDFUInitiated($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DFUEvent::class);
        $this->writeOneof(350, $var);

        return $this;
    }

    /**
     * 1.1 The firmware is downloading
     *
     * Generated from protobuf field <code>.OS.PB.DFUEvent DFUDownloading = 15;</code>
     * @return \OS\PB\DFUEvent|null
     */
    public function getDFUDownloading()
    {
        return $this->readOneof(15);
    }

    public function hasDFUDownloading()
    {
        return $this->hasOneof(15);
    }

    /**
     * 1.1 The firmware is downloading
     *
     * Generated from protobuf field <code>.OS.PB.DFUEvent DFUDownloading = 15;</code>
     * @param \OS\PB\DFUEvent $var
     * @return $this
     */
    public function setDFUDownloading($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DFUEvent::class);
        $this->writeOneof(15, $var);

        return $this;
    }

    /**
     * 1.1 The firmware is verifying
     *
     * Generated from protobuf field <code>.OS.PB.DFUEvent DFUVerifying = 352;</code>
     * @return \OS\PB\DFUEvent|null
     */
    public function getDFUVerifying()
    {
        return $this->readOneof(352);
    }

    public function hasDFUVerifying()
    {
        return $this->hasOneof(352);
    }

    /**
     * 1.1 The firmware is verifying
     *
     * Generated from protobuf field <code>.OS.PB.DFUEvent DFUVerifying = 352;</code>
     * @param \OS\PB\DFUEvent $var
     * @return $this
     */
    public function setDFUVerifying($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DFUEvent::class);
        $this->writeOneof(352, $var);

        return $this;
    }

    /**
     * 1.1 The device has updated its flash with new firmware, it is now seeing if there is no crashes or wierd issues
     *
     * Generated from protobuf field <code>.OS.PB.DFUEvent DFUValidating = 353;</code>
     * @return \OS\PB\DFUEvent|null
     */
    public function getDFUValidating()
    {
        return $this->readOneof(353);
    }

    public function hasDFUValidating()
    {
        return $this->hasOneof(353);
    }

    /**
     * 1.1 The device has updated its flash with new firmware, it is now seeing if there is no crashes or wierd issues
     *
     * Generated from protobuf field <code>.OS.PB.DFUEvent DFUValidating = 353;</code>
     * @param \OS\PB\DFUEvent $var
     * @return $this
     */
    public function setDFUValidating($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DFUEvent::class);
        $this->writeOneof(353, $var);

        return $this;
    }

    /**
     * 1.1 The device has completed the flashing of the new firmware and is running
     *
     * Generated from protobuf field <code>.OS.PB.DFUEvent DFUCompleted = 354;</code>
     * @return \OS\PB\DFUEvent|null
     */
    public function getDFUCompleted()
    {
        return $this->readOneof(354);
    }

    public function hasDFUCompleted()
    {
        return $this->hasOneof(354);
    }

    /**
     * 1.1 The device has completed the flashing of the new firmware and is running
     *
     * Generated from protobuf field <code>.OS.PB.DFUEvent DFUCompleted = 354;</code>
     * @param \OS\PB\DFUEvent $var
     * @return $this
     */
    public function setDFUCompleted($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DFUEvent::class);
        $this->writeOneof(354, $var);

        return $this;
    }

    /**
     * 1.1 The device failed to update the firmware and cancelled/rolled back
     *
     * Generated from protobuf field <code>.OS.PB.DFUEvent DFUFailed = 355;</code>
     * @return \OS\PB\DFUEvent|null
     */
    public function getDFUFailed()
    {
        return $this->readOneof(355);
    }

    public function hasDFUFailed()
    {
        return $this->hasOneof(355);
    }

    /**
     * 1.1 The device failed to update the firmware and cancelled/rolled back
     *
     * Generated from protobuf field <code>.OS.PB.DFUEvent DFUFailed = 355;</code>
     * @param \OS\PB\DFUEvent $var
     * @return $this
     */
    public function setDFUFailed($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DFUEvent::class);
        $this->writeOneof(355, $var);

        return $this;
    }

    /**
     * 1.0 The OSDP PD is offline and not responding to polls
     *
     * Generated from protobuf field <code>.OS.PB.OSDPEvent RS485OSDPDeviceOffline = 360;</code>
     * @return \OS\PB\OSDPEvent|null
     */
    public function getRS485OSDPDeviceOffline()
    {
        return $this->readOneof(360);
    }

    public function hasRS485OSDPDeviceOffline()
    {
        return $this->hasOneof(360);
    }

    /**
     * 1.0 The OSDP PD is offline and not responding to polls
     *
     * Generated from protobuf field <code>.OS.PB.OSDPEvent RS485OSDPDeviceOffline = 360;</code>
     * @param \OS\PB\OSDPEvent $var
     * @return $this
     */
    public function setRS485OSDPDeviceOffline($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\OSDPEvent::class);
        $this->writeOneof(360, $var);

        return $this;
    }

    /**
     * 1.0 The OSDP PD is online again. Only occurs if PD went offline first
     *
     * Generated from protobuf field <code>.OS.PB.OSDPEvent RS485OSDPDeviceOnline = 361;</code>
     * @return \OS\PB\OSDPEvent|null
     */
    public function getRS485OSDPDeviceOnline()
    {
        return $this->readOneof(361);
    }

    public function hasRS485OSDPDeviceOnline()
    {
        return $this->hasOneof(361);
    }

    /**
     * 1.0 The OSDP PD is online again. Only occurs if PD went offline first
     *
     * Generated from protobuf field <code>.OS.PB.OSDPEvent RS485OSDPDeviceOnline = 361;</code>
     * @param \OS\PB\OSDPEvent $var
     * @return $this
     */
    public function setRS485OSDPDeviceOnline($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\OSDPEvent::class);
        $this->writeOneof(361, $var);

        return $this;
    }

    /**
     * 1.1 Incomplete pin code that did not meet KeypadDigits criteria and timedout or hashkey not pressed
     *
     * Generated from protobuf field <code>.OS.PB.OSDPEvent RS485OSDPPinCodeIncomplete = 365;</code>
     * @return \OS\PB\OSDPEvent|null
     */
    public function getRS485OSDPPinCodeIncomplete()
    {
        return $this->readOneof(365);
    }

    public function hasRS485OSDPPinCodeIncomplete()
    {
        return $this->hasOneof(365);
    }

    /**
     * 1.1 Incomplete pin code that did not meet KeypadDigits criteria and timedout or hashkey not pressed
     *
     * Generated from protobuf field <code>.OS.PB.OSDPEvent RS485OSDPPinCodeIncomplete = 365;</code>
     * @param \OS\PB\OSDPEvent $var
     * @return $this
     */
    public function setRS485OSDPPinCodeIncomplete($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\OSDPEvent::class);
        $this->writeOneof(365, $var);

        return $this;
    }

    /**
     * 1.4 Incomplete pin code that did not meet KeypadDigits criteria and timedout or hashkey not pressed
     *
     * Generated from protobuf field <code>.OS.PB.WiegandEvent WiegandPinCodeIncomplete = 370;</code>
     * @return \OS\PB\WiegandEvent|null
     */
    public function getWiegandPinCodeIncomplete()
    {
        return $this->readOneof(370);
    }

    public function hasWiegandPinCodeIncomplete()
    {
        return $this->hasOneof(370);
    }

    /**
     * 1.4 Incomplete pin code that did not meet KeypadDigits criteria and timedout or hashkey not pressed
     *
     * Generated from protobuf field <code>.OS.PB.WiegandEvent WiegandPinCodeIncomplete = 370;</code>
     * @param \OS\PB\WiegandEvent $var
     * @return $this
     */
    public function setWiegandPinCodeIncomplete($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\WiegandEvent::class);
        $this->writeOneof(370, $var);

        return $this;
    }

    /**
     * 1.4 Impro keypads reports an Antitamper 0x0F when keypad is removed from base
     *
     * Generated from protobuf field <code>.OS.PB.WiegandEvent WiegandAntiTamper = 371;</code>
     * @return \OS\PB\WiegandEvent|null
     */
    public function getWiegandAntiTamper()
    {
        return $this->readOneof(371);
    }

    public function hasWiegandAntiTamper()
    {
        return $this->hasOneof(371);
    }

    /**
     * 1.4 Impro keypads reports an Antitamper 0x0F when keypad is removed from base
     *
     * Generated from protobuf field <code>.OS.PB.WiegandEvent WiegandAntiTamper = 371;</code>
     * @param \OS\PB\WiegandEvent $var
     * @return $this
     */
    public function setWiegandAntiTamper($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\WiegandEvent::class);
        $this->writeOneof(371, $var);

        return $this;
    }

    /**
     * ANPR performed a read, but couldn't identity a number plate
     *
     * Generated from protobuf field <code>.OS.PB.ANPREvent RS485ANPRNoPlate = 375;</code>
     * @return \OS\PB\ANPREvent|null
     */
    public function getRS485ANPRNoPlate()
    {
        return $this->readOneof(375);
    }

    public function hasRS485ANPRNoPlate()
    {
        return $this->hasOneof(375);
    }

    /**
     * ANPR performed a read, but couldn't identity a number plate
     *
     * Generated from protobuf field <code>.OS.PB.ANPREvent RS485ANPRNoPlate = 375;</code>
     * @param \OS\PB\ANPREvent $var
     * @return $this
     */
    public function setRS485ANPRNoPlate($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\ANPREvent::class);
        $this->writeOneof(375, $var);

        return $this;
    }

    /**
     * If SendEnrollEvents is enabled in CodeHopRequest, it will send an event each time correct button is pushed
     *
     * Generated from protobuf field <code>.OS.PB.CodeHopEvent CodeHopEnroll = 380;</code>
     * @return \OS\PB\CodeHopEvent|null
     */
    public function getCodeHopEnroll()
    {
        return $this->readOneof(380);
    }

    public function hasCodeHopEnroll()
    {
        return $this->hasOneof(380);
    }

    /**
     * If SendEnrollEvents is enabled in CodeHopRequest, it will send an event each time correct button is pushed
     *
     * Generated from protobuf field <code>.OS.PB.CodeHopEvent CodeHopEnroll = 380;</code>
     * @param \OS\PB\CodeHopEvent $var
     * @return $this
     */
    public function setCodeHopEnroll($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\CodeHopEvent::class);
        $this->writeOneof(380, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getEventType()
    {
        return $this->whichOneof("EventType");
    }

}

