<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: device.proto

namespace OS\PB;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 ** &#64;brief  Configures a route to another device, based on its DestinationDeviceId
 * &#64;version 0.9, full implementation from 1.4
 * &#64;details This is for a journal database where one or more networking routes is defined for a DestinationDeviceId (primary key)
 *          and can be updated or deleted at will by the cloud.
 *          
 *          Each device's routing config table only contains the routes of the next device it should know about. 
 *          From 1.4: The maximum number of DeviceRoutes that can be specified is 3 for a single destination.
 *          Each DeviceRoute must contain DeviceId, Interface, InterfaceIndex, SerialAddress as this creates a connection
 *          on the interface and index specified, only if it doesn't exist yet. 
 *          The connection starts out as disconnected and if a packet is received with its SourceSerial and SourceDeviceId 
 *          matching, then a connection process is started with the device.
 *          Once connected, then this DeviceRoute will be used for sending packets on to the DestinationDeviceId.
 *          When sending to a DestinationDeviceId, the routes are attempted in order as the way have been defined in the RoutingConfig repeated Routes field.
 *          If the connection that a route specifies is not in a connected state, then it moves onto the next route.
 *          If that connection is already busy sending some other packet, then it waits for the connection to be free before trying again.
 *          If some other error occurs, then it moves onto the next route.
 *
 * Generated from protobuf message <code>OS.PB.DeviceRoute</code>
 */
class DeviceRoute extends \Google\Protobuf\Internal\Message
{
    /**
     * The DeviceId of the device to route to
     *
     * Generated from protobuf field <code>uint64 DeviceId = 1;</code>
     */
    protected $DeviceId = 0;
    /**
     * Which interface this route is to talk on, cannot be NotSet or on interfaces which are not networkable
     *
     * Generated from protobuf field <code>.OS.PB.DeviceInterface Interface = 2;</code>
     */
    protected $Interface = 0;
    /**
     * Usually 0 for the first interface, but if a device contains two or more of the same interface, then this must be specified
     *
     * Generated from protobuf field <code>uint32 InterfaceIndex = 3;</code>
     */
    protected $InterfaceIndex = 0;
    /**
     * The Serial Address of the device to connect to
     *
     * Generated from protobuf field <code>uint32 SerialAddress = 10;</code>
     */
    protected $SerialAddress = 0;
    protected $AddressType;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $DeviceId
     *           The DeviceId of the device to route to
     *     @type int $Interface
     *           Which interface this route is to talk on, cannot be NotSet or on interfaces which are not networkable
     *     @type int $InterfaceIndex
     *           Usually 0 for the first interface, but if a device contains two or more of the same interface, then this must be specified
     *     @type int $SerialAddress
     *           The Serial Address of the device to connect to
     *     @type string $MACAddress
     *           1.4 MAC. BLE or WiFi Peer Address. Big-endian. Fixed 6 byte address.
     *     @type \OS\PB\DeviceMQTTAddress $MQTTAddress
     *           MQTT connection to a broker 
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Device::initOnce();
        parent::__construct($data);
    }

    /**
     * The DeviceId of the device to route to
     *
     * Generated from protobuf field <code>uint64 DeviceId = 1;</code>
     * @return int|string
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }

    /**
     * The DeviceId of the device to route to
     *
     * Generated from protobuf field <code>uint64 DeviceId = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setDeviceId($var)
    {
        GPBUtil::checkUint64($var);
        $this->DeviceId = $var;

        return $this;
    }

    /**
     * Which interface this route is to talk on, cannot be NotSet or on interfaces which are not networkable
     *
     * Generated from protobuf field <code>.OS.PB.DeviceInterface Interface = 2;</code>
     * @return int
     */
    public function getInterface()
    {
        return $this->Interface;
    }

    /**
     * Which interface this route is to talk on, cannot be NotSet or on interfaces which are not networkable
     *
     * Generated from protobuf field <code>.OS.PB.DeviceInterface Interface = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setInterface($var)
    {
        GPBUtil::checkEnum($var, \OS\PB\DeviceInterface::class);
        $this->Interface = $var;

        return $this;
    }

    /**
     * Usually 0 for the first interface, but if a device contains two or more of the same interface, then this must be specified
     *
     * Generated from protobuf field <code>uint32 InterfaceIndex = 3;</code>
     * @return int
     */
    public function getInterfaceIndex()
    {
        return $this->InterfaceIndex;
    }

    /**
     * Usually 0 for the first interface, but if a device contains two or more of the same interface, then this must be specified
     *
     * Generated from protobuf field <code>uint32 InterfaceIndex = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setInterfaceIndex($var)
    {
        GPBUtil::checkUint32($var);
        $this->InterfaceIndex = $var;

        return $this;
    }

    /**
     * The Serial Address of the device to connect to
     *
     * Generated from protobuf field <code>uint32 SerialAddress = 10;</code>
     * @return int
     */
    public function getSerialAddress()
    {
        return $this->SerialAddress;
    }

    /**
     * The Serial Address of the device to connect to
     *
     * Generated from protobuf field <code>uint32 SerialAddress = 10;</code>
     * @param int $var
     * @return $this
     */
    public function setSerialAddress($var)
    {
        GPBUtil::checkUint32($var);
        $this->SerialAddress = $var;

        return $this;
    }

    /**
     * 1.4 MAC. BLE or WiFi Peer Address. Big-endian. Fixed 6 byte address.
     *
     * Generated from protobuf field <code>bytes MACAddress = 11;</code>
     * @return string
     */
    public function getMACAddress()
    {
        return $this->readOneof(11);
    }

    public function hasMACAddress()
    {
        return $this->hasOneof(11);
    }

    /**
     * 1.4 MAC. BLE or WiFi Peer Address. Big-endian. Fixed 6 byte address.
     *
     * Generated from protobuf field <code>bytes MACAddress = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setMACAddress($var)
    {
        GPBUtil::checkString($var, False);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * MQTT connection to a broker 
     *
     * Generated from protobuf field <code>.OS.PB.DeviceMQTTAddress MQTTAddress = 12;</code>
     * @return \OS\PB\DeviceMQTTAddress|null
     */
    public function getMQTTAddress()
    {
        return $this->readOneof(12);
    }

    public function hasMQTTAddress()
    {
        return $this->hasOneof(12);
    }

    /**
     * MQTT connection to a broker 
     *
     * Generated from protobuf field <code>.OS.PB.DeviceMQTTAddress MQTTAddress = 12;</code>
     * @param \OS\PB\DeviceMQTTAddress $var
     * @return $this
     */
    public function setMQTTAddress($var)
    {
        GPBUtil::checkMessage($var, \OS\PB\DeviceMQTTAddress::class);
        $this->writeOneof(12, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getAddressType()
    {
        return $this->whichOneof("AddressType");
    }

}

