<?php

namespace onespace\tools\icons\widgets;

use onespace\tools\icons\widgets\base\FAHelper;
use onespace\tools\icons\widgets\base\Icon;

/**
 * Generate FontAwesome 5 library icons as a widget.
 * 
 * To use this widget, you need to register `\onespace\tools\icons\assets\FontAwesome5Asset::class` in `AppAssets`.
 * 
 * @property    string|null $identifier See `https://fontawesome.com/v5/search`
 * @property    string|null $style
 * ## Valid Style Options
 * - solid
 * - regular
 * - brand
 * - light
 * @property    string|null $colour
 * ## Valid Colour Options
 * - light-blue
 * - aqua
 * - green
 * - yellow
 * - red
 * - gray
 * - navy
 * - teal
 * - purple
 * - orange
 * - maroon
 * - black
 * @property    string  $content    Default: `&nbsp;`
 * 
 * @author  Jason Phillips <jason@one-space.co.za>
 * 
 * @deprecated 2023-11-24 - Use `onespace\tools\icons\widgets\FontAwesomeIcon6`
 */

final class FontAwesomeIcon extends Icon {

    use FAHelper;

    protected const STYLES = [
        'solid'   => 'fas',
        'regular' => 'far',
        'brand'   => 'fab',
        'light'   => 'fal',
    ];
}
