<?php

namespace onespace\tools\enum\oneaccess;

use onespace\tools\enum\base\UnbackedHelper;

enum ReaderType {
    use UnbackedHelper;

    case BLUETOOTH;
    case GENERAL;
    case ANPR;
    case CODEHOP;

    private function config(string $key): string|int {
        $config = match ($this) {
            self::BLUETOOTH => [
                'id' => 1,
                'name' => 'Bluetooth',
            ],
            self::GENERAL => [
                'id' => 2,
                'name' => 'General',
            ],
            self::ANPR => [
                'id' => 3,
                'name' => 'ANPR',
            ],
            self::CODEHOP => [
                'id' => 4,
                'name' => 'codeHop',
            ],
        };
        return $config[$key];
    }

    public function id(): int {
        return $this->config('id');
    }

    public function name(): string {
        return $this->config('name');
    }
}
