<?php

namespace onespace\tools\enum\oneaccess;

use onespace\tools\enum\base\UnbackedHelper;

enum ReaderType {
    use UnbackedHelper;

    case BLUETOOTH;
    case OSDP;
    case ANPR;

    private function config(string $key): string|int {
        $config = match ($this) {
            self::BLUETOOTH => [
                'id' => 1,
                'name' => 'Bluetooth',
            ],
            self::OSDP => [
                'id' => 2,
                'name' => 'OSDP',
            ],
            self::ANPR => [
                'id' => 3,
                'name' => 'ANPR',
            ],
        };
        return $config[$key];
    }

    public function id(): int {
        return $this->config('id');
    }

    public function name(): string {
        return $this->config('name');
    }
}
