<?php

namespace onespace\tools\enum\base;

use BackedEnum;
use UnitEnum;

trait ListableEnumTrait {
    public static function values(): array {
        if (in_array(BackedEnum::class, class_implements(static::class))) {
            return array_column(static::cases(), 'value');
        } elseif (in_array(UnitEnum::class, class_implements(static::class))) {
            return array_column(static::cases(), 'name');
        } else {
            return [];
        }
    }

    public static function names(): array {
        if (in_array(BackedEnum::class, class_implements(static::class))) {
            return array_column(static::cases(), 'name');
        } elseif (in_array(UnitEnum::class, class_implements(static::class))) {
            return array_column(static::cases(), 'name');
        } else {
            return [];
        }
    }

    public static function list(): array {
        return array_combine(self::values(), self::names());
    }
}
